/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates;

import java.util.List;
import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.Library;
import org.eclipse.edt.mof.egl.ParameterizedType;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.IRUtils;

public class EGLClassTemplate
extends JavaTemplate {
    public void validateClassBody(EGLClass part, Context ctx, Object ... args) {
        ctx.validate("validateUsedParts", (Classifier)part, (EglContext)ctx, args);
        ctx.validate("validateFields", (Classifier)part, (EglContext)ctx, args);
        ctx.validate("validateFunctions", (Classifier)part, (EglContext)ctx, args);
    }

    public void validateUsedParts(EGLClass part, Context ctx, Object ... args) {
        for (Part item : IRUtils.getReferencedPartsFor((Part)part)) {
            ctx.validate("validateUsedPart", (Classifier)part, (EglContext)ctx, new Object[]{item});
        }
    }

    public void validateUsedPart(EGLClass part, Context ctx, Object ... args) {
        ctx.validate("validate", (Classifier)((Part)args[0]), (EglContext)ctx, args);
    }

    public void validateFields(EGLClass part, Context ctx, Object ... args) {
        for (Field field : part.getFields()) {
            ctx.validate("validateField", (Classifier)part, (EglContext)ctx, new Object[]{field});
        }
    }

    public void validateField(EGLClass part, Context ctx, Object ... args) {
        ctx.validate("validate", (Element)((Field)args[0]), (EglContext)ctx, args);
    }

    public void validateFunctions(EGLClass part, Context ctx, Object ... args) {
        for (Function function : part.getFunctions()) {
            ctx.validate("validateFunction", (Classifier)part, (EglContext)ctx, new Object[]{function});
        }
    }

    public void validateFunction(EGLClass part, Context ctx, Object ... args) {
        ctx.validate("validate", (Element)((Function)args[0]), (EglContext)ctx, args);
    }

    public void genClassHeader(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        out.print("public class ");
        ctx.gen("genClassName", (Classifier)part, (EglContext)ctx, out, args);
        out.print(" extends ");
        ctx.gen("genSuperClass", (Classifier)part, (EglContext)ctx, out, args);
        out.println(" {");
        ctx.gen("genSerialVersionUID", (Classifier)part, (EglContext)ctx, out, args);
    }

    public void genClassBody(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        ctx.gen("genFields", (Classifier)part, (EglContext)ctx, out, args);
        ctx.gen("genLibraries", (Classifier)part, (EglContext)ctx, out, args);
        ctx.gen("genConstructors", (Classifier)part, (EglContext)ctx, out, args);
        ctx.gen("genInitializeMethods", (Classifier)part, (EglContext)ctx, out, args);
        ctx.gen("genGetterSetters", (Classifier)part, (EglContext)ctx, out, args);
        ctx.gen("genLibraryAccessMethods", (Classifier)part, (EglContext)ctx, out, args);
        ctx.gen("genFunctions", (Classifier)part, (EglContext)ctx, out, args);
    }

    public void genFields(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        for (Field field : part.getFields()) {
            ctx.gen("genField", (Classifier)part, (EglContext)ctx, out, new Object[]{field});
        }
        boolean needConstraints = false;
        for (Field field : part.getFields()) {
            if (!(field.getType() instanceof ParameterizedType)) continue;
            needConstraints = true;
            break;
        }
        if (needConstraints) {
            out.println("private static java.util.HashMap<String, TypeConstraints> ezeTypeConstraints = new java.util.HashMap<String, TypeConstraints>();");
            out.println("static {");
            for (Field field : part.getFields()) {
                if (!(field.getType() instanceof ParameterizedType)) continue;
                out.print("ezeTypeConstraints.put(\"");
                ctx.gen("genName", (EObject)field, (TemplateContext)ctx, out, args);
                out.print("\", new TypeConstraints(");
                ctx.gen("genRuntimeConstraint", field.getType(), (EglContext)ctx, out, args);
                out.println("));");
            }
            out.println("}");
        }
    }

    public void genField(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        ctx.gen("genDeclaration", (EObject)((Field)args[0]), (TemplateContext)ctx, out, args);
    }

    public void genLibraries(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        List libraries = (List)ctx.getAttribute(ctx.getClass(), "partLibrariesUsed");
        for (Library library : libraries) {
            ctx.gen("genLibrary", (Classifier)part, (EglContext)ctx, out, new Object[]{library});
        }
    }

    public void genLibrary(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        out.print("public ");
        ctx.gen("genRuntimeTypeName", (Type)args[0], (EglContext)ctx, out, new Object[]{JavaTemplate.TypeNameKind.EGLImplementation});
        out.println(" eze_Lib_" + ((Library)args[0]).getFullyQualifiedName().replace('.', '_') + ";");
    }

    public void genConstructors(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        ctx.gen("genConstructor", (Classifier)part, (EglContext)ctx, out, args);
    }

    public void genConstructor(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
    }

    public void genInitializeMethods(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        out.println("public void ezeInitialize() {");
        ctx.gen("genInitializeMethodBody", (Classifier)part, (EglContext)ctx, out, args);
        out.println("}");
    }

    public void genInitializeMethodBody(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        for (Field field : part.getFields()) {
            ctx.gen("genInitializeMethod", (Classifier)part, (EglContext)ctx, out, new Object[]{field});
        }
    }

    public void genInitializeMethod(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        if (((Field)args[0]).getInitializerStatements() != null) {
            ctx.gen("genStatementNoBraces", (Statement)((Field)args[0]).getInitializerStatements(), (TemplateContext)ctx, out, args);
        } else {
            ctx.gen("genName", (EObject)((Field)args[0]), (TemplateContext)ctx, out, args);
            out.print(" = ");
            ctx.gen("genInitialization", (EObject)((Field)args[0]), (TemplateContext)ctx, out, args);
            out.println(";");
        }
    }

    public void genGetterSetters(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        for (Field field : part.getFields()) {
            ctx.gen("genGetterSetter", (Classifier)part, (EglContext)ctx, out, new Object[]{field});
        }
    }

    public void genGetterSetter(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
    }

    public void genLibraryAccessMethods(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        List libraries = (List)ctx.getAttribute(ctx.getClass(), "partLibrariesUsed");
        for (Library library : libraries) {
            ctx.gen("genLibraryAccessMethod", (Classifier)part, (EglContext)ctx, out, new Object[]{library});
        }
    }

    public void genLibraryAccessMethod(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        out.print("public ");
        ctx.gen("genRuntimeTypeName", (Type)((Library)args[0]), (EglContext)ctx, out, new Object[]{JavaTemplate.TypeNameKind.EGLImplementation});
        out.println(" eze_Lib_" + ((Library)args[0]).getFullyQualifiedName().replace('.', '_') + "() {");
        out.println("if (eze_Lib_" + ((Library)args[0]).getFullyQualifiedName().replace('.', '_') + " == null) {");
        out.print("eze_Lib_" + ((Library)args[0]).getFullyQualifiedName().replace('.', '_') + " = (");
        ctx.gen("genRuntimeTypeName", (Type)((Library)args[0]), (EglContext)ctx, out, new Object[]{JavaTemplate.TypeNameKind.EGLImplementation});
        out.print(") _runUnit().getExecutable(\"");
        ctx.gen("genRuntimeTypeName", (Type)((Library)args[0]), (EglContext)ctx, out, new Object[]{JavaTemplate.TypeNameKind.EGLImplementation});
        out.println("\");");
        out.println("}");
        out.println("return eze_Lib_" + ((Library)args[0]).getFullyQualifiedName().replace('.', '_') + ";");
        out.println("}");
    }

    public void genFunctions(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        for (Function function : part.getFunctions()) {
            ctx.gen("genFunction", (Classifier)part, (EglContext)ctx, out, new Object[]{function});
        }
    }

    public void genFunction(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        ctx.gen("genDeclaration", (EObject)((Function)args[0]), (TemplateContext)ctx, out, args);
    }

    public void genAdditionalConstructorParams(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
    }

    public void genAdditionalSuperConstructorArgs(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
    }

    public void genDeclaration(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
    }

    public void genSuperClass(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
    }
}

