/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.internal.core.utils.Aliaser;
import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.gen.java.CommonUtilities;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.IRUtils;

public class PartTemplate
extends JavaTemplate {
    IRUtils utils = new IRUtils();

    public void validatePart(Part part, Context ctx, Object ... args) {
        ctx.putAttribute(ctx.getClass(), "partDataTablesUsed", new ArrayList());
        ctx.putAttribute(ctx.getClass(), "partFormsUsed", new ArrayList());
        ctx.putAttribute(ctx.getClass(), "partLibrariesUsed", new ArrayList());
        ctx.putAttribute(ctx.getClass(), "partRecordsUsed", new ArrayList());
        ctx.putAttribute(ctx.getClass(), "partTypesImported", new ArrayList());
        ctx.validate("validateClassBody", (Classifier)part, (EglContext)ctx, args);
    }

    public void genPart(Part part, Context ctx, TabbedWriter out, Object ... args) {
        this.genPackageStatement(part, ctx, out, args);
        ctx.gen("genClassHeader", (Classifier)part, (EglContext)ctx, out, args);
        ctx.gen("genClassBody", (Classifier)part, (EglContext)ctx, out, args);
        out.println("}");
    }

    public void genPackageStatement(Part part, Context ctx, TabbedWriter out, Object ... args) {
        String packageName = CommonUtilities.packageName((Part)part);
        if (packageName != null && packageName.length() > 0) {
            out.print("package ");
            out.print(packageName);
            out.println(";");
        }
        out.println("import org.eclipse.edt.javart.resources.*;");
        out.println("import org.eclipse.edt.javart.*;");
        List typesImported = (List)ctx.getAttribute(ctx.getClass(), "partTypesImported");
        for (String imported : typesImported) {
            out.println("import " + imported + ";");
        }
    }

    public void genPartName(Part part, Context ctx, TabbedWriter out, Object ... args) {
        if (ctx.mapsToNativeType((Type)part)) {
            out.print(ctx.getNativeImplementationMapping((Type)part));
        } else {
            String value = part.getClassifier().getTypeSignature();
            List typesImported = (List)ctx.getAttribute(ctx.getClass(), "partTypesImported");
            for (String imported : typesImported) {
                if (!value.equalsIgnoreCase(imported)) continue;
                if (value.indexOf(46) < 0) break;
                value = value.substring(value.lastIndexOf(46) + 1);
                break;
            }
            out.print(value);
        }
    }

    public void genClassName(Part part, Context ctx, TabbedWriter out, Object ... args) {
        Annotation annot = part.getAnnotation("alias");
        String nameOrAlias = annot != null ? (String)annot.getValue() : part.getId();
        out.print(Aliaser.getAlias((String)nameOrAlias));
    }

    public void genSuperClass(Part part, Context ctx, TabbedWriter out, Object ... args) {
        ctx.gen("genSuperClass", (Classifier)part, (EglContext)ctx, out, args);
    }

    public void genSerialVersionUID(Part part, Context ctx, TabbedWriter out, Object ... args) {
        out.println("private static final long serialVersionUID = 80L;");
    }
}

