/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates;

import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.gen.ReorganizeCode;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StatementBlock;
import org.eclipse.edt.mof.egl.utils.IRUtils;

public class StatementBlockTemplate
extends JavaTemplate {
    public void validate(StatementBlock block, Context ctx, Object ... args) {
        for (Statement stmt : block.getStatements()) {
            ctx.validate("validate", (Element)stmt, (EglContext)ctx, args);
        }
    }

    public void genStatementBody(StatementBlock block, Context ctx, TabbedWriter out, Object ... args) {
        out.println("{");
        this.processStatements(block, ctx, out, args);
        out.println("}");
    }

    public void genStatementBodyNoBraces(StatementBlock block, Context ctx, TabbedWriter out, Object ... args) {
        this.processStatements(block, ctx, out, args);
    }

    public void genStatementEnd(StatementBlock block, Context ctx, TabbedWriter out, Object ... args) {
    }

    protected void processStatements(StatementBlock block, Context ctx, TabbedWriter out, Object ... args) {
        ctx.setCurrentFile(IRUtils.getFileName((EObject)block));
        Iterator iterator = block.getStatements().iterator();
        while (iterator.hasNext()) {
            ReorganizeCode reorganizeCode = new ReorganizeCode();
            Statement stmt = (Statement)iterator.next();
            List blockArray = reorganizeCode.reorgCode(stmt, (EglContext)ctx);
            if (blockArray != null && blockArray.get(0) != null) {
                ctx.gen("genStatementNoBraces", (Statement)blockArray.get(0), (TemplateContext)ctx, out, args);
            }
            ctx.gen("genStatement", stmt, (TemplateContext)ctx, out, args);
            if (blockArray == null || blockArray.get(1) == null) continue;
            ctx.gen("genStatementNoBraces", (Statement)blockArray.get(1), (TemplateContext)ctx, out, args);
        }
    }
}

