/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java;

import java.util.List;
import org.eclipse.edt.compiler.binding.annotationType.EGLIsSystemPartAnnotationTypeBinding;
import org.eclipse.edt.compiler.internal.core.utils.Aliaser;
import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.gen.GenerationException;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.AsExpression;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.DataTable;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.ExternalType;
import org.eclipse.edt.mof.egl.Form;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Library;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.ProgramParameter;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.Type;

public class CommonUtilities {
    public static String packageName(Part part) {
        return Aliaser.packageNameAlias((String[])part.getPackageName().split("[.]"), (char)'.');
    }

    public static String packageName(String pkg) {
        if (pkg != null && pkg.length() > 0) {
            return Aliaser.packageNameAlias((String)pkg);
        }
        return pkg;
    }

    public static boolean isUserDefinedExternalType(Type type) {
        return CommonUtilities.getUserDefinedExternalType(type) != null;
    }

    public static ExternalType getUserDefinedExternalType(Type type) {
        if (type instanceof Part) {
            Part member = (Part)type;
            if (member instanceof ExternalType) {
                String value;
                if (member.getAnnotation(EGLIsSystemPartAnnotationTypeBinding.name) == null) {
                    return (ExternalType)member;
                }
                Annotation annot = member.getAnnotation("JavaObject");
                if (annot != null && (value = (String)annot.getValue("packageName")) != null && (value.startsWith("java.") || value.startsWith("javax."))) {
                    return (ExternalType)member;
                }
            }
        } else if (type instanceof ExternalType) {
            String value;
            if (type.getAnnotation(EGLIsSystemPartAnnotationTypeBinding.name) == null) {
                return (ExternalType)type;
            }
            Annotation annot = type.getAnnotation("JavaObject");
            if (annot != null && (value = (String)annot.getValue("packageName")) != null && (value.startsWith("java.") || value.startsWith("javax."))) {
                return (ExternalType)type;
            }
        } else if (type instanceof ArrayType) {
            while (type instanceof ArrayType) {
                type = ((ArrayType)type).getElementType();
            }
            return CommonUtilities.getUserDefinedExternalType(type);
        }
        return null;
    }

    public static boolean isSerializable(ExternalType et) {
        List extndsAry;
        if (et == null) {
            return false;
        }
        Annotation annot = et.getAnnotation("JavaObject");
        if (annot != null && (extndsAry = et.getSuperTypes()) != null) {
            for (StructPart part : extndsAry) {
                if (!(part instanceof ExternalType) || (annot = part.getAnnotation("JavaObject")) == null) continue;
                if ("java.io".equalsIgnoreCase((String)annot.getValue("packageName")) && "Serializable".equalsIgnoreCase((String)annot.getValue("javaName"))) {
                    return true;
                }
                if (CommonUtilities.isObjectExternalType((Part)part) || !CommonUtilities.isSerializable((ExternalType)part)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isObjectExternalType(Part m) {
        Annotation annot;
        if (m instanceof ExternalType && (annot = m.getAnnotation("JavaObject")) != null) {
            String name = (String)annot.getValue("javaName");
            if (name == null || name.length() == 0) {
                name = m.getId();
            }
            return "Object".equalsIgnoreCase(name) && "java.lang".equalsIgnoreCase((String)annot.getValue("packageName"));
        }
        return false;
    }

    public static String getNativeRuntimeOperationName(BinaryExpression expr) throws GenerationException {
        if (expr.getOperation() == null || expr.getOperation().getName() == null) {
            throw new GenerationException();
        }
        String op = expr.getOperator();
        if (op.equals("+")) {
            return "plus";
        }
        if (op.equals("-")) {
            return "minus";
        }
        if (op.equals("/")) {
            return "divide";
        }
        if (op.equals("*")) {
            return "multiply";
        }
        if (op.equals("%")) {
            return "modulo";
        }
        if (op.equals("==")) {
            return "equals";
        }
        if (op.equals("!=")) {
            return "notEquals";
        }
        if (op.equals("<")) {
            return "compareTo";
        }
        if (op.equals(">")) {
            return "compareTo";
        }
        if (op.equals("<=")) {
            return "compareTo";
        }
        if (op.equals(">=")) {
            return "compareTo";
        }
        if (op.equals("&&")) {
            return "and";
        }
        if (op.equals("||")) {
            return "or";
        }
        if (op.equals("xor")) {
            return "xor";
        }
        if (op.equals("::")) {
            return "concat";
        }
        if (op.equals("?:")) {
            return "concat";
        }
        if (op.equals("&")) {
            return "bitand";
        }
        if (op.equals("|")) {
            return "bitor";
        }
        if (op.equals("**")) {
            return "power";
        }
        if (op.equals("in")) {
            return "in";
        }
        if (op.equals("matches")) {
            return "matches";
        }
        if (op.equals("like")) {
            return "like";
        }
        return "UnknownOp";
    }

    public static String getNativeRuntimeComparisionOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("<")) {
            return " < 0";
        }
        if (op.equals(">")) {
            return " > 0";
        }
        if (op.equals("<=")) {
            return " <= 0";
        }
        if (op.equals(">=")) {
            return " >= 0";
        }
        return "";
    }

    public static String getNativeJavaOperation(BinaryExpression expr, Context ctx) {
        String op = expr.getOperator();
        if (expr.isNullable() || ((Boolean)ctx.getParameter("checkOverflow")).booleanValue()) {
            if (op.equals("==")) {
                return " == ";
            }
            if (op.equals("!=")) {
                return " != ";
            }
            if (op.equals("<")) {
                return " < ";
            }
            if (op.equals(">")) {
                return " > ";
            }
            if (op.equals("<=")) {
                return " <= ";
            }
            if (op.equals(">=")) {
                return " >= ";
            }
            if (op.equals("&&")) {
                return " && ";
            }
            if (op.equals("||")) {
                return " || ";
            }
            if (op.equals("xor")) {
                return " ^ ";
            }
            if (op.equals("::")) {
                return " + ";
            }
            if (op.equals("&")) {
                return " & ";
            }
            if (op.equals("|")) {
                return " | ";
            }
            return "";
        }
        if (op.equals("+")) {
            return " + ";
        }
        if (op.equals("-")) {
            return " - ";
        }
        if (op.equals("*")) {
            return " * ";
        }
        if (op.equals("%")) {
            return " % ";
        }
        if (op.equals("==")) {
            return " == ";
        }
        if (op.equals("!=")) {
            return " != ";
        }
        if (op.equals("<")) {
            return " < ";
        }
        if (op.equals(">")) {
            return " > ";
        }
        if (op.equals("<=")) {
            return " <= ";
        }
        if (op.equals(">=")) {
            return " >= ";
        }
        if (op.equals("&&")) {
            return " && ";
        }
        if (op.equals("||")) {
            return " || ";
        }
        if (op.equals("xor")) {
            return " ^ ";
        }
        if (op.equals("::")) {
            return " + ";
        }
        if (op.equals("&")) {
            return " & ";
        }
        if (op.equals("|")) {
            return " | ";
        }
        return "";
    }

    public static boolean isHandledByJavaWithoutCast(Expression src, AsExpression tgt, Context ctx) {
        if (src.isNullable() || tgt.isNullable()) {
            return false;
        }
        if (!ctx.mapsToPrimitiveType(src.getType()) || !ctx.mapsToPrimitiveType(tgt.getType())) {
            return false;
        }
        String srcString = ctx.getPrimitiveMapping(src.getType());
        String tgtString = ctx.getPrimitiveMapping(tgt.getType());
        int srcIndex = CommonUtilities.getJavaAllowedType(srcString);
        int tgtIndex = CommonUtilities.getJavaAllowedType(tgtString);
        return srcIndex >= 0 && tgtIndex >= 0 && srcIndex == tgtIndex;
    }

    public static boolean isHandledByJavaWithCast(Expression src, AsExpression tgt, Context ctx) {
        if (src.isNullable() || tgt.isNullable()) {
            return false;
        }
        if (!ctx.mapsToPrimitiveType(src.getType()) || !ctx.mapsToPrimitiveType(tgt.getType())) {
            return false;
        }
        String srcString = ctx.getPrimitiveMapping(src.getType());
        String tgtString = ctx.getPrimitiveMapping(tgt.getType());
        int srcIndex = CommonUtilities.getJavaAllowedType(srcString);
        int tgtIndex = CommonUtilities.getJavaAllowedType(tgtString);
        return srcIndex >= 0 && tgtIndex >= 0 && srcIndex != tgtIndex;
    }

    private static int getJavaAllowedType(String value) {
        if (value.equals("short")) {
            return 0;
        }
        if (value.equals("int")) {
            return 1;
        }
        if (value.equals("long")) {
            return 2;
        }
        if (value.equals("float")) {
            return 3;
        }
        if (value.equals("double")) {
            return 4;
        }
        return -1;
    }

    public static void processImport(String qualifiedName, Context ctx) {
        if (qualifiedName == null || qualifiedName.indexOf(46) < 0) {
            return;
        }
        List typesImported = (List)ctx.getAttribute(((Object)((Object)ctx)).getClass(), "partTypesImported");
        for (String imported : typesImported) {
            if (!qualifiedName.equalsIgnoreCase(imported)) continue;
            return;
        }
        String unqualifiedName = qualifiedName;
        if (unqualifiedName.indexOf(46) >= 0) {
            unqualifiedName = unqualifiedName.substring(unqualifiedName.lastIndexOf(46) + 1);
        }
        for (String imported : typesImported) {
            if (imported.indexOf(46) >= 0) {
                imported = imported.substring(imported.lastIndexOf(46) + 1);
            }
            if (!unqualifiedName.equalsIgnoreCase(imported)) continue;
            return;
        }
        typesImported.add(qualifiedName);
    }

    public static void generateSmapExtension(Member field, Context ctx) {
        Annotation annotation;
        if (!field.getName().startsWith("eze$Temp") && (annotation = field.getAnnotation("EGL_Location")) != null && annotation.getValue("line") != null) {
            ctx.getSmapExtension().append("" + (Integer)annotation.getValue("line"));
            if (ctx.getCurrentFile() != null) {
                if (ctx.getSmapFiles().indexOf(ctx.getCurrentFile()) < 0) {
                    ctx.getSmapFiles().add(ctx.getCurrentFile());
                }
                ctx.getSmapExtension().append("#" + (ctx.getSmapFiles().indexOf(ctx.getCurrentFile()) + 1) + ";");
            } else {
                ctx.getSmapExtension().append("#1;");
            }
            ctx.getSmapExtension().append(String.valueOf(field.getName()) + ";");
            ctx.getSmapExtension().append(String.valueOf(field.getName()) + ";");
            ctx.getSmapExtension().append(String.valueOf(field.getType().getTypeSignature()) + "\n");
        }
    }

    public static void generateSmapExtension(Function function, Context ctx) {
        Annotation annotation = function.getAnnotation("EGL_Location");
        if (annotation != null && annotation.getValue("line") != null) {
            ctx.getSmapExtension().append("" + (Integer)annotation.getValue("line"));
            if (ctx.getCurrentFile() != null) {
                if (ctx.getSmapFiles().indexOf(ctx.getCurrentFile()) < 0) {
                    ctx.getSmapFiles().add(ctx.getCurrentFile());
                }
                ctx.getSmapExtension().append("#" + (ctx.getSmapFiles().indexOf(ctx.getCurrentFile()) + 1) + ";");
            } else {
                ctx.getSmapExtension().append("#1;");
            }
            if (function.getName().equalsIgnoreCase("main")) {
                ctx.getSmapExtension().append("F:main;(Ljava/util/List;)V\n");
            } else {
                ctx.getSmapExtension().append("F:" + function.getName() + ";(");
                int i = 0;
                while (i < function.getParameters().size()) {
                    FunctionParameter decl = (FunctionParameter)function.getParameters().get(i);
                    if (org.eclipse.edt.gen.CommonUtilities.isBoxedParameterType((FunctionParameter)decl, (EglContext)ctx)) {
                        ctx.getSmapExtension().append("Lorg/eclipse/edt/javart/AnyBoxedObject;");
                    } else {
                        ctx.getSmapExtension().append(CommonUtilities.generateJavaTypeSignature(((FunctionParameter)function.getParameters().get(i)).getType(), ctx));
                    }
                    ++i;
                }
                ctx.getSmapExtension().append(")" + CommonUtilities.generateJavaTypeSignature(function.getReturnType(), ctx) + "\n");
            }
        }
    }

    public static void generateSmapExtension(DataTable dataTable, Context ctx) {
        ctx.getSmapExtension().append("*D;" + dataTable.getFullyQualifiedName() + "\n");
    }

    public static void generateSmapExtension(Form form, Context ctx) {
        ctx.getSmapExtension().append("*F;" + form.getFullyQualifiedName() + "\n");
    }

    public static void generateSmapExtension(Library library, Context ctx) {
        if (ctx.mapsToNativeType((Type)library)) {
            ctx.getSmapExtension().append("*S;" + library.getFullyQualifiedName() + "\n");
        } else {
            ctx.getSmapExtension().append("*L;" + library.getFullyQualifiedName() + "\n");
        }
    }

    public static void generateSmapExtension(ProgramParameter programParameter, Context ctx) {
        ctx.getSmapExtension().append("*P;" + programParameter.getName() + ";");
        ctx.getSmapExtension().append(String.valueOf(CommonUtilities.generateJavaTypeSignature(programParameter.getType(), ctx)) + "\n");
    }

    private static String generateJavaTypeSignature(Type type, Context ctx) {
        String value;
        String signature = "";
        signature = type instanceof ArrayType ? String.valueOf(signature) + "L" + ctx.getRawNativeInterfaceMapping((Type)type.getClassifier()).replaceAll("\\.", "/") + ";" : (type == null ? String.valueOf(signature) + "V" : (ctx.mapsToPrimitiveType((Type)type.getClassifier()) ? ((value = ctx.getRawPrimitiveMapping((Type)type.getClassifier())).equals("boolean") ? String.valueOf(signature) + "Z" : (value.equals("byte") ? String.valueOf(signature) + "B" : (value.equals("char") ? String.valueOf(signature) + "C" : (value.equals("double") ? String.valueOf(signature) + "D" : (value.equals("float") ? String.valueOf(signature) + "F" : (value.equals("int") ? String.valueOf(signature) + "I" : (value.equals("long") ? String.valueOf(signature) + "J" : (value.equals("short") ? String.valueOf(signature) + "S" : String.valueOf(signature) + "L" + value.replaceAll("\\.", "/") + ";")))))))) : String.valueOf(signature) + "L" + type.getClassifier().getTypeSignature().replaceAll("\\.", "/") + ";"));
        return signature;
    }
}

