/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates.egl.lang;

import org.eclipse.edt.gen.GenerationException;
import org.eclipse.edt.gen.javascript.CommonUtilities;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.egl.AsExpression;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Operation;
import org.eclipse.edt.mof.egl.ParameterizableType;
import org.eclipse.edt.mof.egl.SequenceType;
import org.eclipse.edt.mof.egl.SubstringAccess;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.TypedElement;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class AnyStringTypeTemplate
extends JavaScriptTemplate {
    public void genDefaultValue(SequenceType type, Context ctx, TabbedWriter out, Object ... args) {
        this.processDefaultValue((Type)type, ctx, out, args);
    }

    public void genDefaultValue(ParameterizableType type, Context ctx, TabbedWriter out, Object ... args) {
        this.processDefaultValue((Type)type, ctx, out, args);
    }

    public void processDefaultValue(Type type, Context ctx, TabbedWriter out, Object ... args) {
        if (args.length > 0 && args[0] instanceof TypedElement && ((TypedElement)args[0]).isNullable()) {
            out.print("null");
        } else if (args.length > 0 && args[0] instanceof Expression && ((Expression)args[0]).isNullable()) {
            out.print("null");
        } else {
            out.print(this.quoted(""));
        }
    }

    public void genSignature(SequenceType type, Context ctx, TabbedWriter out, Object ... args) {
        String signature = "";
        if (args.length > 0 && args[0] instanceof TypedElement && ((TypedElement)args[0]).isNullable()) {
            signature = String.valueOf(signature) + "?";
        } else if (args.length > 0 && args[0] instanceof Expression && ((Expression)args[0]).isNullable()) {
            signature = String.valueOf(signature) + "?";
        }
        signature = String.valueOf(signature) + "S;";
        out.print(signature);
    }

    public void genSignature(ParameterizableType type, Context ctx, TabbedWriter out, Object ... args) {
        String signature = "";
        if (args.length > 0 && args[0] instanceof TypedElement && ((TypedElement)args[0]).isNullable()) {
            signature = String.valueOf(signature) + "?";
        } else if (args.length > 0 && args[0] instanceof Expression && ((Expression)args[0]).isNullable()) {
            signature = String.valueOf(signature) + "?";
        }
        signature = String.valueOf(signature) + "S;";
        out.print(signature);
    }

    public void genSubstringAssignment(SequenceType type, Context ctx, TabbedWriter out, Object ... args) {
        this.processSubstringAssignment((Type)type, ctx, out, args);
    }

    public void genSubstringAssignment(ParameterizableType type, Context ctx, TabbedWriter out, Object ... args) {
        this.processSubstringAssignment((Type)type, ctx, out, args);
    }

    public void processSubstringAssignment(Type type, Context ctx, TabbedWriter out, Object ... args) {
        ctx.gen("genExpression", (EObject)((SubstringAccess)args[0]).getStringExpression(), (TemplateContext)ctx, out, args);
        out.print(" = ");
        out.print(String.valueOf(ctx.getNativeImplementationMapping(((SubstringAccess)args[0]).getType())) + ".substringAssign(");
        ctx.gen("genExpression", (EObject)((SubstringAccess)args[0]).getStringExpression(), (TemplateContext)ctx, out, args);
        out.print(", ");
        ctx.gen("genExpression", (EObject)((Expression)args[1]), (TemplateContext)ctx, out, args);
        out.print(", ");
        ctx.gen("genExpression", (EObject)((SubstringAccess)args[0]).getStart(), (TemplateContext)ctx, out, args);
        out.print(", ");
        ctx.gen("genExpression", (EObject)((SubstringAccess)args[0]).getEnd(), (TemplateContext)ctx, out, args);
        out.print(")");
    }

    public void genSubstringAccess(SequenceType type, Context ctx, TabbedWriter out, Object ... args) {
        this.processSubstringAccess((Type)type, ctx, out, args);
    }

    public void genSubstringAccess(ParameterizableType type, Context ctx, TabbedWriter out, Object ... args) {
        this.processSubstringAccess((Type)type, ctx, out, args);
    }

    public void processSubstringAccess(Type type, Context ctx, TabbedWriter out, Object ... args) {
        out.print(String.valueOf(ctx.getNativeImplementationMapping(((SubstringAccess)args[0]).getType())) + ".substring(");
        ctx.gen("genExpression", (EObject)((SubstringAccess)args[0]).getStringExpression(), (TemplateContext)ctx, out, args);
        out.print(", ");
        ctx.gen("genExpression", (EObject)((SubstringAccess)args[0]).getStart(), (TemplateContext)ctx, out, args);
        out.print(", ");
        ctx.gen("genExpression", (EObject)((SubstringAccess)args[0]).getEnd(), (TemplateContext)ctx, out, args);
        out.print(")");
    }

    protected boolean needsConversion(Operation conOp) {
        Type fromType = ((FunctionParameter)conOp.getParameters().get(0)).getType();
        Type toType = conOp.getReturnType();
        if (CommonUtilities.getEglNameForTypeCamelCase((Type)toType).equals(CommonUtilities.getEglNameForTypeCamelCase((Type)fromType))) {
            return false;
        }
        return TypeUtils.isNumericType((Type)fromType);
    }

    public void genConversionOperation(ParameterizableType type, Context ctx, TabbedWriter out, Object ... args) {
        if (((AsExpression)args[0]).getConversionOperation() != null && this.needsConversion(((AsExpression)args[0]).getConversionOperation())) {
            out.print("(");
            ctx.gen("genExpression", (EObject)((AsExpression)args[0]).getObjectExpr(), (TemplateContext)ctx, out, args);
            out.print(").toString()");
        } else {
            ctx.genSuper("genConversionOperation", ParameterizableType.class, (EObject)type, (TemplateContext)ctx, out, args);
        }
    }

    public void genStringConversion(ParameterizableType type, Context ctx, TabbedWriter out, Object ... args) {
        ctx.gen("genExpression", (EObject)((AsExpression)args[0]).getObjectExpr(), (TemplateContext)ctx, out, args);
    }

    public void genDateConversion(ParameterizableType type, Context ctx, TabbedWriter out, Object ... args) {
        out.print("egl.egl.core.StrLib['$inst'].formatDate(");
        ctx.gen("genExpression", (EObject)((AsExpression)args[0]).getObjectExpr(), (TemplateContext)ctx, out, args);
        out.print(", ");
        out.print("egl.egl.core.StrLib['$inst'].defaultDateFormat )");
    }

    public void genTimeConversion(ParameterizableType type, Context ctx, TabbedWriter out, Object ... args) {
        out.print("egl.egl.core.StrLib['$inst'].formatTime(");
        ctx.gen("genExpression", (EObject)((AsExpression)args[0]).getObjectExpr(), (TemplateContext)ctx, out, args);
        out.print(", ");
        out.print("egl.egl.core.StrLib['$inst'].defaultTimeFormat )");
    }

    public void genTimeStampConversion(ParameterizableType type, Context ctx, TabbedWriter out, Object ... args) {
        out.print("egl.egl.core.StrLib['$inst'].formatTimeStamp(");
        ctx.gen("genExpression", (EObject)((AsExpression)args[0]).getObjectExpr(), (TemplateContext)ctx, out, args);
        out.print(", ");
        out.print("egl.egl.core.StrLib['$inst'].defaultTimeStampFormat )");
    }

    public void genBooleanConversion(ParameterizableType type, Context ctx, TabbedWriter out, Object ... args) {
        out.print("(");
        ctx.gen("genExpression", (EObject)((AsExpression)args[0]).getObjectExpr(), (TemplateContext)ctx, out, args);
        out.print(").toString()");
    }

    public void genBinaryExpression(EGLClass type, Context ctx, TabbedWriter out, Object ... args) throws GenerationException {
        if (((BinaryExpression)args[0]).getLHS().isNullable() || ((BinaryExpression)args[0]).getRHS().isNullable() || this.getNativeStringOperation((BinaryExpression)args[0]).length() == 0) {
            out.print(String.valueOf(ctx.getNativeImplementationMapping((Type)((BinaryExpression)args[0]).getOperation().getContainer())) + '.');
            out.print(CommonUtilities.getNativeRuntimeOperationName((BinaryExpression)((BinaryExpression)args[0])));
            out.print("(ezeProgram, ");
            ctx.gen("genExpression", (EObject)((BinaryExpression)args[0]).getLHS(), (TemplateContext)ctx, out, args);
            out.print(", ");
            ctx.gen("genExpression", (EObject)((BinaryExpression)args[0]).getRHS(), (TemplateContext)ctx, out, args);
            out.print(")" + CommonUtilities.getNativeRuntimeComparisionOperation((BinaryExpression)((BinaryExpression)args[0])));
        } else {
            out.print(this.getNativeStringPrefixOperation((BinaryExpression)args[0]));
            out.print("(");
            ctx.gen("genExpression", (EObject)((BinaryExpression)args[0]).getLHS(), (TemplateContext)ctx, out, args);
            out.print(")");
            out.print(this.getNativeStringOperation((BinaryExpression)args[0]));
            ctx.gen("genExpression", (EObject)((BinaryExpression)args[0]).getRHS(), (TemplateContext)ctx, out, args);
            out.print(this.getNativeStringComparisionOperation((BinaryExpression)args[0]));
        }
    }

    protected String getNativeStringPrefixOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("!=")) {
            return "";
        }
        return "";
    }

    protected String getNativeStringOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("+")) {
            return " + ";
        }
        if (op.equals("==")) {
            return " == ";
        }
        if (op.equals("!=")) {
            return " != ";
        }
        if (op.equals("<")) {
            return " < ";
        }
        if (op.equals(">")) {
            return " > ";
        }
        if (op.equals("<=")) {
            return " <= ";
        }
        if (op.equals(">=")) {
            return " >= ";
        }
        if (op.equals("&&")) {
            return " && ";
        }
        if (op.equals("||")) {
            return " || ";
        }
        if (op.equals("::")) {
            return " + ";
        }
        return "";
    }

    protected String getNativeStringComparisionOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("==")) {
            return "";
        }
        if (op.equals("!=")) {
            return "";
        }
        if (op.equals("<")) {
            return "";
        }
        if (op.equals(">")) {
            return "";
        }
        if (op.equals("<=")) {
            return "";
        }
        if (op.equals(">=")) {
            return "";
        }
        return "";
    }
}

