/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates.egl.lang;

import org.eclipse.edt.gen.CommonUtilities;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.egl.AsExpression;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.TypedElement;
import org.eclipse.edt.mof.egl.UnaryExpression;

public class BooleanTypeTemplate
extends JavaScriptTemplate {
    public void genDefaultValue(EGLClass type, Context ctx, TabbedWriter out, Object ... args) {
        if (args.length > 0 && args[0] instanceof TypedElement && ((TypedElement)args[0]).isNullable()) {
            out.print("null");
        } else if (args.length > 0 && args[0] instanceof Expression && ((Expression)args[0]).isNullable()) {
            out.print("null");
        } else {
            out.print("false");
        }
    }

    public void genSignature(EGLClass type, Context ctx, TabbedWriter out, Object ... args) {
        String signature = "";
        if (args.length > 0 && args[0] instanceof TypedElement && ((TypedElement)args[0]).isNullable()) {
            signature = String.valueOf(signature) + "?";
        } else if (args.length > 0 && args[0] instanceof Expression && ((Expression)args[0]).isNullable()) {
            signature = String.valueOf(signature) + "?";
        }
        signature = String.valueOf(signature) + "0;";
        out.print(signature);
    }

    public void genBooleanConversion(EGLClass type, Context ctx, TabbedWriter out, Object ... args) {
        ctx.gen("genExpression", (EObject)((AsExpression)args[0]).getObjectExpr(), (TemplateContext)ctx, out, args);
    }

    public void genUnaryExpression(EGLClass type, Context ctx, TabbedWriter out, Object ... args) {
        out.print(String.valueOf(((UnaryExpression)args[0]).getOperator()) + "(");
        ctx.gen("genExpression", (EObject)((UnaryExpression)args[0]).getExpression(), (TemplateContext)ctx, out, CommonUtilities.genWithoutTypeList((Object[])args));
        out.print(")");
    }

    public void genBinaryExpression(Type type, Context ctx, TabbedWriter out, Object ... args) {
        out.print(this.getNativeStringPrefixOperation((BinaryExpression)args[0]));
        out.print("(");
        ctx.gen("genExpression", (EObject)((BinaryExpression)args[0]).getLHS(), (TemplateContext)ctx, out, args);
        out.print(this.getNativeStringOperation((BinaryExpression)args[0]));
        ctx.gen("genExpression", (EObject)((BinaryExpression)args[0]).getRHS(), (TemplateContext)ctx, out, args);
        out.print(this.getNativeStringComparisionOperation((BinaryExpression)args[0]));
        out.print(")");
    }

    protected String getNativeStringPrefixOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("!=")) {
            return "";
        }
        return "";
    }

    protected String getNativeStringOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("+")) {
            return " + ";
        }
        if (op.equals("==")) {
            return " == ";
        }
        if (op.equals("!=")) {
            return " != ";
        }
        if (op.equals("<")) {
            return ".compareTo(";
        }
        if (op.equals(">")) {
            return ".compareTo(";
        }
        if (op.equals("<=")) {
            return ".compareTo(";
        }
        if (op.equals(">=")) {
            return ".compareTo(";
        }
        if (op.equals("&&")) {
            return " && ";
        }
        if (op.equals("||")) {
            return " || ";
        }
        if (op.equals("::")) {
            return " + ";
        }
        return "";
    }

    protected String getNativeStringComparisionOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("==")) {
            return "";
        }
        if (op.equals("!=")) {
            return "";
        }
        if (op.equals("<")) {
            return ") < 0";
        }
        if (op.equals(">")) {
            return ") > 0";
        }
        if (op.equals("<=")) {
            return ") <= 0";
        }
        if (op.equals(">=")) {
            return ") >= 0";
        }
        return "";
    }
}

