/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates.egl.lang;

import org.eclipse.edt.gen.javascript.CommonUtilities;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.egl.AsExpression;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.IntegerLiteral;
import org.eclipse.edt.mof.egl.Operation;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.TypedElement;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class SmallintTypeTemplate
extends JavaScriptTemplate {
    public void genDefaultValue(EGLClass type, Context ctx, TabbedWriter out, Object ... args) {
        if (args.length > 0 && args[0] instanceof TypedElement && ((TypedElement)args[0]).isNullable()) {
            out.print("null");
        } else if (args.length > 0 && args[0] instanceof Expression && ((Expression)args[0]).isNullable()) {
            out.print("null");
        } else {
            out.print("0");
        }
    }

    public void genSignature(EGLClass type, Context ctx, TabbedWriter out, Object ... args) {
        String signature = "";
        if (args.length > 0 && args[0] instanceof TypedElement && ((TypedElement)args[0]).isNullable()) {
            signature = String.valueOf(signature) + "?";
        } else if (args.length > 0 && args[0] instanceof Expression && ((Expression)args[0]).isNullable()) {
            signature = String.valueOf(signature) + "?";
        }
        signature = String.valueOf(signature) + "i;";
        out.print(signature);
    }

    protected boolean needsConversion(Operation conOp) {
        Type fromType = ((FunctionParameter)conOp.getParameters().get(0)).getType();
        Type toType = conOp.getReturnType();
        if (CommonUtilities.getEglNameForTypeCamelCase((Type)toType).equals(CommonUtilities.getEglNameForTypeCamelCase((Type)fromType))) {
            return false;
        }
        return TypeUtils.isNumericType((Type)fromType) && fromType.equals(TypeUtils.Type_INT) == false && fromType.equals(TypeUtils.Type_FLOAT) == false && fromType.equals(TypeUtils.Type_SMALLFLOAT) == false;
    }

    public void genConversionOperation(EGLClass type, Context ctx, TabbedWriter out, Object ... args) {
        if (((AsExpression)args[0]).getConversionOperation() != null && this.needsConversion(((AsExpression)args[0]).getConversionOperation())) {
            out.print("egl.convertDecimalToSmallint(");
            ctx.gen("genExpression", (EObject)((AsExpression)args[0]).getObjectExpr(), (TemplateContext)ctx, out, args);
            out.print(", egl.createRuntimeException)");
        } else {
            ctx.genSuper("genConversionOperation", EGLClass.class, (EObject)type, (TemplateContext)ctx, out, args);
        }
    }

    public void genIntConversion(EGLClass type, Context ctx, TabbedWriter out, Object ... args) {
        if (((AsExpression)args[0]).getObjectExpr() instanceof IntegerLiteral && ((IntegerLiteral)((AsExpression)args[0]).getObjectExpr()).getIntValue() >= Short.MIN_VALUE && ((IntegerLiteral)((AsExpression)args[0]).getObjectExpr()).getIntValue() <= Short.MAX_VALUE) {
            ctx.gen("genExpression", (EObject)((AsExpression)args[0]).getObjectExpr(), (TemplateContext)ctx, out, args);
        } else {
            out.print("egl.convertNumberToSmallint(");
            ctx.gen("genExpression", (EObject)((AsExpression)args[0]).getObjectExpr(), (TemplateContext)ctx, out, args);
            out.print(", egl.createRuntimeException)");
        }
    }

    public void genSmallintConversion(EGLClass type, Context ctx, TabbedWriter out, Object ... args) {
        ctx.gen("genExpression", (EObject)((AsExpression)args[0]).getObjectExpr(), (TemplateContext)ctx, out, args);
    }

    public void genSmallfloatConversion(EGLClass type, Context ctx, TabbedWriter out, Object ... args) {
        out.print("egl.convertFloatToSmallint(");
        ctx.gen("genExpression", (EObject)((AsExpression)args[0]).getObjectExpr(), (TemplateContext)ctx, out, args);
        out.print(")");
    }

    public void genFloatConversion(EGLClass type, Context ctx, TabbedWriter out, Object ... args) {
        out.print("egl.convertFloatToSmallint(");
        ctx.gen("genExpression", (EObject)((AsExpression)args[0]).getObjectExpr(), (TemplateContext)ctx, out, args);
        out.print(")");
    }

    public void genStringConversion(EGLClass type, Context ctx, TabbedWriter out, Object ... args) {
        out.print("egl.convertStringToSmallint(");
        ctx.gen("genExpression", (EObject)((AsExpression)args[0]).getObjectExpr(), (TemplateContext)ctx, out, args);
        out.print(")");
    }
}

