/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates;

import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.IRUtils;

public class EGLClassTemplate
extends JavaScriptTemplate {
    public void validateClassBody(EGLClass part, Context ctx, Object ... args) {
        ctx.validate("validateUsedParts", (Classifier)part, (EglContext)ctx, args);
        ctx.validate("validateFields", (Classifier)part, (EglContext)ctx, args);
        ctx.validate("validateFunctions", (Classifier)part, (EglContext)ctx, args);
    }

    public void validateUsedParts(EGLClass part, Context ctx, Object ... args) {
        for (Part item : IRUtils.getReferencedPartsFor((Part)part)) {
            ctx.validate("validateUsedPart", (Classifier)part, (EglContext)ctx, new Object[]{item});
        }
    }

    public void validateUsedPart(EGLClass part, Context ctx, Object ... args) {
        ctx.validate("validate", (Classifier)((Part)args[0]), (EglContext)ctx, args);
    }

    public void validateFields(EGLClass part, Context ctx, Object ... args) {
        for (Field field : part.getFields()) {
            ctx.validate("validateField", (Classifier)part, (EglContext)ctx, new Object[]{field});
        }
    }

    public void validateField(EGLClass part, Context ctx, Object ... args) {
        ctx.validate("validate", (Element)((Field)args[0]), (EglContext)ctx, args);
    }

    public void validateFunctions(EGLClass part, Context ctx, Object ... args) {
        for (Function function : part.getFunctions()) {
            ctx.validate("validateFunction", (Classifier)part, (EglContext)ctx, new Object[]{function});
        }
    }

    public void validateFunction(EGLClass part, Context ctx, Object ... args) {
        ctx.validate("validate", (Element)((Function)args[0]), (EglContext)ctx, args);
    }

    public void genClassHeader(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        out.print("egl.defineClass(");
        out.print(this.singleQuoted(part.getPackageName().toLowerCase()));
        out.print(", ");
        out.print(this.quoted(part.getName()));
        out.print(", ");
        ctx.gen("genSuperClass", (Classifier)part, (EglContext)ctx, out, args);
        out.print(", ");
        out.println("{");
    }

    public void genClassBody(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        ctx.gen("genConstructors", (Classifier)part, (EglContext)ctx, out, args);
        out.println(",");
        ctx.gen("genSetEmptyMethods", (Classifier)part, (EglContext)ctx, out, args);
        out.println(",");
        ctx.gen("genInitializeMethods", (Classifier)part, (EglContext)ctx, out, args);
        out.println(",");
        ctx.gen("genCloneMethods", (Classifier)part, (EglContext)ctx, out, args);
        ctx.gen("genFunctions", (Classifier)part, (EglContext)ctx, out, args);
        ctx.gen("genFields", (Classifier)part, (EglContext)ctx, out, args);
        ctx.gen("genGetterSetters", (Classifier)part, (EglContext)ctx, out, args);
    }

    public void genFields(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        for (Field field : part.getFields()) {
            ctx.gen("genField", (Classifier)part, (EglContext)ctx, out, new Object[]{field});
        }
    }

    public void genField(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
    }

    public void genConstructors(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        ctx.gen("genConstructor", (Classifier)part, (EglContext)ctx, out, args);
    }

    public void genConstructor(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        out.print(this.quoted("constructor"));
        out.println(": function() {");
        out.print("this.");
        out.print("eze$$XMLRootElementName = ");
        out.print(this.quoted(part.getName()));
        out.println(";");
        out.println("this.eze$$setInitial();");
        out.println("}");
    }

    public void genSetEmptyMethods(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        out.print(this.quoted("eze$$setEmpty"));
        out.println(": function() {");
        ctx.gen("genSetEmptyMethodBody", (Classifier)part, (EglContext)ctx, out, args);
        out.println("}");
    }

    public void genSetEmptyMethodBody(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        for (Field field : part.getFields()) {
            ctx.gen("genSetEmptyMethod", (Classifier)part, (EglContext)ctx, out, new Object[]{field});
        }
    }

    public void genSetEmptyMethod(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        out.print("this.");
        ctx.gen("genName", (EObject)((Field)args[0]), (TemplateContext)ctx, out, args);
        out.print(" = ");
        ctx.gen("genInitialization", (EObject)((Field)args[0]), (TemplateContext)ctx, out, args);
        out.println(";");
    }

    public void genInitializeMethods(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        out.print(this.quoted("eze$$setInitial"));
        out.println(": function() {");
        ctx.gen("genInitializeMethodBody", (Classifier)part, (EglContext)ctx, out, args);
        out.println("};");
    }

    public void genInitializeMethodBody(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        for (Field field : part.getFields()) {
            ctx.gen("genInitializeMethod", (Classifier)part, (EglContext)ctx, out, new Object[]{field});
        }
    }

    public void genInitializeMethod(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        if (((Field)args[0]).getInitializerStatements() != null) {
            ctx.gen("genStatementNoBraces", (EObject)((Field)args[0]).getInitializerStatements(), (TemplateContext)ctx, out, args);
        } else {
            if (((Field)args[0]).getContainer() != null && ((Field)args[0]).getContainer() instanceof Type) {
                ctx.gen("genQualifier", (EObject)((Field)args[0]).getContainer(), (TemplateContext)ctx, out, args);
            }
            ctx.gen("genName", (EObject)((Field)args[0]), (TemplateContext)ctx, out, args);
            out.print(" = ");
            ctx.gen("genInitialization", (EObject)((Field)args[0]), (TemplateContext)ctx, out, args);
            out.println(";");
        }
    }

    public void genCloneMethods(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        out.print(this.quoted("eze$$clone"));
        out.println(": function() {");
        ctx.gen("genCloneMethodBody", (Classifier)part, (EglContext)ctx, out, args);
        out.println("}");
    }

    public void genCloneMethodBody(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        String temp1 = "ezert$$1";
        String temp2 = "ezert$$2";
        out.print("var ");
        out.print(temp1);
        out.println(" = this;");
        out.print("var ");
        out.print(temp2);
        out.print(" = ");
        ctx.gen("genInstantiation", (Classifier)part, (EglContext)ctx, out, args);
        out.println(";");
        out.print(temp2);
        out.println(".eze$$isNull = this.eze$$isNull;");
        out.print(temp2);
        out.println(".eze$$isNullable = this.eze$$isNullable;");
        for (Field field : part.getFields()) {
            ctx.gen("genCloneMethod", (Classifier)part, (EglContext)ctx, out, new Object[]{field});
        }
        out.print(temp2);
        out.print(".setNull(");
        out.print(temp1);
        out.println("eze$$isNull)");
        out.print("return ");
        out.print(temp2);
        out.println(";");
    }

    public void genCloneMethod(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        String temp1 = "ezert$$1";
        String temp2 = "ezert$$2";
        out.print(temp2);
        out.print(".");
        ctx.gen("genName", (EObject)((Field)args[0]), (TemplateContext)ctx, out, args);
        out.print(" = ");
        out.print(temp1);
        out.print(".");
        ctx.gen("genName", (EObject)((Field)args[0]), (TemplateContext)ctx, out, args);
        out.println(";");
    }

    public void genGetterSetters(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        String delim = ",";
        for (Field field : part.getFields()) {
            out.print(delim);
            ctx.gen("genGetterSetter", (Classifier)part, (EglContext)ctx, out, new Object[]{field});
        }
    }

    public void genGetterSetter(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
    }

    public void genFunctions(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        for (Function function : part.getFunctions()) {
            ctx.gen("genFunction", (Classifier)part, (EglContext)ctx, out, new Object[]{function});
        }
    }

    public void genFunction(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
        out.println(",");
        ctx.gen("genDeclaration", (EObject)((Function)args[0]), (TemplateContext)ctx, out, args);
    }

    public void genAdditionalConstructorParams(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
    }

    public void genAdditionalSuperConstructorArgs(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
    }

    public void genDeclaration(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
    }

    public void genSuperClass(EGLClass part, Context ctx, TabbedWriter out, Object ... args) {
    }
}

