/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript;

import org.eclipse.edt.gen.GenerationException;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class CommonUtilities {
    public static String getEglNameForType(Type type) {
        switch (TypeUtils.getTypeKind((Type)type)) {
            case 1: {
                return "any";
            }
            case 27: {
                return "boolean";
            }
            case 9: {
                return "bigint";
            }
            case 18: {
                return "date";
            }
            case 16: {
                return "float";
            }
            case 10: {
                return "decimal";
            }
            case 8: {
                return "int";
            }
            case 13: {
                return "num";
            }
            case 17: {
                return "smallfloat";
            }
            case 7: {
                return "smallint";
            }
            case 5: {
                return "string";
            }
            case 19: {
                return "time";
            }
            case 20: {
                return "timeStamp";
            }
        }
        return "undefined";
    }

    public static String getEglNameForTypeCamelCase(Type type) {
        String name = CommonUtilities.getEglNameForType(type);
        StringBuilder b = new StringBuilder(name);
        b.setCharAt(0, Character.toUpperCase(name.charAt(0)));
        return b.toString();
    }

    public static String getNativeRuntimeOperationName(BinaryExpression expr) throws GenerationException {
        if (expr.getOperation() == null || expr.getOperation().getName() == null) {
            throw new GenerationException();
        }
        String op = expr.getOperator();
        if (op.equals("+")) {
            return "plus";
        }
        if (op.equals("-")) {
            return "minus";
        }
        if (op.equals("/")) {
            return "divide";
        }
        if (op.equals("*")) {
            return "multiply";
        }
        if (op.equals("%")) {
            return "modulo";
        }
        if (op.equals("==")) {
            return "equals";
        }
        if (op.equals("!=")) {
            return "notEquals";
        }
        if (op.equals("<")) {
            return "compareTo";
        }
        if (op.equals(">")) {
            return "compareTo";
        }
        if (op.equals("<=")) {
            return "compareTo";
        }
        if (op.equals(">=")) {
            return "compareTo";
        }
        if (op.equals("&&")) {
            return "and";
        }
        if (op.equals("||")) {
            return "or";
        }
        if (op.equals("xor")) {
            return "xor";
        }
        if (op.equals("::")) {
            return "concat";
        }
        if (op.equals("?:")) {
            return "concat";
        }
        if (op.equals("&")) {
            return "bitand";
        }
        if (op.equals("|")) {
            return "bitor";
        }
        if (op.equals("**")) {
            return "power";
        }
        if (op.equals("in")) {
            return "in";
        }
        if (op.equals("matches")) {
            return "matches";
        }
        if (op.equals("like")) {
            return "like";
        }
        return "UnknownOp";
    }

    public static String getNativeRuntimeComparisionOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("<")) {
            return " < 0";
        }
        if (op.equals(">")) {
            return " > 0";
        }
        if (op.equals("<=")) {
            return " <= 0";
        }
        if (op.equals(">=")) {
            return " >= 0";
        }
        return "";
    }

    public static String getNativeJavaOperation(BinaryExpression expr, Context ctx) {
        String op = expr.getOperator();
        if (expr.isNullable() || ((Boolean)ctx.getParameter("checkOverflow")).booleanValue()) {
            if (op.equals("==")) {
                return " == ";
            }
            if (op.equals("!=")) {
                return " != ";
            }
            if (op.equals("<")) {
                return " < ";
            }
            if (op.equals(">")) {
                return " > ";
            }
            if (op.equals("<=")) {
                return " <= ";
            }
            if (op.equals(">=")) {
                return " >= ";
            }
            if (op.equals("&&")) {
                return " && ";
            }
            if (op.equals("||")) {
                return " || ";
            }
            if (op.equals("xor")) {
                return " ^ ";
            }
            if (op.equals("::")) {
                return " + ";
            }
            if (op.equals("&")) {
                return " & ";
            }
            if (op.equals("|")) {
                return " | ";
            }
            return "";
        }
        if (op.equals("+")) {
            return " + ";
        }
        if (op.equals("-")) {
            return " - ";
        }
        if (op.equals("*")) {
            return " * ";
        }
        if (op.equals("%")) {
            return " % ";
        }
        if (op.equals("==")) {
            return " == ";
        }
        if (op.equals("!=")) {
            return " != ";
        }
        if (op.equals("<")) {
            return " < ";
        }
        if (op.equals(">")) {
            return " > ";
        }
        if (op.equals("<=")) {
            return " <= ";
        }
        if (op.equals(">=")) {
            return " >= ";
        }
        if (op.equals("&&")) {
            return " && ";
        }
        if (op.equals("||")) {
            return " || ";
        }
        if (op.equals("xor")) {
            return " ^ ";
        }
        if (op.equals("::")) {
            return " + ";
        }
        if (op.equals("&")) {
            return " & ";
        }
        if (op.equals("|")) {
            return " | ";
        }
        return "";
    }
}

