/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen;

import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class CommonUtilities {
    public static boolean processTypeList(String method, Type type, EglContext ctx, TabbedWriter out, Object ... args) {
        if (CommonUtilities.isProcessWithTypeList(args)) {
            ctx.gen(method, CommonUtilities.getTypeFromList(args), (TemplateContext)ctx, out, CommonUtilities.genProcessWithoutTypeList(args));
            return true;
        }
        if (CommonUtilities.isProcessWithoutTypeList(args)) {
            ctx.gen(method, (EObject)type, (TemplateContext)ctx, out, CommonUtilities.genFinishWithoutTypeList(args));
            return true;
        }
        return false;
    }

    private static boolean isProcessWithTypeList(Object ... args) {
        int i = 0;
        while (i < args.length - 1) {
            if (args[i] instanceof EglContext.TypeLogicKind && (EglContext.TypeLogicKind)((Object)args[i]) == EglContext.TypeLogicKind.Process) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static EObject getTypeFromList(Object ... args) {
        int i = 0;
        while (i < args.length - 1) {
            if (args[i] instanceof EglContext.TypeLogicKind && (EglContext.TypeLogicKind)((Object)args[i]) == EglContext.TypeLogicKind.Process) {
                return (EObject)args[i + 1];
            }
            ++i;
        }
        return null;
    }

    private static Object[] genProcessWithoutTypeList(Object ... args) {
        int i = 0;
        while (i < args.length) {
            if (args[i] instanceof EglContext.TypeLogicKind && (EglContext.TypeLogicKind)((Object)args[i]) == EglContext.TypeLogicKind.Process) {
                Object[] objects = new Object[i + 1];
                int j = 0;
                while (j < i) {
                    objects[j] = args[j];
                    ++j;
                }
                objects[i] = EglContext.TypeLogicKind.Process;
                return objects;
            }
            ++i;
        }
        return null;
    }

    private static boolean isProcessWithoutTypeList(Object ... args) {
        return args.length > 0 && args[args.length - 1] instanceof EglContext.TypeLogicKind && (EglContext.TypeLogicKind)((Object)args[args.length - 1]) == EglContext.TypeLogicKind.Process;
    }

    private static Object[] genFinishWithoutTypeList(Object ... args) {
        int i = 0;
        while (i < args.length) {
            if (args[i] instanceof EglContext.TypeLogicKind && (EglContext.TypeLogicKind)((Object)args[i]) == EglContext.TypeLogicKind.Process) {
                Object[] objects = new Object[i + 1];
                int j = 0;
                while (j < i) {
                    objects[j] = args[j];
                    ++j;
                }
                objects[i] = EglContext.TypeLogicKind.Finish;
                return objects;
            }
            ++i;
        }
        return null;
    }

    public static Object[] genWithoutTypeList(Object ... args) {
        int i = 0;
        while (i < args.length) {
            if (args[i] instanceof EglContext.TypeLogicKind) {
                Object[] objects = new Object[i];
                int j = 0;
                while (j < i) {
                    objects[j] = args[j];
                    ++j;
                }
                return objects;
            }
            ++i;
        }
        return args;
    }

    public static boolean isArgumentToBeAltered(FunctionParameter parameter, Expression expression, EglContext ctx) {
        if (parameter.getParameterKind() == ParameterKind.PARM_IN) {
            if (TypeUtils.isReferenceType((Type)parameter.getType())) {
                return false;
            }
            return parameter.getType().equals(expression.getType()) == false || parameter.isNullable() || expression.isNullable() || !ctx.mapsToPrimitiveType(parameter.getType());
        }
        return CommonUtilities.isBoxedParameterType(parameter, ctx);
    }

    public static boolean isBoxedParameterType(FunctionParameter parameter, EglContext ctx) {
        if (parameter.getParameterKind() == ParameterKind.PARM_INOUT) {
            if (TypeUtils.isReferenceType((Type)parameter.getType())) {
                return true;
            }
            if (ctx.mapsToPrimitiveType(parameter.getType())) {
                return true;
            }
            if (parameter.isNullable()) {
                return true;
            }
        } else if (parameter.getParameterKind() == ParameterKind.PARM_OUT) {
            return true;
        }
        return false;
    }
}

