/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.EGLMessages;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.edt.gen.EGLMessages.IEGLMessageContributor;
import org.eclipse.edt.gen.EGLMessages.IEGLNestedMessageContributor;
import org.eclipse.edt.gen.EGLMessages.IGenerationResultsMessage;

public class EGLMessage
implements IGenerationResultsMessage {
    protected int severity = 0;
    private String id = null;
    private String[] params = null;
    private IEGLMessageContributor messageContributor;
    private int startLineNumber = 0;
    private int endLineNumber = 0;
    private int endOffset = 0;
    private int startOffset = 0;
    private int startColumnNumber = 0;
    private int endColumnNumber = 0;
    private String builtMessage;
    private static Map<String, String> messageBundle;
    private String partName;
    private static final MessageFormat formatter;
    public static final int EGL_ERROR_MESSAGE = 1;
    public static final int EGL_WARNING_MESSAGE = 2;
    public static final int EGL_INFORMATIONAL_MESSAGE = 3;

    static {
        formatter = new MessageFormat("");
    }

    public EGLMessage() {
    }

    public EGLMessage(Map<String, String> mapping, int aSeverity, String anId, String[] aParams) {
        this.severity = aSeverity;
        this.id = anId;
        this.params = aParams;
        messageBundle = mapping;
        this.builtMessage = EGLMessage.buildMessageText(anId, aParams);
    }

    public EGLMessage(Map<String, String> mapping, int aSeverity, String anId, Object aMessageContributor, String[] aParams, int aStartOffset, int anEndOffset) {
        messageBundle = mapping;
        this.severity = aSeverity;
        this.id = anId;
        this.params = aParams;
        this.setStartOffset(aStartOffset);
        this.setEndOffset(anEndOffset);
        this.builtMessage = EGLMessage.buildMessageText(anId, aParams);
        if (aMessageContributor != null && aMessageContributor instanceof IEGLMessageContributor) {
            IEGLMessageContributor mc = (IEGLMessageContributor)aMessageContributor;
            this.setMessageContributor(mc);
            if (aStartOffset == -1 && mc.getStart() != null) {
                this.setStartLine(mc.getStart().getLine());
                this.setStartColumn(mc.getStart().getColumn());
                this.setStartOffset(mc.getStart().getOffset());
            }
            if (anEndOffset == -1 && mc.getEnd() != null) {
                this.setEndLine(mc.getEnd().getLine());
                this.setEndColumn(mc.getEnd().getColumn());
                this.setEndOffset(mc.getEnd().getOffset() + 1);
            }
        }
    }

    public EGLMessage(Map<String, String> mapping, int aSeverity, String anId, Object aMessageContributor, String[] aParams, int aStartLine, int aStartColumn, int anEndLine, int anEndColumn) {
        int aStartOffset = 0;
        int anEndOffset = 0;
        messageBundle = mapping;
        this.severity = aSeverity;
        this.id = anId;
        this.params = aParams;
        this.builtMessage = EGLMessage.buildMessageText(anId, aParams);
        if (aMessageContributor != null && aMessageContributor instanceof IEGLMessageContributor) {
            IEGLMessageContributor mc = (IEGLMessageContributor)aMessageContributor;
            this.setMessageContributor(mc);
            if (aStartLine == -1 && mc.getStart() != null) {
                aStartLine = mc.getStart().getLine();
                aStartColumn = mc.getStart().getColumn();
                aStartOffset = mc.getStart().getOffset();
            }
            if (anEndLine == -1 && mc.getEnd() != null) {
                anEndLine = mc.getEnd().getLine();
                anEndColumn = mc.getEnd().getColumn();
                anEndOffset = mc.getEnd().getOffset() + 1;
            }
        }
        this.setStartLine(aStartLine);
        this.setStartColumn(aStartColumn);
        this.setEndLine(anEndLine);
        this.setEndColumn(anEndColumn);
        this.setStartOffset(aStartOffset);
        this.setEndOffset(anEndOffset);
    }

    public static String buildMessageText(String key, Object[] inserts) {
        String message = messageBundle.get(key);
        if (message != null) {
            if (inserts == null || inserts.length == 0) {
                return message;
            }
            formatter.applyPattern(message);
            return formatter.format(EGLMessage.insertsWithoutNulls(inserts));
        }
        return key;
    }

    public static Object[] insertsWithoutNulls(Object[] originalInserts) {
        int numberInserts = originalInserts.length;
        Object[] newInserts = new Object[numberInserts];
        int i = 0;
        while (i < numberInserts) {
            newInserts[i] = originalInserts[i] != null ? originalInserts[i] : "";
            ++i;
        }
        return newInserts;
    }

    public static EGLMessage createEGLMessage(Map<String, String> mapping, int aSeverity, String messageID, Object messageContributor, String[] inserts, int aStartLine, int aStartOffset, int anEndLine, int anEndOffset) {
        return new EGLMessage(mapping, aSeverity, messageID, messageContributor, inserts, aStartLine, aStartOffset, anEndLine, anEndOffset);
    }

    @Override
    public String getBuiltMessage() {
        String flag = " ";
        switch (this.getSeverity()) {
            case 1: {
                flag = "e";
                break;
            }
            case 2: {
                flag = "w";
                break;
            }
            case 3: {
                flag = "i";
            }
        }
        return "IWN." + messageBundle.get("group") + "." + this.id + "." + flag + " " + this.startLineNumber + "/" + this.startColumnNumber + " " + this.builtMessage;
    }

    public String getBuiltMessageWithoutLineAndColumn() {
        String flag = " ";
        switch (this.getSeverity()) {
            case 1: {
                flag = "e";
                break;
            }
            case 2: {
                flag = "w";
                break;
            }
            case 3: {
                flag = "i";
            }
        }
        return "IWN." + messageBundle.get("group") + "." + this.id + "." + flag + " " + this.builtMessage;
    }

    @Override
    public String getBuiltMessageWithLineAndColumn() {
        String flag = " ";
        switch (this.getSeverity()) {
            case 1: {
                flag = "e";
                break;
            }
            case 2: {
                flag = "w";
                break;
            }
            case 3: {
                flag = "i";
            }
        }
        if (this.messageContributor instanceof IEGLMessageContributor && this.messageContributor.getResourceName() != null) {
            return "IWN." + messageBundle.get("group") + "." + this.id + "." + flag + " - " + this.messageContributor.getResourceName() + " - " + this.startLineNumber + "/" + this.startColumnNumber + " - " + this.builtMessage;
        }
        return "IWN." + messageBundle.get("group") + "." + this.id + "." + flag + " - " + this.startLineNumber + "/" + this.startColumnNumber + " - " + this.builtMessage;
    }

    public int getEndColumn() {
        return this.endColumnNumber;
    }

    public int getEndLine() {
        return this.endLineNumber;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Object getMessageContributor() {
        return this.messageContributor;
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    public int getStartColumn() {
        return this.startColumnNumber;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public int getStartLine() {
        return this.startLineNumber;
    }

    @Override
    public boolean isError() {
        return this.getSeverity() == 1;
    }

    public boolean isInformational() {
        return this.getSeverity() == 3;
    }

    public boolean isWarning() {
        return this.getSeverity() == 2;
    }

    public String primGetBuiltMessage() {
        return this.builtMessage;
    }

    public void setBuiltMessage(String msgText) {
        this.builtMessage = msgText;
    }

    public void setEndColumn(int newColumnNumber) {
        this.endColumnNumber = newColumnNumber < 0 ? 0 : newColumnNumber;
    }

    public void setEndLine(int lineNumber) {
        this.endLineNumber = lineNumber < 0 ? 0 : lineNumber;
    }

    public void setMessageContributor(IEGLMessageContributor newPart) {
        this.messageContributor = newPart.getMessageContributor();
    }

    public void setMessageContributor(IEGLNestedMessageContributor newPart) {
        this.messageContributor = newPart.getMessageContributor();
    }

    public void setStartColumn(int newColumnNumber) {
        this.startColumnNumber = newColumnNumber < 0 ? 0 : newColumnNumber;
    }

    public void setStartLine(int lineNumber) {
        this.startLineNumber = lineNumber < 0 ? 0 : lineNumber;
    }

    public void setStartOffset(int offset) {
        this.startOffset = offset < 0 ? 0 : offset;
    }

    public void setEndOffset(int offset) {
        this.endOffset = offset < 0 ? 0 : offset;
    }

    public String toString() {
        return String.valueOf(this.getId()) + ": " + this.builtMessage;
    }

    public String[] getParams() {
        return this.params;
    }

    public String getPartName() {
        return this.partName;
    }

    public void setPartName(String partName) {
        this.partName = partName;
    }

    @Override
    public String getResourceName() {
        if (this.getMessageContributor() instanceof IEGLMessageContributor) {
            return ((IEGLMessageContributor)this.getMessageContributor()).getResourceName();
        }
        return null;
    }
}

