/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.EGLMessages.EGLMessage;
import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.gen.GenerationException;
import org.eclipse.edt.mof.codegen.api.TabbedReportWriter;
import org.eclipse.edt.mof.codegen.api.TemplateFactory;
import org.eclipse.edt.mof.egl.Part;

public abstract class Generator {
    protected TemplateFactory factory = new TemplateFactory();

    public Generator(AbstractGeneratorCommand processor) {
        EglContext context = this.makeContext(processor);
        context.setTemplateFactory(this.factory);
        Map parameterMapping = processor.parameterMapping;
        for (Map.Entry entry : parameterMapping.entrySet()) {
            context.put(entry.getKey(), entry.getValue());
        }
        this.factory.load(processor.getTemplates(), processor.getClass().getClassLoader());
    }

    public abstract EglContext makeContext(AbstractGeneratorCommand var1);

    public abstract void generate(Part var1) throws GenerationException;

    public abstract void generate(Object var1) throws GenerationException;

    public abstract void processFile(String var1);

    public abstract String getResult();

    public abstract void dumpErrorMessages();

    public String getRelativeFileName(Part part) {
        return String.valueOf(part.getTypeSignature().replaceAll("\\.", "/")) + this.getFileExtention();
    }

    public abstract String getFileExtention();

    protected static void writeFileUtil(EglContext context, String fileName, String output, String encoding, String encodingError, String writeError) {
        File outFile = new File(fileName);
        try {
            FileOutputStream outStream = new FileOutputStream(outFile);
            byte[] outBytes = output.getBytes(encoding);
            outStream.write(outBytes, 0, outBytes.length);
            outStream.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String[] details = new String[]{encoding};
            EGLMessage message = EGLMessage.createEGLMessage(context.getMessageMapping(), 1, encodingError, null, details, 0, 0, 0, 0);
            context.getMessageRequestor().addMessage(message);
        }
        catch (IOException iOException) {
            String[] details = new String[]{outFile.getName()};
            EGLMessage message = EGLMessage.createEGLMessage(context.getMessageMapping(), 1, writeError, null, details, 0, 0, 0, 0);
            context.getMessageRequestor().addMessage(message);
            return;
        }
    }

    public TabbedReportWriter getReport() {
        return null;
    }

    protected static void writeReport(EglContext context, String fileName, TabbedReportWriter report, String encodingError, String writeError) {
        try {
            if (report != null) {
                String fn = String.valueOf(fileName.substring(0, fileName.lastIndexOf(46))) + ".html";
                String rpt = report.rpt.getWriter().toString();
                Generator.writeFileUtil(context, fn, rpt, "UTF-8", encodingError, writeError);
            }
        }
        catch (Exception exception) {
            System.err.println("Error writing generation report for " + fileName);
        }
    }
}

