/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.gen.CommonUtilities;
import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EVisitor;
import org.eclipse.edt.mof.egl.Assignment;
import org.eclipse.edt.mof.egl.AssignmentStatement;
import org.eclipse.edt.mof.egl.CaseStatement;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.ContinueStatement;
import org.eclipse.edt.mof.egl.DeclarationExpression;
import org.eclipse.edt.mof.egl.DelegateInvocation;
import org.eclipse.edt.mof.egl.ExitStatement;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.ForEachStatement;
import org.eclipse.edt.mof.egl.ForStatement;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionInvocation;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.IfStatement;
import org.eclipse.edt.mof.egl.InvocationExpression;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.LHSExpr;
import org.eclipse.edt.mof.egl.LocalVariableDeclarationStatement;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.OpenUIStatement;
import org.eclipse.edt.mof.egl.Operation;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.QualifiedFunctionInvocation;
import org.eclipse.edt.mof.egl.ReturnStatement;
import org.eclipse.edt.mof.egl.SetValuesExpression;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StatementBlock;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.WhileStatement;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.impl.AbstractVisitor;
import org.eclipse.edt.mof.impl.EObjectImpl;

public class ReorganizeCode
extends AbstractVisitor {
    public static final IrFactory factory = IrFactory.INSTANCE;
    EglContext ctx;
    Container currentStatementContainer;
    boolean processedStatement = false;

    public List<StatementBlock> reorgCode(Statement statement, EglContext ctx) {
        this.ctx = ctx;
        this.currentStatementContainer = statement.getContainer();
        this.disallowRevisit();
        this.allowParentTracking();
        this.setReturnData(null);
        statement.accept((EVisitor)this);
        return (List)this.getReturnData();
    }

    public boolean visit(EObject object) {
        return true;
    }

    public boolean visit(Function object) {
        return false;
    }

    public boolean visit(Type object) {
        return false;
    }

    public boolean visit(Operation object) {
        return false;
    }

    public boolean visit(Statement object) {
        if (this.processedStatement) {
            return false;
        }
        this.processedStatement = true;
        return true;
    }

    public boolean visit(ReturnStatement object) {
        this.ctx.putAttribute(object.getContainer(), "functionHasReturnStatement", new Boolean(true));
        return true;
    }

    public boolean visit(CaseStatement object) {
        ReorganizeLabel reorganizeLabel = new ReorganizeLabel();
        if (reorganizeLabel.reorgLabel((Statement)object, this.ctx)) {
            this.ctx.putAttribute(object, "statementNeedsLabel", new Boolean(true));
        }
        return true;
    }

    public boolean visit(ForStatement object) {
        ReorganizeLabel reorganizeLabel = new ReorganizeLabel();
        if (reorganizeLabel.reorgLabel((Statement)object, this.ctx)) {
            this.ctx.putAttribute(object, "statementNeedsLabel", new Boolean(true));
        }
        return true;
    }

    public boolean visit(ForEachStatement object) {
        ReorganizeLabel reorganizeLabel = new ReorganizeLabel();
        if (reorganizeLabel.reorgLabel((Statement)object, this.ctx)) {
            this.ctx.putAttribute(object, "statementNeedsLabel", new Boolean(true));
        }
        return true;
    }

    public boolean visit(OpenUIStatement object) {
        ReorganizeLabel reorganizeLabel = new ReorganizeLabel();
        if (reorganizeLabel.reorgLabel((Statement)object, this.ctx)) {
            this.ctx.putAttribute(object, "statementNeedsLabel", new Boolean(true));
        }
        return true;
    }

    public boolean visit(WhileStatement object) {
        ReorganizeLabel reorganizeLabel = new ReorganizeLabel();
        if (reorganizeLabel.reorgLabel((Statement)object, this.ctx)) {
            this.ctx.putAttribute(object, "statementNeedsLabel", new Boolean(true));
        }
        return true;
    }

    public boolean visit(IfStatement object) {
        ReorganizeIf reorganizeIf;
        List<Statement> statementArray;
        ReorganizeLabel reorganizeLabel = new ReorganizeLabel();
        if (reorganizeLabel.reorgLabel((Statement)object, this.ctx)) {
            this.ctx.putAttribute(object, "statementNeedsLabel", new Boolean(true));
        }
        if ((statementArray = (reorganizeIf = new ReorganizeIf()).reorgIf(object, this.ctx)) != null) {
            StatementBlock block;
            List<Object> blockArray;
            if (this.getReturnData() == null) {
                blockArray = new ArrayList();
                blockArray.add(null);
                blockArray.add(null);
                this.setReturnData(blockArray);
            } else {
                blockArray = (List)this.getReturnData();
            }
            if (blockArray.get(0) == null) {
                block = factory.createStatementBlock();
                block.setContainer(this.currentStatementContainer);
                blockArray.set(0, block);
            }
            block = (StatementBlock)blockArray.get(0);
            int i = 0;
            while (i < statementArray.size()) {
                block.getStatements().add(statementArray.get(i));
                ++i;
            }
        }
        if (object.getFalseBranch() instanceof IfStatement && IRUtils.hasSideEffects((Expression)((IfStatement)object.getFalseBranch()).getCondition())) {
            StatementBlock block = factory.createStatementBlock();
            block.setContainer(this.currentStatementContainer);
            block.getStatements().add(object.getFalseBranch());
            object.setFalseBranch((Statement)block);
        }
        return true;
    }

    public boolean visit(SetValuesExpression object) {
        StatementBlock block;
        List<Object> blockArray;
        boolean hasSideEffects = IRUtils.hasSideEffects((Expression)object.getTarget());
        if (this.getReturnData() == null) {
            blockArray = new ArrayList();
            blockArray.add(null);
            blockArray.add(null);
            this.setReturnData(blockArray);
        } else {
            blockArray = (List)this.getReturnData();
        }
        if (blockArray.get(0) == null) {
            block = factory.createStatementBlock();
            block.setContainer(this.currentStatementContainer);
            blockArray.set(0, block);
        }
        block = (StatementBlock)blockArray.get(0);
        if (hasSideEffects) {
            String temporary = this.ctx.nextTempName();
            LocalVariableDeclarationStatement localDeclaration = factory.createLocalVariableDeclarationStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                localDeclaration.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            localDeclaration.setContainer(this.currentStatementContainer);
            DeclarationExpression declarationExpression = factory.createDeclarationExpression();
            if (object.getAnnotation("EGL_Location") != null) {
                declarationExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            Field field = factory.createField();
            field.setName(temporary);
            field.setType(object.getType());
            field.setIsNullable(object.isNullable());
            declarationExpression.getFields().add(field);
            localDeclaration.setExpression(declarationExpression);
            block.getStatements().add(localDeclaration);
            MemberName nameExpression = factory.createMemberName();
            if (object.getAnnotation("EGL_Location") != null) {
                nameExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            nameExpression.setMember((Member)field);
            nameExpression.setId(field.getName());
            declarationExpression = ((LocalVariableDeclarationStatement)object.getSettings().getStatements().get(0)).getExpression();
            MemberName tempExpression = factory.createMemberName();
            if (object.getAnnotation("EGL_Location") != null) {
                tempExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            tempExpression.setMember((Member)declarationExpression.getFields().get(0));
            tempExpression.setId(((Field)declarationExpression.getFields().get(0)).getName());
            AssignmentStatement assignmentStatement = factory.createAssignmentStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            assignmentStatement.setContainer(this.currentStatementContainer);
            Assignment assignment = factory.createAssignment();
            if (object.getAnnotation("EGL_Location") != null) {
                assignment.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            assignmentStatement.setAssignment(assignment);
            assignment.setLHS((LHSExpr)nameExpression);
            assignment.setRHS((Expression)tempExpression);
            object.getSettings().getStatements().add(assignmentStatement);
            block.getStatements().add(object.getSettings());
            if (this.getParent() instanceof List) {
                ((List)this.getParent()).set(this.getParentSlotIndex(), nameExpression);
            } else {
                ((EObjectImpl)this.getParent()).slotSet(this.getParentSlotIndex(), (Object)nameExpression);
            }
        } else {
            block.getStatements().add(object.getSettings());
            if (this.getParent() instanceof List) {
                ((List)this.getParent()).set(this.getParentSlotIndex(), object.getTarget());
            } else {
                ((EObjectImpl)this.getParent()).slotSet(this.getParentSlotIndex(), (Object)object.getTarget());
            }
        }
        return true;
    }

    public boolean visit(QualifiedFunctionInvocation object) {
        this.processInvocation((InvocationExpression)object);
        return true;
    }

    public boolean visit(FunctionInvocation object) {
        this.processInvocation((InvocationExpression)object);
        return true;
    }

    public boolean visit(DelegateInvocation object) {
        this.processInvocation((InvocationExpression)object);
        return true;
    }

    private void processInvocation(InvocationExpression object) {
        List<Object> blockArray;
        boolean altered = false;
        boolean[] argumentToBeAltered = new boolean[object.getTarget().getParameters().size()];
        int i = 0;
        while (i < object.getTarget().getParameters().size()) {
            if (CommonUtilities.isArgumentToBeAltered((FunctionParameter)object.getTarget().getParameters().get(i), (Expression)object.getArguments().get(i), this.ctx)) {
                altered = true;
                argumentToBeAltered[i] = true;
            }
            ++i;
        }
        if (!altered) {
            return;
        }
        if (this.getReturnData() == null) {
            blockArray = new ArrayList();
            blockArray.add(null);
            blockArray.add(null);
            this.setReturnData(blockArray);
        } else {
            blockArray = (List)this.getReturnData();
        }
        int i2 = 0;
        while (i2 < object.getTarget().getParameters().size()) {
            FunctionParameter parameter = (FunctionParameter)object.getTarget().getParameters().get(i2);
            if (argumentToBeAltered[i2]) {
                StatementBlock declarationBlock;
                Assignment assignment;
                AssignmentStatement assignmentStatement;
                MemberName nameExpression;
                Field field;
                DeclarationExpression declarationExpression;
                LocalVariableDeclarationStatement localDeclaration;
                String temporary;
                StatementBlock block;
                if (blockArray.get(0) == null) {
                    block = factory.createStatementBlock();
                    block.setContainer(this.currentStatementContainer);
                    blockArray.set(0, block);
                }
                block = (StatementBlock)blockArray.get(0);
                if (parameter.getParameterKind() == ParameterKind.PARM_IN) {
                    temporary = this.ctx.nextTempName();
                    localDeclaration = factory.createLocalVariableDeclarationStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        localDeclaration.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    localDeclaration.setContainer(this.currentStatementContainer);
                    declarationExpression = factory.createDeclarationExpression();
                    if (object.getAnnotation("EGL_Location") != null) {
                        declarationExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    field = factory.createField();
                    field.setName(temporary);
                    field.setType(parameter.getType());
                    field.setIsNullable(parameter.isNullable());
                    nameExpression = factory.createMemberName();
                    if (object.getAnnotation("EGL_Location") != null) {
                        nameExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    nameExpression.setMember((Member)field);
                    nameExpression.setId(field.getName());
                    assignmentStatement = factory.createAssignmentStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    assignmentStatement.setContainer(this.currentStatementContainer);
                    assignment = factory.createAssignment();
                    if (object.getAnnotation("EGL_Location") != null) {
                        assignment.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    assignmentStatement.setAssignment(assignment);
                    assignment.setLHS((LHSExpr)nameExpression);
                    assignment.setRHS((Expression)object.getArguments().get(i2));
                    declarationBlock = factory.createStatementBlock();
                    declarationBlock.setContainer(this.currentStatementContainer);
                    declarationBlock.getStatements().add(assignmentStatement);
                    field.setInitializerStatements(declarationBlock);
                    field.setHasSetValuesBlock(Boolean.valueOf(true));
                    this.ctx.putAttribute(field, "functionArgumentTemporaryVariable", ParameterKind.PARM_IN);
                    declarationExpression.getFields().add(field);
                    localDeclaration.setExpression(declarationExpression);
                    block.getStatements().add(localDeclaration);
                    object.getArguments().set(i2, nameExpression);
                } else if (parameter.getParameterKind() == ParameterKind.PARM_INOUT) {
                    temporary = this.ctx.nextTempName();
                    localDeclaration = factory.createLocalVariableDeclarationStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        localDeclaration.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    localDeclaration.setContainer(this.currentStatementContainer);
                    declarationExpression = factory.createDeclarationExpression();
                    if (object.getAnnotation("EGL_Location") != null) {
                        declarationExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    field = factory.createField();
                    field.setName(temporary);
                    field.setType(parameter.getType());
                    field.setIsNullable(parameter.isNullable());
                    this.ctx.putAttribute(field, "functionArgumentTemporaryVariable", ParameterKind.PARM_INOUT);
                    nameExpression = factory.createMemberName();
                    if (object.getAnnotation("EGL_Location") != null) {
                        nameExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    nameExpression.setMember((Member)field);
                    nameExpression.setId(field.getName());
                    assignmentStatement = factory.createAssignmentStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    assignmentStatement.setContainer(this.currentStatementContainer);
                    assignment = factory.createAssignment();
                    if (object.getAnnotation("EGL_Location") != null) {
                        assignment.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    assignmentStatement.setAssignment(assignment);
                    assignment.setLHS((LHSExpr)nameExpression);
                    assignment.setRHS((Expression)object.getArguments().get(i2));
                    declarationBlock = factory.createStatementBlock();
                    declarationBlock.setContainer(this.currentStatementContainer);
                    declarationBlock.getStatements().add(assignmentStatement);
                    field.setInitializerStatements(declarationBlock);
                    field.setHasSetValuesBlock(Boolean.valueOf(true));
                    declarationExpression.getFields().add(field);
                    localDeclaration.setExpression(declarationExpression);
                    block.getStatements().add(localDeclaration);
                    if (object.getArguments().get(i2) instanceof LHSExpr) {
                        if (blockArray.get(1) == null) {
                            block = factory.createStatementBlock();
                            block.setContainer(this.currentStatementContainer);
                            blockArray.set(1, block);
                        }
                        block = (StatementBlock)blockArray.get(1);
                        assignmentStatement = factory.createAssignmentStatement();
                        if (object.getAnnotation("EGL_Location") != null) {
                            assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
                        }
                        assignmentStatement.setContainer(this.currentStatementContainer);
                        assignment = factory.createAssignment();
                        if (object.getAnnotation("EGL_Location") != null) {
                            assignment.addAnnotation(object.getAnnotation("EGL_Location"));
                        }
                        assignmentStatement.setAssignment(assignment);
                        assignment.setLHS((LHSExpr)object.getArguments().get(i2));
                        assignment.setRHS((Expression)nameExpression);
                        block.getStatements().add(assignmentStatement);
                    }
                    object.getArguments().set(i2, nameExpression);
                } else if (parameter.getParameterKind() == ParameterKind.PARM_OUT) {
                    temporary = this.ctx.nextTempName();
                    localDeclaration = factory.createLocalVariableDeclarationStatement();
                    if (object.getAnnotation("EGL_Location") != null) {
                        localDeclaration.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    localDeclaration.setContainer(this.currentStatementContainer);
                    declarationExpression = factory.createDeclarationExpression();
                    if (object.getAnnotation("EGL_Location") != null) {
                        declarationExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    field = factory.createField();
                    field.setName(temporary);
                    field.setType(parameter.getType());
                    field.setIsNullable(parameter.isNullable());
                    this.ctx.putAttribute(field, "functionArgumentTemporaryVariable", ParameterKind.PARM_OUT);
                    nameExpression = factory.createMemberName();
                    if (object.getAnnotation("EGL_Location") != null) {
                        nameExpression.addAnnotation(object.getAnnotation("EGL_Location"));
                    }
                    nameExpression.setMember((Member)field);
                    nameExpression.setId(field.getName());
                    declarationExpression.getFields().add(field);
                    localDeclaration.setExpression(declarationExpression);
                    block.getStatements().add(localDeclaration);
                    if (object.getArguments().get(i2) instanceof LHSExpr) {
                        if (blockArray.get(1) == null) {
                            block = factory.createStatementBlock();
                            block.setContainer(this.currentStatementContainer);
                            blockArray.set(1, block);
                        }
                        block = (StatementBlock)blockArray.get(1);
                        assignmentStatement = factory.createAssignmentStatement();
                        if (object.getAnnotation("EGL_Location") != null) {
                            assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
                        }
                        assignmentStatement.setContainer(this.currentStatementContainer);
                        assignment = factory.createAssignment();
                        if (object.getAnnotation("EGL_Location") != null) {
                            assignment.addAnnotation(object.getAnnotation("EGL_Location"));
                        }
                        assignmentStatement.setAssignment(assignment);
                        assignment.setLHS((LHSExpr)object.getArguments().get(i2));
                        assignment.setRHS((Expression)nameExpression);
                        block.getStatements().add(assignmentStatement);
                    }
                    object.getArguments().set(i2, nameExpression);
                }
            }
            ++i2;
        }
    }

    public class ReorganizeIf
    extends AbstractVisitor {
        EglContext ctx;
        Container currentStatementContainer;

        public List<Statement> reorgIf(IfStatement statement, EglContext ctx) {
            this.ctx = ctx;
            this.currentStatementContainer = statement.getContainer();
            this.disallowRevisit();
            this.allowParentTracking();
            this.setReturnData(null);
            statement.getCondition().accept((EVisitor)this);
            return (List)this.getReturnData();
        }

        public boolean visit(EObject object) {
            return true;
        }

        public boolean visit(Function object) {
            return false;
        }

        public boolean visit(Type object) {
            return false;
        }

        public boolean visit(Operation object) {
            return false;
        }

        public boolean visit(QualifiedFunctionInvocation object) {
            this.processInvocation((InvocationExpression)object);
            return true;
        }

        public boolean visit(FunctionInvocation object) {
            this.processInvocation((InvocationExpression)object);
            return true;
        }

        public boolean visit(DelegateInvocation object) {
            this.processInvocation((InvocationExpression)object);
            return true;
        }

        private void processInvocation(InvocationExpression object) {
            List<LocalVariableDeclarationStatement> statementArray;
            boolean altered = false;
            int i = 0;
            while (i < object.getTarget().getParameters().size()) {
                if (CommonUtilities.isArgumentToBeAltered((FunctionParameter)object.getTarget().getParameters().get(i), (Expression)object.getArguments().get(i), this.ctx)) {
                    altered = true;
                }
                ++i;
            }
            if (!altered) {
                return;
            }
            if (this.getReturnData() == null) {
                statementArray = new ArrayList();
                this.setReturnData(statementArray);
            } else {
                statementArray = (List)this.getReturnData();
            }
            String temporary = this.ctx.nextTempName();
            LocalVariableDeclarationStatement localDeclaration = factory.createLocalVariableDeclarationStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                localDeclaration.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            localDeclaration.setContainer(this.currentStatementContainer);
            DeclarationExpression declarationExpression = factory.createDeclarationExpression();
            if (object.getAnnotation("EGL_Location") != null) {
                declarationExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            Field field = factory.createField();
            field.setName(temporary);
            field.setType(object.getType());
            field.setIsNullable(object.isNullable());
            MemberName nameExpression = factory.createMemberName();
            if (object.getAnnotation("EGL_Location") != null) {
                nameExpression.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            nameExpression.setMember((Member)field);
            nameExpression.setId(field.getName());
            AssignmentStatement assignmentStatement = factory.createAssignmentStatement();
            if (object.getAnnotation("EGL_Location") != null) {
                assignmentStatement.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            assignmentStatement.setContainer(this.currentStatementContainer);
            Assignment assignment = factory.createAssignment();
            if (object.getAnnotation("EGL_Location") != null) {
                assignment.addAnnotation(object.getAnnotation("EGL_Location"));
            }
            assignmentStatement.setAssignment(assignment);
            assignment.setLHS((LHSExpr)nameExpression);
            assignment.setRHS((Expression)object);
            StatementBlock declarationBlock = factory.createStatementBlock();
            declarationBlock.setContainer(this.currentStatementContainer);
            declarationBlock.getStatements().add(assignmentStatement);
            field.setInitializerStatements(declarationBlock);
            field.setHasSetValuesBlock(Boolean.valueOf(true));
            declarationExpression.getFields().add(field);
            localDeclaration.setExpression(declarationExpression);
            statementArray.add(localDeclaration);
            ((EObjectImpl)this.getParent()).slotSet(this.getParentSlotIndex(), (Object)nameExpression);
        }
    }

    public class ReorganizeLabel
    extends AbstractVisitor {
        EglContext ctx;
        boolean needsLabel;
        boolean processed;
        int labelType;

        public boolean reorgLabel(Statement statement, EglContext ctx) {
            this.ctx = ctx;
            this.disallowRevisit();
            this.allowParentTracking();
            statement.accept((EVisitor)this);
            return this.needsLabel;
        }

        public boolean visit(EObject object) {
            return true;
        }

        public boolean visit(Function object) {
            return false;
        }

        public boolean visit(Type object) {
            return false;
        }

        public boolean visit(Operation object) {
            return false;
        }

        public boolean visit(ContinueStatement object) {
            if (object.getLabel() == null || object.getLabel().length() <= 0) {
                if (object.getContinueType() == 1 && this.labelType == 2) {
                    this.needsLabel = true;
                } else if (object.getContinueType() == 2 && this.labelType == 3) {
                    this.needsLabel = true;
                } else if (object.getContinueType() == 3 && this.labelType == 5) {
                    this.needsLabel = true;
                } else if (object.getContinueType() == 4 && this.labelType == 6) {
                    this.needsLabel = true;
                } else if (object.getContinueType() == 0) {
                    this.needsLabel = true;
                }
            }
            return false;
        }

        public boolean visit(ExitStatement object) {
            if (object.getLabel() == null || object.getLabel().length() <= 0) {
                if (object.getExitStatementType() == 1 && this.labelType == 1) {
                    this.needsLabel = true;
                } else if (object.getExitStatementType() == 3 && this.labelType == 2) {
                    this.needsLabel = true;
                } else if (object.getExitStatementType() == 5 && this.labelType == 3) {
                    this.needsLabel = true;
                } else if (object.getExitStatementType() == 2 && this.labelType == 4) {
                    this.needsLabel = true;
                } else if (object.getExitStatementType() == 6 && this.labelType == 5) {
                    this.needsLabel = true;
                } else if (object.getExitStatementType() == 4 && this.labelType == 6) {
                    this.needsLabel = true;
                } else if (object.getExitStatementType() != 9 && object.getExitStatementType() != 7 && object.getExitStatementType() != 9 && object.getExitStatementType() == 0) {
                    this.needsLabel = true;
                }
            }
            return false;
        }

        public boolean visit(CaseStatement object) {
            if (!this.processed) {
                this.processed = true;
                this.labelType = 1;
                return true;
            }
            return this.labelType != 1;
        }

        public boolean visit(ForStatement object) {
            if (!this.processed) {
                this.processed = true;
                this.labelType = 2;
                return true;
            }
            return this.labelType != 2;
        }

        public boolean visit(ForEachStatement object) {
            if (!this.processed) {
                this.processed = true;
                this.labelType = 3;
                return true;
            }
            return this.labelType != 3;
        }

        public boolean visit(IfStatement object) {
            if (!this.processed) {
                this.processed = true;
                this.labelType = 4;
                return true;
            }
            return this.labelType != 4;
        }

        public boolean visit(OpenUIStatement object) {
            if (!this.processed) {
                this.processed = true;
                this.labelType = 5;
                return true;
            }
            return this.labelType != 5;
        }

        public boolean visit(WhileStatement object) {
            if (!this.processed) {
                this.processed = true;
                this.labelType = 6;
                return true;
            }
            return this.labelType != 6;
        }

        public boolean visit(Statement object) {
            return true;
        }
    }
}

