/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.compiler.gen;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.gen.CommandParameter;
import org.eclipse.edt.gen.Generator;
import org.eclipse.edt.gen.generator.java.EGL2Java;
import org.eclipse.edt.ide.core.EDTRuntimeContainer;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.ide.core.utils.EclipseUtilities;
import org.eclipse.edt.mof.codegen.api.TabbedReportWriter;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.utils.LoadPartException;

public class EclipseEGL2Java
extends EGL2Java {
    private final IFile eglFile;
    private final Part part;
    private final IGenerator generatorProvider;

    public EclipseEGL2Java(IFile eglFile, Part part, IGenerator generator) {
        this.eglFile = eglFile;
        this.part = part;
        this.generatorProvider = generator;
    }

    protected List<Part> loadEGLParts() throws LoadPartException {
        ArrayList<Part> parts = new ArrayList<Part>();
        parts.add(this.part);
        return parts;
    }

    protected void writeFile(Part part, Generator generator) throws Exception {
        String outputFolder = (String)((CommandParameter)this.parameterMapping.get("output")).getValue();
        if (EclipseUtilities.shouldWriteFileInEclipse((String)outputFolder)) {
            IFile outputFile = EclipseUtilities.writeFileInEclipse((Part)part, (String)outputFolder, (IFile)this.eglFile, (String)generator.getResult(), (String)generator.getRelativeFileName(part));
            TabbedReportWriter report = generator.getReport();
            if (report != null) {
                String fn = generator.getRelativeFileName(part);
                fn = String.valueOf(fn.substring(0, fn.lastIndexOf(46))) + ".html";
                String rpt = report.rpt.getWriter().toString();
                EclipseUtilities.writeFileInEclipse((Part)part, (String)outputFolder, (IFile)this.eglFile, (String)rpt, (String)fn);
            }
            EclipseUtilities.addToJavaBuildPathIfNecessary((IProject)outputFile.getProject(), (String)outputFolder);
            EclipseUtilities.addRuntimesToProject((IProject)outputFile.getProject(), (EDTRuntimeContainer[])this.generatorProvider.getRuntimeContainers());
            generator.processFile(outputFile.getFullPath().toString());
        } else {
            super.writeFile(part, generator);
        }
    }
}

