/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.compiler.gen;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.Generator;
import org.eclipse.edt.ide.compiler.EDTCompilerIDEPlugin;
import org.eclipse.edt.ide.compiler.gen.EclipseEGL2Java;
import org.eclipse.edt.ide.compiler.gen.EclipseJavaGenerator;
import org.eclipse.edt.ide.core.AbstractGenerator;
import org.eclipse.edt.ide.core.EDTRuntimeContainer;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.jface.preference.IPreferenceStore;

public class JavaGeneratorProvider
extends AbstractGenerator {
    public JavaGeneratorProvider() {
        this.runtimeContainers = new EDTRuntimeContainer[]{EDTCompilerIDEPlugin.JAVA_RUNTIME_CONTAINER};
    }

    public void generate(IFile file, Part part, IEnvironment env, boolean invokedByBuild) {
        try {
            EclipseEGL2Java cmd = new EclipseEGL2Java(file, part, (IGenerator)this);
            cmd.generate(this.buildArgs(file, part), (Generator)new EclipseJavaGenerator((AbstractGeneratorCommand)cmd), env);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String[] buildArgs(IFile file, Part part) throws Exception {
        String[] args = new String[]{"-o", this.getOutputDirectory(file), "-p", part.getName(), "-r", file.getFullPath().toOSString()};
        return args;
    }

    public boolean supportsProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected String getGenerationDirectoryPropertyKey() {
        return "javaGenDirectory";
    }

    protected String getProjectSettingsPluginId() {
        return "org.eclipse.edt.ide.compiler";
    }

    protected String getGenerationDirectoryPreferenceKey() {
        return "org.eclipse.edt.ide.compiler.defaultJavaGenDirectory";
    }

    protected IPreferenceStore getPreferenceStore() {
        return EDTCompilerIDEPlugin.getDefault().getPreferenceStore();
    }
}

