/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.compiler.gen;

import org.eclipse.core.resources.IFile;
import org.eclipse.edt.compiler.internal.core.utils.Aliaser;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.GenerationException;
import org.eclipse.edt.gen.Generator;
import org.eclipse.edt.gen.java.CommonUtilities;
import org.eclipse.edt.ide.compiler.gen.EclipseEGL2Java;
import org.eclipse.edt.ide.compiler.gen.EclipseJavaGenerator;
import org.eclipse.edt.ide.compiler.gen.JavaGeneratorProvider;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.serialization.IEnvironment;

public class WorthlessGeneratorProvider
extends JavaGeneratorProvider {
    public WorthlessGeneratorProvider() {
        this.runtimeContainers = null;
    }

    @Override
    public void generate(IFile file, Part part, IEnvironment env, boolean invokedByBuild) {
        try {
            EclipseEGL2Java cmd = new EclipseEGL2Java(file, part, (IGenerator)this);
            cmd.generate(this.buildArgs(file, part), (Generator)new WorthlessGenerator((AbstractGeneratorCommand)cmd), env);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getGenerationDirectoryPropertyKey() {
        return "worthlessGenDirectory";
    }

    @Override
    protected String getGenerationDirectoryPreferenceKey() {
        return "org.eclipse.edt.ide.compiler.worthlessGenDefaultDirectory";
    }

    private static class WorthlessGenerator
    extends EclipseJavaGenerator {
        public WorthlessGenerator(AbstractGeneratorCommand processor) {
            super(processor);
        }

        public void generate(Part part) throws GenerationException {
            String packageName = CommonUtilities.packageName((Part)part);
            if (packageName != null && packageName.length() > 0) {
                this.out.print("package ");
                this.out.print(packageName);
                this.out.println(';');
            }
            this.out.print("class ");
            Annotation annot = part.getAnnotation("alias");
            String nameOrAlias = annot != null ? (String)annot.getValue() : part.getId();
            this.out.print(Aliaser.getAlias((String)nameOrAlias));
            this.out.println(" {");
            this.out.println("// I'm a completely worthless generator!");
            this.out.println("}");
        }
    }
}

