/*******************************************************************************
 * Copyright © 2010, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.ide.core.internal.model.bde;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.model.bde.IPluginModelBase;

public class TargetPlatformResetJob extends Job {

	private BDEState fState;

	public TargetPlatformResetJob(BDEState newState) {
		super(PDECoreMessages.TargetPlatformResetJob_resetTarget);
		fState = newState;
		setRule(ResourcesPlugin.getWorkspace().getRoot());
	}

	protected IStatus run(IProgressMonitor monitor) {
		//EclipseHomeInitializer.resetEclipseHomeVariable();
		//BDECore.getDefault().getSourceLocationManager().reset();
		//BDECore.getDefault().getJavadocLocationManager().reset();
		IPluginModelBase[] models = fState.getTargetModels();
		removeDisabledBundles(models);
//		PluginModelManager manager = Activator.getPlugin().getModelManager();
//		manager.getExternalModelManager().setModels(models);
		// trigger Extension Registry reloaded before resetState call so listeners can update their extensions points accurately when target is reloaded
		//BDECore.getDefault().getExtensionsRegistry().targetReloaded();
//		manager.resetState(fState);
		//BDECore.getDefault().getFeatureModelManager().targetReloaded();
		monitor.done();
		return Status.OK_STATUS;
	}

	private void removeDisabledBundles(IPluginModelBase[] models) {
		int number = models.length;
		for (int i = 0; i < models.length; i++) {
			if (!models[i].isEnabled()) {
				fState.removeBundleDescription(models[i].getBundleDescription());
				number -= 1;
			}
		}
//		if (number < models.length)
//			fState.resolveState(true);
	}

}
