/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.edt.ide.core.EDTRuntimeContainer;
import org.eclipse.edt.ide.core.ICompiler;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.jface.preference.IPreferenceStore;

public abstract class AbstractGenerator
implements IGenerator {
    private String id;
    private String name;
    private ICompiler compiler;
    protected EDTRuntimeContainer[] runtimeContainers;
    protected String version;
    protected String description;
    protected String provider;
    protected String parentGenId;

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setName(String name) {
        this.name = name != null && name.length() == 0 ? null : name;
    }

    @Override
    public String getName() {
        return this.name == null ? this.id : this.name;
    }

    @Override
    public boolean supportsProject(IProject project) {
        return true;
    }

    @Override
    public ICompiler getCompiler() {
        return this.compiler;
    }

    @Override
    public void setCompiler(ICompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public EDTRuntimeContainer[] getRuntimeContainers() {
        return this.runtimeContainers;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getVersion() {
        return this.version == null ? "" : this.version;
    }

    @Override
    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Override
    public String getProvider() {
        return this.provider == null ? "" : this.provider;
    }

    @Override
    public void setDescription(String desc) {
        this.description = desc;
    }

    @Override
    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    @Override
    public void setParentGeneratorId(String id) {
        this.parentGenId = id;
    }

    @Override
    public String getParentGeneratorId() {
        return this.parentGenId;
    }

    protected String getOutputDirectory(IFile eglFile) {
        return ProjectSettingsUtility.getGenerationDirectory((IResource)eglFile, this.getPreferenceStore(), new ProjectScope(eglFile.getProject()).getNode(this.getProjectSettingsPluginId()), this.getGenerationDirectoryPropertyKey(), this.getGenerationDirectoryPreferenceKey());
    }

    protected abstract String getGenerationDirectoryPropertyKey();

    protected abstract String getProjectSettingsPluginId();

    protected abstract String getGenerationDirectoryPreferenceKey();

    protected abstract IPreferenceStore getPreferenceStore();
}

