/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.ICompiler;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.ide.core.InitializeSystemPartsJob;
import org.eclipse.edt.ide.core.internal.binding.BinaryFileManager;
import org.eclipse.edt.ide.core.internal.builder.ASTManager;
import org.eclipse.edt.ide.core.internal.builder.ResourceChangeProcessor;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyFileInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyResourceChangeProcessor;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.bde.BDEPreferencesManager;
import org.eclipse.edt.ide.core.internal.model.bde.PluginModelManager;
import org.eclipse.edt.ide.core.internal.model.bde.target.ITargetPlatformService;
import org.eclipse.edt.ide.core.internal.model.bde.target.TargetPlatformService;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class EDTCoreIDEPlugin
extends AbstractUIPlugin
implements ISaveParticipant,
IExecutableExtension {
    private static EDTCoreIDEPlugin eglCorePlugin;
    private BundleContext fBundleContext;
    private ServiceRegistration fTargetPlatformService;
    private ServiceRegistration fBundleProjectService;
    private static BDEPreferencesManager fPreferenceManager;
    private PluginModelManager fModelManager;
    public static String PLUGIN_ID;
    public static final String BUILDER_ID;
    public static final String ATT_HANDLE_ID = "org.eclipse.edt.ide.core.internal.model.EGLModelManager.handleId";
    public static String EGL_UTILITIES;
    public static final String PT_COMPILERS = "compilers";
    public static final String PT_GENERATORS = "generators";
    public static final String CLASS = "class";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String COMPILER = "compiler";
    public static final String PREFERENCE_PAGE_ID = "preferencePageId";
    public static final String VERSION = "version";
    public static final String DESCRIPTION = "description";
    public static final String PROVIDER = "provider";
    public static final String PARENT_GEN_ID = "parentGeneratorId";
    public static final String EDT_CONTAINER_ID = "org.eclipse.edt.ide.core.EDT_CONTAINER";
    private ICompiler[] compilers;
    private IGenerator[] generators;
    private final Object compilersAndGeneratorsSynchObj = new Object();
    private ResourceChangeProcessor resourceChangeProcessor = new ResourceChangeProcessor();

    static {
        PLUGIN_ID = "org.eclipse.edt.ide.core";
        BUILDER_ID = String.valueOf(PLUGIN_ID) + ".EDTBuilder";
        EGL_UTILITIES = "org.eclipse.edt.ide.core.internal.utilities";
    }

    public EDTCoreIDEPlugin() {
        eglCorePlugin = this;
    }

    public void doneSaving(ISaveContext context) {
    }

    public static EDTCoreIDEPlugin getPlugin() {
        return eglCorePlugin;
    }

    public synchronized BDEPreferencesManager getPreferencesManager() {
        if (fPreferenceManager == null) {
            fPreferenceManager = new BDEPreferencesManager(PLUGIN_ID);
        }
        return fPreferenceManager;
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
    }

    public Logger getLogger() {
        Logger logger = null;
        try {
            LogManager.getLogManager().readConfiguration();
            logger = Logger.getLogger(PLUGIN_ID);
            logger.setLevel(Level.ALL);
        }
        catch (Throwable t) {
            System.out.println("ERROR - EGL Core Plugin - getting logger");
            System.out.println("REASON: " + t.getMessage());
        }
        return logger;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fBundleContext = context;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this.resourceChangeProcessor, 14);
        workspace.addResourceChangeListener((IResourceChangeListener)ASTManager.getInstance(), 8);
        workspace.addResourceChangeListener((IResourceChangeListener)BinaryFileManager.getInstance(), 24);
        workspace.addResourceChangeListener((IResourceChangeListener)WorkingCopyResourceChangeProcessor.getInstance(), 7);
        EGLModelManager manager = EGLModelManager.getEGLModelManager();
        workspace.addResourceChangeListener((IResourceChangeListener)manager.deltaProcessor, 31);
        EGLCore.getPlugin().getStateLocation();
        ISavedState lastState = workspace.addSaveParticipant((Plugin)EDTCoreIDEPlugin.getPlugin(), new ISaveParticipant(){

            public void doneSaving(ISaveContext context) {
            }

            public void prepareToSave(ISaveContext context) throws CoreException {
            }

            public void rollback(ISaveContext context) {
            }

            public void saving(ISaveContext context) throws CoreException {
                context.needDelta();
            }
        });
        if (lastState == null || !WorkingCopyFileInfoManager.getInstance().hasValidState()) {
            WorkingCopyResourceChangeProcessor.getInstance().initializeWorkingCopyIndex();
        } else {
            lastState.processResourceChangeEvents(new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    WorkingCopyResourceChangeProcessor.getInstance().processPostChange(event.getDelta());
                }
            });
        }
        ExternalProjectManager.getInstance();
        this.startIndexing();
        if (PlatformUI.isWorkbenchRunning()) {
            new InitializeSystemPartsJob().schedule();
        }
    }

    public BundleContext getBundleContext() {
        return this.fBundleContext;
    }

    public Object acquireService(String serviceName) {
        ServiceReference reference = this.fBundleContext.getServiceReference(serviceName);
        if (reference == null) {
            return null;
        }
        Object service = this.fBundleContext.getService(reference);
        if (service != null) {
            this.fBundleContext.ungetService(reference);
        }
        return service;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        ITargetPlatformService tps = (ITargetPlatformService)this.acquireService(ITargetPlatformService.class.getName());
        boolean cfr_ignored_0 = tps instanceof TargetPlatformService;
        if (fPreferenceManager != null) {
            fPreferenceManager.savePluginPreferences();
        }
        if (this.fModelManager != null) {
            this.fModelManager.shutdown();
            this.fModelManager = null;
        }
        if (this.fTargetPlatformService != null) {
            this.fTargetPlatformService.unregister();
            this.fTargetPlatformService = null;
        }
        if (this.fBundleProjectService != null) {
            this.fBundleProjectService.unregister();
            this.fBundleProjectService = null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)ASTManager.getInstance());
        workspace.removeResourceChangeListener((IResourceChangeListener)this.resourceChangeProcessor);
        workspace.removeResourceChangeListener((IResourceChangeListener)WorkingCopyResourceChangeProcessor.getInstance());
        this.fBundleContext = null;
    }

    public PluginModelManager getModelManager() {
        if (this.fModelManager == null) {
            this.fModelManager = new PluginModelManager();
        }
        return this.fModelManager;
    }

    public boolean areModelsInitialized() {
        return this.fModelManager != null && this.fModelManager.isInitialized();
    }

    public void log(String msg, Exception e) {
        this.getLog().log((IStatus)new Status(1, PLUGIN_ID, 0, msg, (Throwable)e));
    }

    public static void log(IStatus status) {
        if (status != null) {
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else if (e.getMessage() != null) {
            status = new Status(4, PLUGIN_ID, 0, e.getMessage(), e);
        }
        EDTCoreIDEPlugin.log(status);
    }

    public static void logErrorMessage(String message) {
        EDTCoreIDEPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, message, null));
    }

    public static void logException(Throwable e) {
        EDTCoreIDEPlugin.logException(e, null);
    }

    public static void logException(Throwable e, String message) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            if (message == null) {
                message = e.getMessage();
            }
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, PLUGIN_ID, 0, message, e);
        }
        EDTCoreIDEPlugin.log(status);
    }

    protected void initializeDefaultPluginPreferences() {
    }

    public void shutdown() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)EGLModelManager.getEGLModelManager().deltaProcessor);
        workspace.removeSaveParticipant((Plugin)EDTCoreIDEPlugin.getPlugin());
        EGLModelManager.getEGLModelManager().shutdown();
    }

    public URL getInstallURL() {
        try {
            return FileLocator.resolve((URL)EDTCoreIDEPlugin.getPlugin().getBundle().getEntry("/"));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void startIndexing() {
        EGLModelManager.getEGLModelManager().getIndexManager().reset();
    }

    public void configureEGLElementMarker(IMarker marker, IEGLElement element) throws CoreException {
        if (element instanceof IMember) {
            element = ((IMember)element).getEGLFile();
        }
        if (marker != null && element != null) {
            marker.setAttribute(ATT_HANDLE_ID, (Object)element.getHandleIdentifier());
        }
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) throws CoreException {
    }

    private void setupCompilersAndGenerators() {
        String id;
        Object command;
        int i;
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(String.valueOf(PLUGIN_ID) + "." + PT_COMPILERS);
        if (elements != null) {
            ArrayList<ICompiler> compilers = new ArrayList<ICompiler>();
            i = 0;
            while (i < elements.length) {
                try {
                    command = elements[i].createExecutableExtension(CLASS);
                    if (command instanceof ICompiler) {
                        ICompiler compiler = (ICompiler)command;
                        id = elements[i].getAttribute(ID);
                        if (id != null && id.length() != 0) {
                            compiler.setId(id);
                            compiler.setName(elements[i].getAttribute(NAME));
                            compiler.setPreferencePageId(elements[i].getAttribute(PREFERENCE_PAGE_ID));
                            compiler.setVersion(elements[i].getAttribute(VERSION));
                            compilers.add(compiler);
                        }
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            this.compilers = compilers.toArray(new ICompiler[compilers.size()]);
        } else {
            this.compilers = new ICompiler[0];
        }
        elements = Platform.getExtensionRegistry().getConfigurationElementsFor(String.valueOf(PLUGIN_ID) + "." + PT_GENERATORS);
        if (elements != null) {
            ArrayList<IGenerator> gens = new ArrayList<IGenerator>();
            i = 0;
            while (i < elements.length) {
                try {
                    command = elements[i].createExecutableExtension(CLASS);
                    if (command instanceof IGenerator) {
                        ICompiler compiler;
                        IGenerator gen = (IGenerator)command;
                        id = elements[i].getAttribute(ID);
                        if (id != null && id.length() != 0 && (compiler = this.findCompiler(elements[i].getAttribute(COMPILER))) != null) {
                            gen.setId(id);
                            gen.setName(elements[i].getAttribute(NAME));
                            gen.setCompiler(compiler);
                            gen.setVersion(elements[i].getAttribute(VERSION));
                            gen.setDescription(elements[i].getAttribute(DESCRIPTION));
                            gen.setParentGeneratorId(elements[i].getAttribute(PARENT_GEN_ID));
                            gen.setProvider(elements[i].getAttribute(PROVIDER));
                            gens.add(gen);
                            compiler.addGenerator(gen);
                        }
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            this.generators = gens.toArray(new IGenerator[gens.size()]);
        } else {
            this.generators = new IGenerator[0];
        }
    }

    private ICompiler findCompiler(String id) {
        if (id == null || id.length() == 0 || this.compilers == null) {
            return null;
        }
        int i = 0;
        while (i < this.compilers.length) {
            if (this.compilers[i].getId().equals(id)) {
                return this.compilers[i];
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGenerator[] getGenerators() {
        Object object = this.compilersAndGeneratorsSynchObj;
        synchronized (object) {
            if (this.generators == null) {
                this.setupCompilersAndGenerators();
            }
        }
        return this.generators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICompiler[] getCompilers() {
        Object object = this.compilersAndGeneratorsSynchObj;
        synchronized (object) {
            if (this.compilers == null) {
                this.setupCompilersAndGenerators();
            }
        }
        return this.compilers;
    }
}

