/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core;

import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;

public class EDTCorePreferenceConstants {
    public static final String EGL_SOURCE_FOLDER = "eglSourceFolder";
    public static final String EGL_OUTPUT_FOLDER = "eglOutputFolder";
    public static final String COMPILER_ID = "compilerId";
    public static final String GENERATOR_IDS = "generatorIds";

    private EDTCorePreferenceConstants() {
    }

    public static void initializeDefaultValues(IPreferenceStore store) {
        store.setDefault(EGL_SOURCE_FOLDER, "eglsource");
        store.setDefault(EGL_OUTPUT_FOLDER, "eglbin");
        store.setDefault(COMPILER_ID, "org.eclipse.edt.ide.compiler.edtCompiler");
        store.setDefault(GENERATOR_IDS, "org.eclipse.edt.ide.gen.JavaGenProvider,org.eclipse.edt.ide.gen.JavaScriptGenProvider");
    }

    public static IPreferenceStore getPreferenceStore() {
        return EDTCoreIDEPlugin.getPlugin().getPreferenceStore();
    }

    public static String getPreference(String key, IJavaProject project) {
        String val;
        if (project != null && (val = new ProjectScope(project.getProject()).getNode(EDTCoreIDEPlugin.PLUGIN_ID).get(key, null)) != null) {
            return val;
        }
        val = new InstanceScope().getNode(EDTCoreIDEPlugin.PLUGIN_ID).get(key, null);
        if (val != null) {
            return val;
        }
        return new DefaultScope().getNode(EDTCoreIDEPlugin.PLUGIN_ID).get(key, null);
    }
}

