/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.ast.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.core.ast.AbstractASTNodeVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.ide.core.ast.rewrite.ASTEdit;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class ASTRewriteVisitor
extends AbstractASTNodeVisitor {
    private IDocument document;
    private TextEdit currentEdit;
    private Map astEdits;
    private Map nodesToDefferedEdits = new HashMap();

    public ASTRewriteVisitor(IDocument document, TextEdit rootTextEdit, Map astEdits) {
        this.document = document;
        this.currentEdit = rootTextEdit;
        this.astEdits = astEdits;
    }

    public boolean visitNode(Node node) {
        List editsForNode = (List)this.astEdits.get(node);
        if (editsForNode != null && !editsForNode.isEmpty()) {
            int initialEditsForNodeSize = editsForNode.size();
            ArrayList<ASTEdit> deferredEdits = new ArrayList<ASTEdit>();
            Iterator iter = editsForNode.iterator();
            while (iter.hasNext()) {
                ASTEdit next = (ASTEdit)iter.next();
                if (!next.isInsertEdit()) continue;
                deferredEdits.add(next);
                iter.remove();
            }
            if (!deferredEdits.isEmpty()) {
                this.nodesToDefferedEdits.put(node, deferredEdits);
                if (editsForNode.isEmpty()) {
                    return true;
                }
            }
            try {
                TextEdit newEdit;
                if (initialEditsForNodeSize == 1) {
                    newEdit = ((ASTEdit)editsForNode.iterator().next()).toTextEdit(this.document);
                } else {
                    newEdit = node instanceof File ? new MultiTextEdit(0, this.document.getLength()) : new MultiTextEdit(node.getOffset(), node.getLength());
                    Iterator iter2 = editsForNode.iterator();
                    while (iter2.hasNext()) {
                        newEdit.addChild(((ASTEdit)iter2.next()).toTextEdit(this.document));
                    }
                }
                this.currentEdit.addChild(newEdit);
                this.currentEdit = newEdit;
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex);
            }
        }
        return true;
    }

    public void endVisitNode(Node node) {
        try {
            List deferredEdits = (List)this.nodesToDefferedEdits.get(node);
            if (deferredEdits != null) {
                Iterator iter = deferredEdits.iterator();
                while (iter.hasNext()) {
                    this.currentEdit.addChild(((ASTEdit)iter.next()).toTextEdit(this.document));
                }
            }
            if (this.astEdits.containsKey(node)) {
                this.currentEdit = this.currentEdit.getParent();
            }
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
    }
}

