/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.binding;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;
import org.eclipse.edt.compiler.internal.io.IIOBufferReader;
import org.eclipse.edt.compiler.internal.io.IIOBufferWriter;
import org.eclipse.edt.compiler.internal.io.IRFileNameUtility;
import org.eclipse.edt.ide.core.ICompiler;
import org.eclipse.edt.ide.core.internal.binding.PartRestoreFailedException;
import org.eclipse.edt.ide.core.internal.builder.IDEEnvironment;
import org.eclipse.edt.ide.core.internal.builder.IFileSystemObjectStore;
import org.eclipse.edt.ide.core.internal.builder.Util;
import org.eclipse.edt.ide.core.internal.compiler.SystemEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.EclipseZipFileBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPath;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.ZipFileBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.partinfo.IPartOrigin;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.IZipFileEntryManager;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;
import org.eclipse.edt.mof.serialization.ObjectStore;
import org.eclipse.edt.mof.serialization.SerializationException;
import org.eclipse.edt.mof.serialization.ZipFileObjectStore;

public class BinaryFileManager
implements IResourceChangeListener {
    private static BinaryFileManager INSTANCE = new BinaryFileManager();
    private final EnvironmentCache environmentCache = new EnvironmentCache();

    private BinaryFileManager() {
    }

    public static BinaryFileManager getInstance() {
        return INSTANCE;
    }

    private IFile getOutputFileForRead(String[] packageName, String partName, IProject project) {
        try {
            return ProjectBuildPathManager.getInstance().getProjectBuildPath(project).getOutputLocation().getFile(org.eclipse.edt.ide.core.internal.utils.Util.stringArrayToPath(IRFileNameUtility.toIRFileName((String[])packageName)).append(IRFileNameUtility.toIRFileName((String)partName)).addFileExtension("ir"));
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void close(IProject project) {
        this.environmentCache.remove(project);
    }

    public IPartBinding readPartBinding(String[] packageName, String name, IProject project) {
        try {
            return this.environmentCache.getPartBinding(project, packageName, name);
        }
        catch (Exception e) {
            throw new PartRestoreFailedException(packageName, name, e);
        }
    }

    public Part readPart(String[] packageName, String name, IProject project) {
        try {
            EObject part = this.environmentCache.get(project, packageName, name);
            if (part instanceof Part) {
                return (Part)part;
            }
            return null;
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    public void write(MofSerializable object, String[] packageName, String partName, IProject project) {
        IPartOrigin origin = ProjectInfoManager.getInstance().getProjectInfo(project).getPartOrigin(packageName, partName);
        if (origin.isOriginEGLFile()) {
            try {
                this.environmentCache.save(project, object);
            }
            catch (SerializationException e) {
                throw new BuildException("IOException", (Throwable)e);
            }
        }
    }

    public void removePart(String[] packageName, String name, IProject project) {
        this.removePart(packageName, name, project, true);
    }

    public void removePart(String[] packageName, String name, IProject project, boolean deleteFromDisk) {
        if (deleteFromDisk) {
            IPath path = this.getOutputFileForRead(packageName, name, project).getFullPath();
            Writer writer = new Writer(ResourcesPlugin.getWorkspace().getRoot().getFile(path));
            writer.allEntriesRemoved();
        }
        this.environmentCache.remove(project, packageName, name);
    }

    public void addPackage(String[] packages, IProject project) {
        IContainer container = ProjectBuildPathManager.getInstance().getProjectBuildPath(project).getOutputLocation();
        try {
            Util.createFolder(org.eclipse.edt.ide.core.internal.utils.Util.stringArrayToPath(IRFileNameUtility.toIRFileName((String[])packages)), container);
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void removePackage(String[] packages, IProject project) {
        IContainer container = ProjectBuildPathManager.getInstance().getProjectBuildPath(project).getOutputLocation();
        if ((container = container.getFolder(org.eclipse.edt.ide.core.internal.utils.Util.stringArrayToPath(IRFileNameUtility.toIRFileName((String[])packages)))).exists()) {
            try {
                container.delete(true, null);
            }
            catch (CoreException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    public void remove(IProject project) {
        this.environmentCache.storeCache.removeAllStores(project);
        this.environmentCache.remove(project);
    }

    public void clean(IProject project) {
        this.environmentCache.storeCache.removeObsoleteStores(project);
        this.environmentCache.remove(project);
    }

    public static IFile getOutputFileForWrite(String[] packageName, String partName, IProject project) throws CoreException {
        IContainer outputLocation = ProjectBuildPathManager.getInstance().getProjectBuildPath(project).getOutputLocation();
        IPath packagePath = org.eclipse.edt.ide.core.internal.utils.Util.stringArrayToPath(IRFileNameUtility.toIRFileName((String[])packageName));
        IContainer container = outputLocation;
        if (packagePath.segmentCount() > 0) {
            container = Util.createFolder(packagePath, outputLocation);
        }
        IPath filePath = new Path(IRFileNameUtility.toIRFileName((String)partName)).addFileExtension("ir");
        return container.getFile(filePath);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 8: 
            case 16: {
                this.environmentCache.clear();
            }
        }
    }

    public IDEEnvironment getEnvironment(IProject project) {
        return this.environmentCache.getEnvironment(project);
    }

    private static class EnvironmentCache {
        private final HashMap<IProject, IDEEnvironment> projectMap = new HashMap();
        private final ObjectStoreCache storeCache = new ObjectStoreCache();

        private EnvironmentCache() {
        }

        public IDEEnvironment getEnvironment(IProject project) {
            IDEEnvironment env = this.projectMap.get(project);
            if (env == null) {
                IDEEnvironment systemEnv;
                env = new IDEEnvironment(project);
                this.projectMap.put(project, env);
                this.storeCache.registerObjectStores(project, env, new ArrayList<IProject>());
                ICompiler compiler = ProjectSettingsUtility.getCompiler(project);
                if (compiler != null && (systemEnv = SystemEnvironmentManager.getSystemEnvironment(compiler)) != null) {
                    env.appendEnvironment((IEnvironment)systemEnv);
                }
                env.appendEnvironment((IEnvironment)Environment.INSTANCE);
            }
            return env;
        }

        public EObject get(IProject project, String[] packageName, String partName) throws DeserializationException, MofObjectNotFoundException {
            IDEEnvironment env = this.getEnvironment(project);
            return env.find(this.key(packageName, partName));
        }

        public IPartBinding getPartBinding(IProject project, String[] packageName, String partName) {
            IDEEnvironment env = this.getEnvironment(project);
            return env.getPartBinding(packageName, partName);
        }

        public void save(IProject project, MofSerializable part) throws SerializationException {
            this.getEnvironment(project).save(part, true);
        }

        public void remove(IProject project, String[] packageName, String partName) {
            IDEEnvironment env = this.projectMap.get(project);
            if (env != null) {
                env.remove(this.key(packageName, partName));
            }
        }

        public void remove(IProject project) {
            IDEEnvironment env = this.projectMap.remove(project);
            if (env != null) {
                Iterator it = this.storeCache.storeMap.values().iterator();
                while (it.hasNext()) {
                    for (ObjectStore store : (List)it.next()) {
                        if (store.getEnvironment() != env) continue;
                        store.setEnvironment(null);
                    }
                }
            }
        }

        public void clear() {
            this.projectMap.clear();
            Iterator it = this.storeCache.storeMap.values().iterator();
            while (it.hasNext()) {
                Iterator stores = ((List)it.next()).iterator();
                while (stores.hasNext()) {
                    ((ObjectStore)stores.next()).setEnvironment(null);
                }
            }
        }

        private String key(String[] packageName, String partName) {
            StringBuilder buf = new StringBuilder();
            buf.append("egl");
            buf.append(":");
            if (packageName != null && packageName.length > 0) {
                buf.append(IRUtils.concatWithSeparator((String[])packageName, (String)"."));
                buf.append('.');
            }
            buf.append(partName);
            return buf.toString();
        }
    }

    private static class ObjectStoreCache {
        private HashMap<IPath, List<ObjectStore>> storeMap = new HashMap();

        private ObjectStoreCache() {
        }

        public void registerObjectStores(IProject project, IDEEnvironment env, List<IProject> seen) {
            if (seen.contains(project)) {
                return;
            }
            boolean isInitialProject = seen.size() == 0;
            seen.add(project);
            ProjectBuildPath buildPath = ProjectBuildPathManager.getInstance().getProjectBuildPath(project);
            IPath path = buildPath.getOutputLocation().getFullPath();
            List<ObjectStore> stores = this.storeMap.get(path);
            if (stores == null) {
                stores = new ArrayList<ObjectStore>();
                this.storeMap.put(path, stores);
                IFileSystemObjectStore iFileSystemObjectStore = new IFileSystemObjectStore(path, (IEnvironment)env, "XML");
                stores.add((ObjectStore)iFileSystemObjectStore);
                env.registerObjectStore("mof", (ObjectStore)iFileSystemObjectStore);
                IFileSystemObjectStore iFileSystemObjectStore2 = new IFileSystemObjectStore(path, (IEnvironment)env, "XML", ".eglxml");
                stores.add((ObjectStore)iFileSystemObjectStore2);
                env.registerObjectStore("egl", (ObjectStore)iFileSystemObjectStore2);
            } else {
                for (ObjectStore objectStore : stores) {
                    objectStore.setEnvironment((IEnvironment)env);
                    env.registerObjectStore(objectStore.getKeyScheme(), objectStore);
                }
            }
            env.addRoot(path.toFile());
            if (isInitialProject) {
                for (ObjectStore objectStore : stores) {
                    env.setDefaultSerializeStore(objectStore.getKeyScheme(), objectStore);
                }
            }
            try {
                IEGLProject iEGLProject = EGLCore.create(project);
                IEGLPathEntry[] iEGLPathEntryArray = iEGLProject.getResolvedEGLPath(true);
                int i = 0;
                while (i < iEGLPathEntryArray.length) {
                    switch (iEGLPathEntryArray[i].getEntryKind()) {
                        case 3: {
                            path = iEGLPathEntryArray[i].getPath();
                            stores = this.storeMap.get(path);
                            if (stores == null) {
                                stores = new ArrayList<ObjectStore>();
                                this.storeMap.put(path, stores);
                                IFileSystemObjectStore store = new IFileSystemObjectStore(path, (IEnvironment)env, "XML", ".eglxml");
                                stores.add((ObjectStore)store);
                                env.registerObjectStore("egl", (ObjectStore)store);
                            } else {
                                for (ObjectStore store : stores) {
                                    store.setEnvironment((IEnvironment)env);
                                    env.registerObjectStore(store.getKeyScheme(), store);
                                }
                            }
                            env.addRoot(path.toFile());
                            break;
                        }
                        case 1: {
                            path = iEGLPathEntryArray[i].getPath();
                            stores = this.storeMap.get(path);
                            if (stores == null) {
                                stores = new ArrayList<ObjectStore>();
                                this.storeMap.put(path, stores);
                                String extension = path.lastSegment().endsWith(".eglar") ? ".eglxml" : ".mofxml";
                                EclipseZipFileBuildPathEntry entry = ZipFileBuildPathEntryManager.getInstance().getZipFileBuildPathEntry(project, path);
                                ZipFileObjectStore store = new ZipFileObjectStore(path.toFile(), (IEnvironment)env, "XML", extension, (IZipFileEntryManager)entry);
                                stores.add((ObjectStore)store);
                                env.registerObjectStore(store.getKeyScheme(), (ObjectStore)store);
                            } else {
                                for (ObjectStore store : stores) {
                                    store.setEnvironment((IEnvironment)env);
                                    env.registerObjectStore(store.getKeyScheme(), store);
                                }
                            }
                            env.addRoot(path.toFile());
                            break;
                        }
                        case 2: {
                            IResource dependency;
                            if (!isInitialProject && !iEGLPathEntryArray[i].isExported() || !((dependency = ResourcesPlugin.getWorkspace().getRoot().findMember(iEGLPathEntryArray[i].getPath())) instanceof IProject)) break;
                            this.registerObjectStores((IProject)dependency, env, seen);
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }

        public void removeAllStores(IProject project) {
            ProjectBuildPath buildPath = ProjectBuildPathManager.getInstance().getProjectBuildPath(project);
            this.storeMap.remove(buildPath.getOutputLocation().getFullPath());
            try {
                IEGLProject eglProject = EGLCore.create(project);
                IPackageFragmentRoot[] packageFragmentRoots = eglProject.getPackageFragmentRoots();
                int i = 0;
                while (i < packageFragmentRoots.length) {
                    this.storeMap.remove(packageFragmentRoots[i].getPath());
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }

        public void removeObsoleteStores(IProject project) {
            ProjectBuildPath buildPath = ProjectBuildPathManager.getInstance().getProjectBuildPath(project);
            ArrayList<IPath> pathsToKeep = new ArrayList<IPath>();
            pathsToKeep.add(buildPath.getOutputLocation().getFullPath());
            try {
                IEGLProject eglProject = EGLCore.create(project);
                IPackageFragmentRoot[] packageFragmentRoots = eglProject.getPackageFragmentRoots();
                int i = 0;
                while (i < packageFragmentRoots.length) {
                    pathsToKeep.add(packageFragmentRoots[i].getPath());
                    ++i;
                }
            }
            catch (CoreException coreException) {}
            String projectName = project.getName();
            Iterator<Map.Entry<IPath, List<ObjectStore>>> it = this.storeMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<IPath, List<ObjectStore>> next = it.next();
                IPath nextPath = next.getKey();
                if (!projectName.equals(nextPath.segment(0)) || pathsToKeep.contains(nextPath)) continue;
                it.remove();
            }
        }
    }

    public static class Reader
    implements IIOBufferReader {
        private IFile bufferFile;

        public Reader(IFile bufferFile) {
            this.bufferFile = bufferFile;
        }

        public Object readEntry(String name) throws IOException {
            byte[] result = null;
            if (this.bufferFile.exists()) {
                try {
                    BufferedInputStream inputStream = new BufferedInputStream(this.bufferFile.getContents());
                    try {
                        byte[] contents = new byte[inputStream.available()];
                        inputStream.read(contents);
                        result = contents;
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (CoreException e) {
                    throw new BuildException("CoreException", (Throwable)e);
                }
            }
            return result;
        }

        public List getEntries() throws IOException {
            ArrayList<String> entries = new ArrayList<String>();
            if (this.bufferFile.exists()) {
                String name = new String(this.bufferFile.getName());
                Path path = new Path(name);
                path = path.removeFileExtension();
                entries.add(InternUtil.intern((String)path.toString()));
            }
            return entries;
        }

        public InputStream getInputStream(String name) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static class Writer
    implements IIOBufferWriter {
        private static final boolean DEBUG = false;
        private byte[] entry;
        private IFile bufferFile;

        public Writer(IFile bufferFile) {
            this.bufferFile = bufferFile;
        }

        public void beginWriting() throws IOException {
            this.entry = null;
        }

        public void writeEntry(String entryName, Object value) throws IOException, SerializationException {
            this.entry = (byte[])value;
        }

        public void finishWriting() throws IOException {
            BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(this.entry));
            try {
                try {
                    if (this.bufferFile.exists()) {
                        if (this.entry.length > 0) {
                            this.bufferFile.setContents((InputStream)inputStream, true, false, null);
                            if (!this.bufferFile.isDerived()) {
                                this.bufferFile.setDerived(true);
                            }
                        } else {
                            this.bufferFile.delete(true, null);
                        }
                    } else if (this.entry.length > 0) {
                        this.bufferFile.create((InputStream)inputStream, 1, null);
                        this.bufferFile.setDerived(true);
                    }
                }
                catch (CoreException coreException) {
                    throw new IOException("EclipseZipFileIOBufferWriter::finishWriting");
                }
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }

        public void allEntriesRemoved() {
            try {
                if (this.bufferFile.exists()) {
                    this.bufferFile.delete(true, false, null);
                }
            }
            catch (CoreException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }
}

