/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;

public abstract class AbstractDuplicatePartManager {
    private HashMap projectMap = new HashMap();

    protected AbstractDuplicatePartManager() {
    }

    public DuplicatePartList getDuplicatePartList(IProject project) {
        DuplicatePartList result = (DuplicatePartList)this.projectMap.get(project);
        if (result == null) {
            result = this.loadDuplicatePartsList(project);
            if (result == null) {
                result = new DuplicatePartList();
            }
            this.projectMap.put(project, result);
        }
        return result;
    }

    public void saveDuplicatePartList(IProject project) {
        DuplicatePartList result = (DuplicatePartList)this.projectMap.get(project);
        if (result != null) {
            try {
                ObjectOutputStream outputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.getDuplicateFilePath(project).toFile())));
                outputStream.writeObject(result);
                outputStream.close();
            }
            catch (FileNotFoundException e) {
                throw new BuildException((Throwable)e);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private DuplicatePartList loadDuplicatePartsList(IProject project) {
        try {
            File duplicatePartsFile = this.getDuplicateFilePath(project).toFile();
            if (duplicatePartsFile.exists()) {
                ObjectInputStream inputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(duplicatePartsFile)));
                DuplicatePartList result = (DuplicatePartList)inputStream.readObject();
                inputStream.close();
                return result;
            }
            return null;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected abstract IPath getDuplicateFilePath(IProject var1);

    public void clear(IProject project) {
        this.projectMap.remove(project);
        File file = this.getDuplicateFilePath(project).toFile();
        if (file.exists()) {
            file.delete();
        }
    }

    public void remove(IProject project) {
        this.projectMap.remove(project);
    }

    public int getCount() {
        return this.projectMap.size();
    }

    public void reLoad(IProject project) {
        this.projectMap.remove(project);
        this.loadDuplicatePartsList(project);
    }

    public static class DuplicatePartList
    implements Serializable {
        private transient HashMap duplicatePartsByFileMap = new HashMap();
        private transient HashMap duplicatePartsByPartMap = new HashMap();

        public void addDuplicatePart(String[] packageName, String partName, IFile file) {
            HashSet<IFile> files = (HashSet<IFile>)this.duplicatePartsByPartMap.get(new DuplicatePartKey(packageName, partName));
            if (files == null) {
                files = new HashSet<IFile>();
                this.duplicatePartsByPartMap.put(new DuplicatePartKey(packageName, partName), files);
            }
            files.add(file);
            HashSet<DuplicatePartKey> parts = (HashSet<DuplicatePartKey>)this.duplicatePartsByFileMap.get(file);
            if (parts == null) {
                parts = new HashSet<DuplicatePartKey>();
                this.duplicatePartsByFileMap.put(file, parts);
            }
            parts.add(new DuplicatePartKey(packageName, partName));
        }

        public boolean isDuplicatePart(String[] packageName, String partName) {
            HashSet files = (HashSet)this.duplicatePartsByPartMap.get(new DuplicatePartKey(packageName, partName));
            if (files != null) {
                return files.size() > 0;
            }
            return false;
        }

        public Set getFilesForDuplicatePart(String[] packageName, String partName) {
            HashSet files = (HashSet)this.duplicatePartsByPartMap.get(new DuplicatePartKey(packageName, partName));
            if (files != null) {
                return Collections.unmodifiableSet(files);
            }
            return Collections.EMPTY_SET;
        }

        public void remove(IFile file) {
            HashSet parts = (HashSet)this.duplicatePartsByFileMap.get(file);
            if (parts != null) {
                for (DuplicatePartKey partKey : parts) {
                    HashSet files = (HashSet)this.duplicatePartsByPartMap.get(partKey);
                    files.remove(file);
                }
                this.duplicatePartsByFileMap.remove(file);
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            Set files = this.duplicatePartsByFileMap.keySet();
            out.writeInt(files.size());
            for (IFile file : files) {
                out.writeObject(file.getFullPath().toOSString());
                HashSet parts = (HashSet)this.duplicatePartsByFileMap.get(file);
                out.writeInt(parts.size());
                for (DuplicatePartKey partKey : parts) {
                    out.writeObject(partKey.packageName);
                    out.writeObject(partKey.partName);
                }
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.duplicatePartsByFileMap = new HashMap();
            this.duplicatePartsByPartMap = new HashMap();
            in.defaultReadObject();
            int numFiles = in.readInt();
            int i = 0;
            while (i < numFiles) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path((String)in.readObject()));
                int numParts = in.readInt();
                int j = 0;
                while (j < numParts) {
                    String[] packageName = (String[])in.readObject();
                    String partName = (String)in.readObject();
                    this.addDuplicatePart(InternUtil.intern((String[])packageName), InternUtil.intern((String)partName), file);
                    ++j;
                }
                ++i;
            }
        }

        private class DuplicatePartKey {
            private String[] packageName;
            private String partName;

            public DuplicatePartKey(String[] packageName, String partName) {
                this.packageName = packageName;
                this.partName = partName;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj instanceof DuplicatePartKey) {
                    DuplicatePartKey otherKey = (DuplicatePartKey)obj;
                    if (otherKey.packageName == this.packageName && otherKey.partName == this.partName) {
                        return true;
                    }
                }
                return false;
            }

            public int hashCode() {
                return this.partName.hashCode();
            }
        }
    }
}

