/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.SystemEnvironment;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.internal.EGLAliasJsfNamesSetting;
import org.eclipse.edt.compiler.internal.EGLVAGCompatibilitySetting;
import org.eclipse.edt.compiler.internal.core.builder.AbstractProcessingQueue;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.builder.CappedProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.GenericTopLevelFunctionProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.BindingCreator;
import org.eclipse.edt.compiler.internal.core.lookup.EnvironmentScope;
import org.eclipse.edt.compiler.internal.core.lookup.FileScope;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionContainerScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.lookup.SystemScope;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;
import org.eclipse.edt.compiler.internal.util.TopLevelFunctionInfo;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.binding.BinaryFileManager;
import org.eclipse.edt.ide.core.internal.builder.ASTManager;
import org.eclipse.edt.ide.core.internal.builder.BuilderResources;
import org.eclipse.edt.ide.core.internal.builder.IDEEnvironment;
import org.eclipse.edt.ide.core.internal.builder.IProcessorRequestor;
import org.eclipse.edt.ide.core.internal.builder.MarkerProblemRequestor;
import org.eclipse.edt.ide.core.internal.builder.PartGenerationQueue;
import org.eclipse.edt.ide.core.internal.builder.TopLevelFunctionProcessingQueue;
import org.eclipse.edt.ide.core.internal.builder.Util;
import org.eclipse.edt.ide.core.internal.compiler.Compiler;
import org.eclipse.edt.ide.core.internal.dependency.DependencyGraph;
import org.eclipse.edt.ide.core.internal.dependency.DependencyGraphManager;
import org.eclipse.edt.ide.core.internal.dependency.DependencyInfo;
import org.eclipse.edt.ide.core.internal.dependency.IFunctionRequestor;
import org.eclipse.edt.ide.core.internal.generation.IDEContext;
import org.eclipse.edt.ide.core.internal.lookup.AbstractProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.FileInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfo;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfo;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfoManager;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.egl.compiler.Context;
import org.eclipse.edt.mof.egl.compiler.EGL2IREnvironment;
import org.eclipse.edt.mof.egl.egl2mof.Egl2Mof;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public abstract class AbstractProcessingQueue
extends org.eclipse.edt.compiler.internal.core.builder.AbstractProcessingQueue {
    protected ProjectInfo projectInfo;
    private static final int MAX_COMPILE_LOOP = 5;
    private IProject project;
    private ProjectEnvironment projectEnvironment;
    private IProcessorRequestor requestor;
    private PartGenerationQueue generationQueue = new PartGenerationQueue();

    public AbstractProcessingQueue(IProject project, IBuildNotifier notifier) {
        super(notifier, (ICompilerOptions)new CompilerOptions());
        this.project = project;
        this.projectInfo = ProjectInfoManager.getInstance().getProjectInfo(project);
        this.projectEnvironment = ProjectEnvironmentManager.getInstance().getProjectEnvironment(project);
    }

    public void process() {
        super.process();
        this.generationQueue.generate();
    }

    protected boolean hasExceededMaxLoop() {
        return this.compileLoop >= 5;
    }

    protected IPartBinding level03Compile(String[] packageName, String caseSensitiveInternedPartName) {
        String caseInsensitiveInternedString = InternUtil.intern((String)caseSensitiveInternedPartName);
        String qualifiedName = this.getQualifiedName(packageName, caseInsensitiveInternedString);
        this.notifier.subTask(String.valueOf(BuilderResources.buildCompiling) + qualifiedName);
        IFile declaringFile = this.projectInfo.getPartOrigin(packageName, caseInsensitiveInternedString).getEGLFile();
        Node partAST = ASTManager.getInstance().getAST(declaringFile, caseInsensitiveInternedString);
        IPartBinding binding = new BindingCreator((IEnvironment)this.projectEnvironment, packageName, caseSensitiveInternedPartName, partAST).getPartBinding();
        binding.setEnvironment((IEnvironment)this.projectEnvironment);
        DependencyInfo dependencyInfo = new DependencyInfo();
        Scope scope = this.createScope(packageName, declaringFile, binding, dependencyInfo);
        CappedProblemRequestor cappedProblemRequestor = new CappedProblemRequestor();
        cappedProblemRequestor.setRequestor(this.createProblemRequestor(caseInsensitiveInternedString, declaringFile, partAST, binding));
        Compiler.getInstance().compilePart(partAST, binding, scope, dependencyInfo, (IProblemRequestor)cappedProblemRequestor, this.compilerOptions);
        if (binding.getKind() == 16) {
            this.validatePackageDeclaration(packageName, declaringFile, partAST, (FileBinding)binding, (IProblemRequestor)cappedProblemRequestor);
        }
        if (binding.getKind() != 16) {
            this.processCompiledPart(packageName, caseInsensitiveInternedString, qualifiedName, (Part)partAST, binding, declaringFile, dependencyInfo, cappedProblemRequestor);
        } else {
            this.processCompiledFilePart(packageName, caseInsensitiveInternedString, declaringFile);
        }
        DependencyGraphManager.getInstance().getDependencyGraph(this.project).putPart(packageName, caseInsensitiveInternedString, org.eclipse.edt.ide.core.internal.utils.Util.getFilePartName(declaringFile), dependencyInfo);
        return binding;
    }

    private void processCompiledFilePart(String[] packageName, String caseInsensitiveInternedString, IFile declaringFile) {
        IFileInfo fileInfo = FileInfoManager.getInstance().getFileInfo(this.project, declaringFile.getProjectRelativePath());
        for (String nextName : fileInfo.getPartNames()) {
            if (nextName == caseInsensitiveInternedString) continue;
            this.addPartFromCompiledFile(packageName, fileInfo.getCaseSensitivePartName(nextName));
        }
    }

    private void processCompiledPart(String[] packageName, String caseInsensitiveInternedString, String qualifiedName, Part partAST, IPartBinding binding, IFile declaringFile, DependencyInfo dependencyInfo, CappedProblemRequestor cappedProblemRequestor) {
        org.eclipse.edt.mof.egl.Part previousPart;
        TopLevelFunctionInfo[] functionInfos = null;
        if (dependencyInfo.getFunctionContainerScope() != null) {
            this.notifier.subTask(BuilderResources.buildProcessingTopLevelFunctions);
            functionInfos = this.processTopLevelFunctions(dependencyInfo.getTopLevelFunctions(), dependencyInfo.getFunctionContainerScope(), declaringFile, dependencyInfo, cappedProblemRequestor);
        }
        File fileAST = ASTManager.getInstance().getFileAST(declaringFile);
        try {
            previousPart = BinaryFileManager.getInstance().readPart(packageName, caseInsensitiveInternedString, this.project);
            BinaryFileManager.getInstance().removePart(packageName, caseInsensitiveInternedString, this.project, false);
        }
        catch (BuildException buildException) {
            previousPart = null;
        }
        MofSerializable part = this.createIRFromBoundAST(partAST, declaringFile, functionInfos, fileAST.getImportDeclarations(), (IProblemRequestor)cappedProblemRequestor);
        if (previousPart == null || !TypeUtils.areStructurallyEquivalent((MofSerializable)previousPart, (MofSerializable)part)) {
            this.notifier.subTask(String.valueOf(BuilderResources.buildAddingDependentsOf) + qualifiedName);
            if (previousPart != null) {
                this.addDependents(packageName, caseInsensitiveInternedString);
            }
            if (this.requestor != null) {
                this.requestor.recordStructuralChange(packageName, caseInsensitiveInternedString, binding.getKind());
            }
        }
        if (ProjectSettingsUtility.getGenerators((IResource)declaringFile).length > 0) {
            this.generationQueue.add(partAST, declaringFile);
        }
        this.notifier.subTask(String.valueOf(BuilderResources.buildCreatingIR) + qualifiedName);
        if (this.canSave(caseInsensitiveInternedString)) {
            BinaryFileManager.getInstance().write(part, packageName, caseInsensitiveInternedString, this.project);
        }
    }

    private MofSerializable createIRFromBoundAST(Part partAST, IFile declaringFile, TopLevelFunctionInfo[] functions, List imports, IProblemRequestor problemRequestor) {
        IDEEnvironment env = BinaryFileManager.getInstance().getEnvironment(this.project);
        Egl2Mof generator = new Egl2Mof((EGL2IREnvironment)env);
        return (MofSerializable)generator.convert(partAST, (Context)new IDEContext(declaringFile), problemRequestor);
    }

    protected void addPartFromCompiledFile(String[] packageName, String partName) {
    }

    protected IPartBinding level02Compile(String[] packageName, String caseSensitiveInternedPartName) {
        return ProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(this.project).compileLevel2Binding(packageName, caseSensitiveInternedPartName);
    }

    protected IPartBinding level01Compile(String[] packageName, String caseSensitiveInternedPartName) {
        return this.projectEnvironment.level01Compile(packageName, caseSensitiveInternedPartName);
    }

    protected IPartBinding getPartBindingFromCache(String[] packageName, String partName) {
        return ProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(this.project).getPartBindingFromCache(packageName, partName);
    }

    protected String getQualifiedName(String[] packageName, String partName) {
        if (new Path(partName).segmentCount() > 1 || packageName.length == 0) {
            return partName;
        }
        String retVal = String.valueOf(org.eclipse.edt.ide.core.internal.utils.Util.stringArrayToPath(packageName).addTrailingSeparator().toString()) + partName;
        return retVal.replace('/', '.');
    }

    private Scope createScope(String[] packageName, IFile declaringFile, IPartBinding binding, DependencyInfo dependencyInfo) {
        EnvironmentScope scope;
        if (binding.getKind() == 16) {
            scope = new EnvironmentScope((IEnvironment)this.projectEnvironment, (IDependencyRequestor)dependencyInfo);
        } else {
            String fileName = org.eclipse.edt.ide.core.internal.utils.Util.getFilePartName(declaringFile);
            IPartBinding fileBinding = this.projectEnvironment.getPartBinding(packageName, fileName);
            scope = new SystemScope((Scope)new FileScope((Scope)new EnvironmentScope((IEnvironment)this.projectEnvironment, (IDependencyRequestor)dependencyInfo), (FileBinding)fileBinding, (IDependencyRequestor)dependencyInfo), (IEnvironment)SystemEnvironment.getInstance());
        }
        return scope;
    }

    private IProblemRequestor createProblemRequestor(String partName, IFile declaringFile, Node partAST, IPartBinding binding) {
        MarkerProblemRequestor problemRequestor = new MarkerProblemRequestor(declaringFile, partName);
        if (binding.getKind() == 20) {
            problemRequestor = new GenericTopLevelFunctionProblemRequestor((IProblemRequestor)problemRequestor, ((TopLevelFunction)partAST).isContainerContextDependent());
        }
        return problemRequestor;
    }

    private TopLevelFunctionInfo[] processTopLevelFunctions(Set topLevelFunctions, FunctionContainerScope contextScope, IFile contextFile, DependencyInfo dependencyInfo, CappedProblemRequestor cappedProblemRequestor) {
        TopLevelFunctionProcessingQueue queue = new TopLevelFunctionProcessingQueue(this.project, contextScope, dependencyInfo, cappedProblemRequestor, this.compilerOptions);
        for (IPartBinding function : topLevelFunctions) {
            queue.addPart(function);
        }
        TopLevelFunctionInfo[] functionInfos = queue.process();
        this.removeMarkersFromUnusedFunctions(contextScope.getPartBinding().getPackageName(), contextScope.getPartBinding().getName(), contextFile, dependencyInfo.getTopLevelFunctions());
        return functionInfos;
    }

    private void removeMarkersFromUnusedFunctions(String[] contextPackageName, String contextPartName, IFile contextPartFile, Set newFunctions) {
        final HashSet<TopLevelFunctionPartKey> newFunctionKeys = new HashSet<TopLevelFunctionPartKey>();
        for (IPartBinding function : newFunctions) {
            newFunctionKeys.add(new TopLevelFunctionPartKey(((AbstractProjectEnvironment)function.getEnvironment()).getProjectName(), function.getPackageName(), function.getName()));
        }
        final ArrayList unusedFunctions = new ArrayList();
        DependencyGraph dependencyGraph = DependencyGraphManager.getInstance().getDependencyGraph(this.project);
        dependencyGraph.findFunctionDependencies(contextPackageName, contextPartName, new IFunctionRequestor(){

            @Override
            public void acceptFunction(String projectName, String[] packageName, String partName) {
                TopLevelFunctionPartKey functionKey = new TopLevelFunctionPartKey(projectName, packageName, partName);
                if (!newFunctionKeys.contains(functionKey)) {
                    unusedFunctions.add(functionKey);
                }
            }
        });
        for (TopLevelFunctionPartKey functionKey : unusedFunctions) {
            Util.removeMarkersFromInvokedFunctions(contextPartName, contextPartFile.getFullPath(), functionKey.projectName, functionKey.packageName, functionKey.partName);
        }
    }

    private void validatePackageDeclaration(String[] packageName, IFile declaringFile, Node partAST, FileBinding binding, IProblemRequestor problemRequestor) {
        try {
            IPackageBinding declaringPackage = binding.getDeclaringPackage();
            if (declaringPackage != null && declaringPackage.getPackageName() != packageName) {
                if (packageName.length == 0) {
                    problemRequestor.acceptProblem((Node)((File)partAST).getPackageDeclaration(), 3049, new String[0]);
                } else if (((File)partAST).hasPackageDeclaration()) {
                    problemRequestor.acceptProblem((Node)((File)partAST).getPackageDeclaration(), 3049, new String[0]);
                } else {
                    IPath packagePath = declaringFile.getProjectRelativePath().removeFileExtension().removeLastSegments(1);
                    packagePath = packagePath.removeFirstSegments(packagePath.segmentCount() - packageName.length);
                    problemRequestor.acceptProblem(0, 0, 2, 3064, new String[]{packagePath.toString().replace('/', '.')});
                }
            } else if (((File)partAST).hasPackageDeclaration()) {
                String packageDeclName = ((File)partAST).getPackageDeclaration().getName().getCanonicalName();
                IPath packagePath = declaringFile.getProjectRelativePath().removeFileExtension().removeLastSegments(1);
                if (!packageDeclName.equals((packagePath = packagePath.removeFirstSegments(packagePath.segmentCount() - packageName.length)).toString().replace('/', ".".charAt(0)))) {
                    problemRequestor.acceptProblem((Node)((File)partAST).getPackageDeclaration(), 3049, 2, new String[0]);
                }
            }
        }
        catch (RuntimeException e) {
            problemRequestor.acceptProblem(0, 0, 2, 3000, new String[]{binding.getName()});
            EDTCoreIDEPlugin.getPlugin().log("Part Validation Failure", e);
        }
    }

    protected abstract void addDependents(String[] var1, String var2);

    protected abstract void addDependents(String[] var1);

    protected abstract void addDependents(String var1);

    public void setProcessorRequestor(IProcessorRequestor requestor) {
        this.requestor = requestor;
    }

    public void removePart(String[] packageName, String partName) {
        this.pendingUnits.remove(new AbstractProcessingQueue.ProcessingUnitKey((org.eclipse.edt.compiler.internal.core.builder.AbstractProcessingQueue)this, packageName, partName));
    }

    protected void doAddPart(String[] packageName, String caseInsensitiveInternedPartName) {
        this.addPart(packageName, this.projectInfo.getCaseSensitivePartName(packageName, caseInsensitiveInternedPartName));
    }

    private static class CompilerOptions
    implements ICompilerOptions {
        private boolean isVAGCompatible = EGLVAGCompatibilitySetting.isVAGCompatibility();
        private boolean isAliasJSFNames = EGLAliasJsfNamesSetting.isAliasJsfNames();

        private CompilerOptions() {
        }

        public boolean isVAGCompatible() {
            return this.isVAGCompatible;
        }

        public boolean isAliasJSFNames() {
            return this.isAliasJSFNames;
        }
    }

    public class TopLevelFunctionPartKey {
        private String projectName;
        private String[] packageName;
        private String partName;

        public TopLevelFunctionPartKey(String projectName, String[] packageName, String partName) {
            this.projectName = projectName;
            this.packageName = packageName;
            this.partName = partName;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TopLevelFunctionPartKey) {
                return ((TopLevelFunctionPartKey)obj).projectName.equals(this.projectName) && ((TopLevelFunctionPartKey)obj).packageName == this.packageName && ((TopLevelFunctionPartKey)obj).partName == this.partName;
            }
            return false;
        }

        public int hashCode() {
            return this.partName.hashCode();
        }
    }
}

