/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.ide.core.internal.builder.ASTManager;
import org.eclipse.edt.ide.core.internal.builder.AbstractBatchBuilder;
import org.eclipse.edt.ide.core.internal.builder.Builder;
import org.eclipse.edt.ide.core.internal.builder.DuplicatePartRequestor;
import org.eclipse.edt.ide.core.internal.builder.FileMarkerProblemRequestor;
import org.eclipse.edt.ide.core.internal.builder.MarkerSyntaxErrorRequestor;
import org.eclipse.edt.ide.core.internal.builder.SyntaxMarkerProblemRequestor;
import org.eclipse.edt.ide.core.internal.lookup.FileInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.IASTFileInfo;
import org.eclipse.edt.ide.core.internal.lookup.ResourceFileInfoCreator;
import org.eclipse.edt.ide.core.internal.utils.Util;

public class CleanBatchBuilder
extends AbstractBatchBuilder {
    protected CleanBatchBuilder(Builder builder, IBuildNotifier notifier) {
        super(builder, notifier);
    }

    @Override
    protected void addEGLFile(IFile file, String[] packageName) {
        try {
            String fileContents = Util.getFileContents(file);
            File fileAST = ASTManager.getInstance().getFileAST(file, fileContents);
            ResourceFileInfoCreator fileInfoCreator = new ResourceFileInfoCreator(this.projectInfo, packageName, file, fileAST, fileContents, new DuplicatePartRequestor(this.builder.getProject(), packageName, file));
            IASTFileInfo info = fileInfoCreator.getASTInfo();
            FileInfoManager.getInstance().saveFileInfo(this.builder.getProject(), file.getProjectRelativePath(), info);
            info.accept((IProblemRequestor)new FileMarkerProblemRequestor(file, info));
            fileAST.accept((ISyntaxErrorRequestor)new MarkerSyntaxErrorRequestor(new SyntaxMarkerProblemRequestor(file, info), fileContents));
            Set partNames = info.getPartNames();
            for (String partName : partNames) {
                this.projectInfo.partAdded(packageName, partName, info.getPartType(partName), file, info.getCaseSensitivePartName(partName));
                this.addPart(packageName, info.getCaseSensitivePartName(partName));
            }
        }
        catch (Exception e) {
            throw new BuildException("Error adding EGL File: " + file.getProjectRelativePath(), (Throwable)e);
        }
    }

    @Override
    protected void addEGLPackage(String[] packageName) {
        this.projectInfo.packageAdded(packageName);
    }
}

