/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.SystemEnvironment;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.ide.core.ICompiler;
import org.eclipse.edt.ide.core.internal.compiler.SystemEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.mof.egl.compiler.EGL2IREnvironment;
import org.eclipse.edt.mof.impl.Bootstrap;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.ObjectStore;

public class IDEEnvironment
extends EGL2IREnvironment {
    private IProject project;

    public IDEEnvironment(IProject project) {
        super((IEnvironment)new Environment());
        Bootstrap.initialize((IEnvironment)this);
        this.project = project;
    }

    public void appendEnvironment(IEnvironment env) {
        Map storesMap = env.getObjectStores();
        for (Map.Entry entry : storesMap.entrySet()) {
            String scheme = (String)entry.getKey();
            List stores = (List)entry.getValue();
            for (ObjectStore store : stores) {
                this.registerObjectStore(scheme, store);
            }
        }
        Map delegateMap = env.getLookupDelegates();
        for (Map.Entry entry : delegateMap.entrySet()) {
            this.registerLookupDelegate((String)entry.getKey(), (IEnvironment.LookupDelegate)entry.getValue());
        }
        if (env instanceof EGL2IREnvironment) {
            List list = ((EGL2IREnvironment)env).getPathRoots();
            for (File file : list) {
                if (list.contains(file)) continue;
                this.addRoot(file);
            }
        }
    }

    public void setDefaultOutputFolder(IPath path) {
    }

    public IPartBinding getCachedPartBinding(String[] packageName, String partName) {
        if (this.project != null) {
            IDEEnvironment systemEnv;
            ProjectEnvironment projEnv = ProjectEnvironmentManager.getInstance().getProjectEnvironment(this.project);
            IPartBinding binding = projEnv.getCachedPartBinding(packageName, partName);
            if (Binding.isValidBinding((IBinding)binding)) {
                return binding;
            }
            binding = this.getPartBindingFromCache(packageName, partName);
            if (Binding.isValidBinding((IBinding)binding)) {
                return binding;
            }
            ICompiler compiler = ProjectSettingsUtility.getCompiler(this.project);
            if (compiler != null && (systemEnv = SystemEnvironmentManager.getSystemEnvironment(compiler)) != null) {
                return systemEnv.getCachedPartBinding(packageName, partName);
            }
            return SystemEnvironment.getInstance().getCachedPartBinding(packageName, partName);
        }
        return super.getCachedPartBinding(packageName, partName);
    }
}

