/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.ide.core.internal.builder.Util;
import org.eclipse.edt.mof.serialization.AbstractObjectStore;
import org.eclipse.edt.mof.serialization.Deserializer;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.SerializationException;

public class IFileSystemObjectStore
extends AbstractObjectStore {
    private static final boolean DEBUG = false;
    static final String MOFBIN = ".mofbin";
    static final String MOFXML = ".mofxml";
    IPath root;
    String fileExtension;

    public IFileSystemObjectStore(IPath root, IEnvironment env) {
        super(env);
        this.root = root;
    }

    public IFileSystemObjectStore(IPath root, IEnvironment env, String storageFormat) {
        super(env, storageFormat);
        this.root = root;
        this.fileExtension = storageFormat == "XML" ? MOFXML : MOFBIN;
    }

    public IFileSystemObjectStore(IPath root, IEnvironment env, String storageFormat, String fileExtension) {
        super(env, storageFormat);
        this.root = root;
        this.fileExtension = fileExtension;
        this.supportedScheme = fileExtension.equals(".eglxml") ? "egl" : "mof";
    }

    public Deserializer createDeserializer(String typeSignature) {
        try {
            IPath path = this.root.append(String.valueOf(typeSignature.replace('.', '/')) + this.getFileExtension());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            if (file.exists()) {
                try {
                    BufferedInputStream inputStream = new BufferedInputStream(file.getContents());
                    return this.factory.createDeserializer((Object)inputStream, this.env);
                }
                catch (CoreException e) {
                    throw new BuildException("CoreException", (Throwable)e);
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public void primRemove(String key) {
    }

    public void store(String typeSignature, Object obj) {
        if (!(obj instanceof byte[])) {
            throw new IllegalArgumentException("Object not of type: byte[]");
        }
        byte[] entry = (byte[])obj;
        BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(entry));
        try {
            try {
                IFile file = this.getOutputFileForWrite(typeSignature);
                if (file.exists()) {
                    if (entry.length > 0) {
                        file.setContents((InputStream)inputStream, true, false, null);
                        if (!file.isDerived()) {
                            file.setDerived(true);
                        }
                    } else {
                        file.delete(true, null);
                    }
                } else if (entry.length > 0) {
                    file.create((InputStream)inputStream, 1, null);
                    file.setDerived(true);
                }
            }
            catch (CoreException e) {
                throw new SerializationException((Throwable)e);
            }
        }
        finally {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {
                throw new SerializationException((Throwable)e);
            }
        }
    }

    private IFile getOutputFileForWrite(String typeSignature) throws CoreException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String relativeFilePath = String.valueOf(typeSignature.replace('.', '/')) + this.getFileExtension();
        int lastSlash = relativeFilePath.lastIndexOf(47);
        if (lastSlash != -1) {
            Util.createFolder((IPath)new Path(relativeFilePath.substring(0, lastSlash)), (IContainer)workspaceRoot.getFolder(this.root));
        }
        return workspaceRoot.getFile(this.root.append(relativeFilePath));
    }

    public boolean containsKey(String key) {
        key = this.removeSchemeFromKey(key);
        IPath path = this.root.append(String.valueOf(key.replace('.', '/')) + this.getFileExtension());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        return file.exists();
    }

    public long lastModified(String key) {
        key = this.removeSchemeFromKey(key);
        IPath path = this.root.append(String.valueOf(key.replace('.', '/')) + this.getFileExtension());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        return file.getModificationStamp();
    }

    public String getFileExtension() {
        if (this.fileExtension == null) {
            this.fileExtension = this.storageFormat.equals("BINARY") ? MOFBIN : MOFXML;
        }
        return this.fileExtension;
    }
}

