/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.SystemEnvironment;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.internal.core.builder.AccumulatingProblemrRequestor;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.builder.CappedProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.FunctionContainerContextTopLevelFunctionProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.BindingCreator;
import org.eclipse.edt.compiler.internal.core.lookup.EnvironmentScope;
import org.eclipse.edt.compiler.internal.core.lookup.FileScope;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionContainerScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.lookup.SystemScope;
import org.eclipse.edt.compiler.internal.util.TopLevelFunctionInfo;
import org.eclipse.edt.ide.core.internal.builder.ASTManager;
import org.eclipse.edt.ide.core.internal.builder.ContextSpecificMarkerProblemRequestor;
import org.eclipse.edt.ide.core.internal.builder.MarkerProblemRequestor;
import org.eclipse.edt.ide.core.internal.compiler.Compiler;
import org.eclipse.edt.ide.core.internal.dependency.DependencyInfo;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfo;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfoManager;
import org.eclipse.edt.ide.core.internal.model.ClassFile;
import org.eclipse.edt.ide.core.internal.model.ClassFileElementInfo;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.partinfo.IPartOrigin;
import org.eclipse.edt.ide.core.internal.search.IFilePartInfo;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IClassFile;

public class TopLevelFunctionProcessingQueue {
    private LinkedHashMap pendingUnits = new LinkedHashMap();
    private IPartBinding functionBeingProcessed;
    private HashSet processedUnits = new HashSet();
    private List processedFunctionInfos = new ArrayList();
    private ProjectEnvironment contextProjectEnvrionment;
    private FunctionContainerScope functionContainerScope;
    private DependencyInfo dependencyInfo;
    private ProjectInfo contextProjectInfo;
    private IPartBinding containerContext;
    private CappedProblemRequestor cappedProblemRequestor;
    private ICompilerOptions compilerOptions;

    public TopLevelFunctionProcessingQueue(IProject project, FunctionContainerScope functionContainerScope, DependencyInfo dependencyInfo, CappedProblemRequestor cappedProblemRequestor, ICompilerOptions compilerOptions) {
        this.functionContainerScope = functionContainerScope;
        this.dependencyInfo = dependencyInfo;
        this.cappedProblemRequestor = cappedProblemRequestor;
        this.compilerOptions = compilerOptions;
        this.contextProjectInfo = ProjectInfoManager.getInstance().getProjectInfo(project);
        this.contextProjectEnvrionment = ProjectEnvironmentManager.getInstance().getProjectEnvironment(project);
        this.containerContext = functionContainerScope.getPartBinding();
    }

    protected void addPart(IPartBinding function) {
        if (this.functionBeingProcessed != function && !this.processedUnits.contains(new TopLevelFunctionProcessingUnitKey(function))) {
            this.pendingUnits.put(new TopLevelFunctionProcessingUnitKey(function), new TopLevelFunctionProcessingUnit(function));
        }
    }

    public TopLevelFunctionInfo[] process() {
        while (!this.pendingUnits.isEmpty()) {
            Iterator iterator = this.pendingUnits.values().iterator();
            TopLevelFunctionProcessingUnit processingUnit = (TopLevelFunctionProcessingUnit)iterator.next();
            this.process(processingUnit);
        }
        return this.processedFunctionInfos.toArray(new TopLevelFunctionInfo[this.processedFunctionInfos.size()]);
    }

    private void process(TopLevelFunctionProcessingUnit processingUnit) {
        this.pendingUnits.remove(new TopLevelFunctionProcessingUnitKey(processingUnit.function));
        this.functionBeingProcessed = processingUnit.function;
        this.compile(processingUnit);
        this.functionBeingProcessed = null;
        this.processedUnits.add(new TopLevelFunctionProcessingUnitKey(processingUnit.function));
    }

    private void compileUsingProjectEnvironment(TopLevelFunctionProcessingUnit functionUnit) {
        IProject functionProject = ((ProjectEnvironment)functionUnit.function.getEnvironment()).getProject();
        String[] functionPackageName = functionUnit.function.getPackageName();
        String functionPartName = functionUnit.function.getName();
        String[] contextPackageName = this.containerContext.getPackageName();
        String contextPartName = this.containerContext.getName();
        String contextSpecificCaseSensitiveInternedFunctionName = functionUnit.contextSpecificCaseSensitiveInternedFunctionName;
        IPartOrigin origin = ProjectInfoManager.getInstance().getProjectInfo(functionProject).getPartOrigin(functionPackageName, functionPartName);
        if (origin == null || origin.getEGLFile() == null) {
            this.compileUsingProjectEnvironmentWithEglar(functionUnit);
            return;
        }
        IFile functionDeclaringFile = origin.getEGLFile();
        if (!functionDeclaringFile.exists()) {
            throw new BuildException("Unable to compile top level function " + functionUnit.function.getPackageQualifiedName() + " : EGL source code not be found.");
        }
        TopLevelFunction functionAST = (TopLevelFunction)ASTManager.getInstance().getPartAST(functionDeclaringFile, functionPartName);
        boolean isContainerContextDependent = functionAST.isContainerContextDependent();
        FunctionContainerContextTopLevelFunctionProblemRequestor functionProbReq = new FunctionContainerContextTopLevelFunctionProblemRequestor((IProblemRequestor)new ContextSpecificMarkerProblemRequestor(functionDeclaringFile, functionPartName, contextPartName, this.contextProjectInfo.getPartOrigin(this.containerContext.getPackageName(), this.containerContext.getName()).getEGLFile().getFullPath()), isContainerContextDependent);
        this.processedFunctionInfos.add(new TopLevelFunctionInfo(functionAST, functionDeclaringFile.getFullPath().toString(), (IProblemRequestor)functionProbReq));
        IPartBinding functionBinding = new BindingCreator((IEnvironment)this.contextProjectEnvrionment, functionPackageName, contextSpecificCaseSensitiveInternedFunctionName, (Node)functionAST).getPartBinding();
        functionBinding.setEnvironment((IEnvironment)this.contextProjectEnvrionment);
        Scope scope = this.createScope(functionProject, functionPackageName, contextPackageName, contextPartName, functionDeclaringFile, isContainerContextDependent);
        IProblemRequestor saveReq = this.cappedProblemRequestor.getRequestor();
        this.cappedProblemRequestor.setRequestor((IProblemRequestor)functionProbReq);
        Compiler.getInstance().compileTopLevelFunction(functionAST, functionBinding, scope, this.containerContext, this.dependencyInfo, (IProblemRequestor)this.cappedProblemRequestor, this.compilerOptions);
        for (IPartBinding function : this.dependencyInfo.getTopLevelFunctions()) {
            this.addPart(function);
        }
        this.cappedProblemRequestor.setRequestor(saveReq);
    }

    private void compileUsingExternalProjectEnvironment(TopLevelFunctionProcessingUnit functionUnit) {
        ExternalProjectEnvironment functionExternalProjectEnvironment = (ExternalProjectEnvironment)functionUnit.function.getEnvironment();
        IProject functionProject = functionExternalProjectEnvironment.getProject().getReferencingProject();
        String[] functionPackageName = functionUnit.function.getPackageName();
        String functionPackageNameString = this.asString(functionPackageName);
        String functionPartName = functionUnit.function.getName();
        String[] contextPackageName = this.containerContext.getPackageName();
        String contextPartName = this.containerContext.getName();
        String contextSpecificCaseSensitiveInternedFunctionName = functionUnit.contextSpecificCaseSensitiveInternedFunctionName;
        IClassFile classFile = this.getClassFile(functionProject, functionPackageNameString, functionPartName);
        String functionDeclaringFileSource = null;
        try {
            functionDeclaringFileSource = classFile.getSource();
        }
        catch (EGLModelException eGLModelException) {}
        if (functionDeclaringFileSource == null || functionDeclaringFileSource.length() == 0) {
            throw new BuildException("Unable to compile top level function " + functionUnit.function.getPackageQualifiedName() + " : EGL source code not be found.");
        }
        String fileAstKey = this.getFileAstKey(classFile, functionProject, functionPackageNameString);
        File fileAST = ASTManager.getInstance().getFileAST(fileAstKey, functionDeclaringFileSource);
        TopLevelFunction functionAST = (TopLevelFunction)ASTManager.getInstance().getPartAST(fileAST, null, functionPartName);
        boolean isContainerContextDependent = functionAST.isContainerContextDependent();
        AccumulatingProblemrRequestor accumulationProblemRequestor = new AccumulatingProblemrRequestor();
        FunctionContainerContextTopLevelFunctionProblemRequestor functionProbReq = new FunctionContainerContextTopLevelFunctionProblemRequestor((IProblemRequestor)accumulationProblemRequestor, isContainerContextDependent);
        this.processedFunctionInfos.add(new TopLevelFunctionInfo(functionAST, fileAstKey, (IProblemRequestor)functionProbReq, (Object)classFile));
        IPartBinding functionBinding = new BindingCreator((IEnvironment)this.contextProjectEnvrionment, functionPackageName, contextSpecificCaseSensitiveInternedFunctionName, (Node)functionAST).getPartBinding();
        functionBinding.setEnvironment((IEnvironment)this.contextProjectEnvrionment);
        Scope scope = this.createScope(functionExternalProjectEnvironment, functionPackageName, contextPackageName, contextPartName, fileAST, fileAstKey, isContainerContextDependent);
        IProblemRequestor saveReq = this.cappedProblemRequestor.getRequestor();
        this.cappedProblemRequestor.setRequestor((IProblemRequestor)functionProbReq);
        Compiler.getInstance().compileTopLevelFunction(functionAST, functionBinding, scope, this.containerContext, this.dependencyInfo, (IProblemRequestor)this.cappedProblemRequestor, this.compilerOptions);
        if (functionProbReq.hasError()) {
            MarkerProblemRequestor contextReq = this.createContextProblemRequestor(contextPackageName, contextPartName);
            this.cappedProblemRequestor.setRequestor((IProblemRequestor)contextReq);
            this.cappedProblemRequestor.acceptProblem((Node)this.getContextAst(contextReq.file, contextPartName).getName(), 7999, new String[]{this.buildPartName(functionPackageName, functionPartName), contextPartName});
        }
        for (IPartBinding function : this.dependencyInfo.getTopLevelFunctions()) {
            this.addPart(function);
        }
        this.cappedProblemRequestor.setRequestor(saveReq);
    }

    private void compileUsingProjectEnvironmentWithEglar(TopLevelFunctionProcessingUnit functionUnit) {
        ProjectEnvironment functionProjectEnv = (ProjectEnvironment)functionUnit.function.getEnvironment();
        IProject functionProject = functionProjectEnv.getProject();
        String[] functionPackageName = functionUnit.function.getPackageName();
        String functionPackageNameString = this.asString(functionPackageName);
        String functionPartName = functionUnit.function.getName();
        String[] contextPackageName = this.containerContext.getPackageName();
        String contextPartName = this.containerContext.getName();
        String contextSpecificCaseSensitiveInternedFunctionName = functionUnit.contextSpecificCaseSensitiveInternedFunctionName;
        IClassFile classFile = this.getClassFile(functionProject, functionPackageNameString, functionPartName);
        String functionDeclaringFileSource = null;
        try {
            functionDeclaringFileSource = classFile.getSource();
        }
        catch (EGLModelException eGLModelException) {}
        if (functionDeclaringFileSource == null || functionDeclaringFileSource.length() == 0) {
            throw new BuildException("Unable to compile top level function " + functionUnit.function.getPackageQualifiedName() + " : EGL source code not be found.");
        }
        String fileAstKey = this.getFileAstKey(classFile, functionProject, functionPackageNameString);
        File fileAST = ASTManager.getInstance().getFileAST(fileAstKey, functionDeclaringFileSource);
        TopLevelFunction functionAST = (TopLevelFunction)ASTManager.getInstance().getPartAST(fileAST, null, functionPartName);
        boolean isContainerContextDependent = functionAST.isContainerContextDependent();
        AccumulatingProblemrRequestor accumulationProblemRequestor = new AccumulatingProblemrRequestor();
        FunctionContainerContextTopLevelFunctionProblemRequestor functionProbReq = new FunctionContainerContextTopLevelFunctionProblemRequestor((IProblemRequestor)accumulationProblemRequestor, isContainerContextDependent);
        this.processedFunctionInfos.add(new TopLevelFunctionInfo(functionAST, fileAstKey, (IProblemRequestor)functionProbReq, (Object)classFile));
        IPartBinding functionBinding = new BindingCreator((IEnvironment)this.contextProjectEnvrionment, functionPackageName, contextSpecificCaseSensitiveInternedFunctionName, (Node)functionAST).getPartBinding();
        functionBinding.setEnvironment((IEnvironment)this.contextProjectEnvrionment);
        Scope scope = this.createScope(functionProjectEnv, functionPackageName, contextPackageName, contextPartName, fileAST, fileAstKey, isContainerContextDependent);
        IProblemRequestor saveReq = this.cappedProblemRequestor.getRequestor();
        this.cappedProblemRequestor.setRequestor((IProblemRequestor)functionProbReq);
        Compiler.getInstance().compileTopLevelFunction(functionAST, functionBinding, scope, this.containerContext, this.dependencyInfo, (IProblemRequestor)this.cappedProblemRequestor, this.compilerOptions);
        if (functionProbReq.hasError()) {
            MarkerProblemRequestor contextReq = this.createContextProblemRequestor(contextPackageName, contextPartName);
            this.cappedProblemRequestor.setRequestor((IProblemRequestor)contextReq);
            this.cappedProblemRequestor.acceptProblem((Node)this.getContextAst(contextReq.file, contextPartName).getName(), 7999, new String[]{this.buildPartName(functionPackageName, functionPartName), contextPartName});
        }
        for (IPartBinding function : this.dependencyInfo.getTopLevelFunctions()) {
            this.addPart(function);
        }
        this.cappedProblemRequestor.setRequestor(saveReq);
    }

    private void compile(TopLevelFunctionProcessingUnit functionUnit) {
        if (functionUnit.function.getEnvironment() instanceof ProjectEnvironment) {
            this.compileUsingProjectEnvironment(functionUnit);
            return;
        }
        if (functionUnit.function.getEnvironment() instanceof ExternalProjectEnvironment) {
            this.compileUsingExternalProjectEnvironment(functionUnit);
            return;
        }
        throw new BuildException("Unable to compile top level function " + functionUnit.function.getPackageQualifiedName() + " : EGL source code not be found.");
    }

    private Scope createScope(IProject functionProject, String[] functionPackageName, String[] contextPackageName, String contextPartName, IFile functionDeclaringFile, boolean isContainerContextDependent) {
        FileScope fileScope;
        String fileName;
        if (isContainerContextDependent) {
            fileName = Util.getFilePartName(this.contextProjectInfo.getPartOrigin(contextPackageName, contextPartName).getEGLFile());
            IPartBinding fileBinding = this.contextProjectEnvrionment.getPartBinding(contextPackageName, fileName);
            fileScope = new FileScope((Scope)new EnvironmentScope((IEnvironment)this.contextProjectEnvrionment, (IDependencyRequestor)this.dependencyInfo), (FileBinding)fileBinding, (IDependencyRequestor)this.dependencyInfo);
        } else {
            fileName = Util.getFilePartName(functionDeclaringFile);
            ProjectEnvironment functionProjectEnvironment = ProjectEnvironmentManager.getInstance().getProjectEnvironment(functionProject);
            IPartBinding fileBinding = functionProjectEnvironment.getPartBinding(functionPackageName, fileName);
            fileScope = new FileScope((Scope)new EnvironmentScope((IEnvironment)functionProjectEnvironment, (IDependencyRequestor)this.dependencyInfo), (FileBinding)fileBinding, (IDependencyRequestor)this.dependencyInfo);
        }
        FunctionContainerScope scope = new FunctionContainerScope((Scope)new SystemScope((Scope)fileScope, (IEnvironment)SystemEnvironment.getInstance()), this.functionContainerScope);
        return scope;
    }

    private Scope createScope(ExternalProjectEnvironment env, String[] functionPackageName, String[] contextPackageName, String contextPartName, File fileAST, String fileNameKey, boolean isContainerContextDependent) {
        FileScope fileScope;
        if (isContainerContextDependent) {
            String fileName = Util.getFilePartName(this.contextProjectInfo.getPartOrigin(contextPackageName, contextPartName).getEGLFile());
            IPartBinding fileBinding = this.contextProjectEnvrionment.getPartBinding(contextPackageName, fileName);
            fileScope = new FileScope((Scope)new EnvironmentScope((IEnvironment)this.contextProjectEnvrionment, (IDependencyRequestor)this.dependencyInfo), (FileBinding)fileBinding, (IDependencyRequestor)this.dependencyInfo);
        } else {
            FileBinding fileBinding = env.getDeclaringProjectBuildPathEntry().getFileBinding(functionPackageName, fileNameKey, fileAST);
            fileScope = new FileScope((Scope)new EnvironmentScope((IEnvironment)env, (IDependencyRequestor)this.dependencyInfo), fileBinding, (IDependencyRequestor)this.dependencyInfo);
        }
        FunctionContainerScope scope = new FunctionContainerScope((Scope)new SystemScope((Scope)fileScope, (IEnvironment)SystemEnvironment.getInstance()), this.functionContainerScope);
        return scope;
    }

    private Scope createScope(ProjectEnvironment env, String[] functionPackageName, String[] contextPackageName, String contextPartName, File fileAST, String fileNameKey, boolean isContainerContextDependent) {
        FileScope fileScope;
        if (isContainerContextDependent) {
            String fileName = Util.getFilePartName(this.contextProjectInfo.getPartOrigin(contextPackageName, contextPartName).getEGLFile());
            IPartBinding fileBinding = this.contextProjectEnvrionment.getPartBinding(contextPackageName, fileName);
            fileScope = new FileScope((Scope)new EnvironmentScope((IEnvironment)this.contextProjectEnvrionment, (IDependencyRequestor)this.dependencyInfo), (FileBinding)fileBinding, (IDependencyRequestor)this.dependencyInfo);
        } else {
            FileBinding fileBinding = env.getDeclaringProjectBuildPathEntry().getFileBinding(functionPackageName, fileNameKey, fileAST);
            fileScope = new FileScope((Scope)new EnvironmentScope((IEnvironment)env, (IDependencyRequestor)this.dependencyInfo), fileBinding, (IDependencyRequestor)this.dependencyInfo);
        }
        FunctionContainerScope scope = new FunctionContainerScope((Scope)new SystemScope((Scope)fileScope, (IEnvironment)SystemEnvironment.getInstance()), this.functionContainerScope);
        return scope;
    }

    private String getFileAstKey(IClassFile classFile, IProject project, String packageName) {
        IFile file;
        if (classFile instanceof ClassFile && (file = ((ClassFile)classFile).getFileInSourceFolder()) != null) {
            return file.getFullPath().toString();
        }
        if (classFile instanceof EGLElement) {
            try {
                Object info = ((EGLElement)((Object)classFile)).getElementInfo();
                if (info instanceof ClassFileElementInfo) {
                    IPath path = classFile.getPath();
                    return String.valueOf(path.toString()) + ":" + project.getName() + "/" + packageName + "/" + ((ClassFileElementInfo)info).getEglFileName();
                }
            }
            catch (EGLModelException eGLModelException) {}
        }
        return classFile.toString();
    }

    private IClassFile getClassFile(IProject project, String packageName, String partName) {
        String classFileName = String.valueOf(partName.toLowerCase()) + ".ir";
        return IFilePartInfo.getClassFile((IResource)project, packageName, 1, classFileName);
    }

    private String asString(String[] arr) {
        if (arr == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < arr.length) {
            if (i > 0) {
                buffer.append(".");
            }
            buffer.append(arr[i]);
            ++i;
        }
        return buffer.toString();
    }

    private MarkerProblemRequestor createContextProblemRequestor(String[] contextPackageName, String contextPartName) {
        IFile file = this.contextProjectInfo.getPartOrigin(contextPackageName, contextPartName).getEGLFile();
        return new MarkerProblemRequestor(file, contextPartName, false);
    }

    private Part getContextAst(IFile containerFile, String contextPartName) {
        return ASTManager.getInstance().getPartAST(containerFile, contextPartName);
    }

    private String buildPartName(String[] pkg, String part) {
        if (pkg == null || pkg.length == 0) {
            return part;
        }
        return String.valueOf(this.asString(pkg)) + "." + part;
    }

    private class TopLevelFunctionProcessingUnit {
        IPartBinding function;
        String contextSpecificCaseSensitiveInternedFunctionName;

        TopLevelFunctionProcessingUnit(IPartBinding function) {
            this.function = function;
            this.contextSpecificCaseSensitiveInternedFunctionName = this.createContextSpecificFunctionName();
        }

        private String createContextSpecificFunctionName() {
            StringBuffer contextSpecificFunctionNameBuffer = new StringBuffer();
            contextSpecificFunctionNameBuffer.append(String.valueOf(TopLevelFunctionProcessingQueue.this.containerContext.getName()) + "$");
            int i = 0;
            while (i < this.function.getPackageName().length) {
                contextSpecificFunctionNameBuffer.append(String.valueOf(this.function.getPackageName()[i]) + ".");
                ++i;
            }
            contextSpecificFunctionNameBuffer.append(this.function.getName());
            return contextSpecificFunctionNameBuffer.toString().intern();
        }
    }

    public class TopLevelFunctionProcessingUnitKey {
        IPartBinding function;

        public TopLevelFunctionProcessingUnitKey(IPartBinding function) {
            this.function = function;
        }

        public boolean equals(Object otherObject) {
            if (this == otherObject) {
                return true;
            }
            if (otherObject instanceof TopLevelFunctionProcessingUnitKey) {
                TopLevelFunctionProcessingUnitKey otherPUKey = (TopLevelFunctionProcessingUnitKey)otherObject;
                return otherPUKey.function == this.function;
            }
            return false;
        }

        public int hashCode() {
            return this.function.getName().hashCode();
        }
    }
}

