/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.compiler;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.compiler.ISystemPackageBuildPathEntry;
import org.eclipse.edt.compiler.ISystemPackageBuildPathEntryFactory;
import org.eclipse.edt.compiler.ISystemPartBindingLoadedRequestor;
import org.eclipse.edt.compiler.binding.EnumerationTypeBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.LibraryBinding;
import org.eclipse.edt.compiler.binding.PackageBinding;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeManager;
import org.eclipse.edt.compiler.internal.core.lookup.EnumerationManager;
import org.eclipse.edt.compiler.internal.core.lookup.IBindingEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.System.SystemLibraryManager;

public class ContributedSystemEnvironment
implements IBindingEnvironment {
    private PackageBinding rootPackageBinding = new PackageBinding(new String[0], null, (IEnvironment)this);
    private ISystemPackageBuildPathEntry[] sysPackages = new ISystemPackageBuildPathEntry[0];
    private boolean systemPackagesInitialized;
    private Set implicitlyUsedEnumerationNames = Collections.EMPTY_SET;
    private Map unqualifiedSystemParts = Collections.EMPTY_MAP;
    private Map systemPackages = Collections.EMPTY_MAP;

    public void initializeSystemPackages(File libfolder, ISystemPackageBuildPathEntryFactory factory) {
        if (!this.systemPackagesInitialized) {
            if (libfolder.exists() && libfolder.isDirectory()) {
                File[] files = libfolder.listFiles();
                this.sysPackages = factory.createEntries((IEnvironment)this, files, new ISystemPartBindingLoadedRequestor(){

                    public void partBindingLoaded(IPartBinding part) {
                        ContributedSystemEnvironment.this.addSystemEntry(part);
                    }
                });
            }
            this.systemPackagesInitialized = true;
        }
    }

    public IPartBinding getPartBinding(String[] packageName, String partName) {
        Map map;
        IPartBinding result = null;
        int i = 0;
        while (i < this.sysPackages.length) {
            ISystemPackageBuildPathEntry entry = this.sysPackages[i];
            result = entry.getPartBinding(packageName, partName);
            if (result != null) {
                return result;
            }
            ++i;
        }
        if (packageName == null) {
            result = (IPartBinding)this.getUnqualifiedSystemParts().get(partName);
        }
        if ((map = (Map)this.getSystemPackages().get(packageName)) != null) {
            result = (IPartBinding)map.get(partName);
        }
        return result == null ? IBinding.NOT_FOUND_BINDING : result;
    }

    public IPartBinding getCachedPartBinding(String[] packageName, String partName) {
        IPartBinding result = null;
        Map map = (Map)this.getSystemPackages().get(packageName);
        if (map != null) {
            result = (IPartBinding)map.get(partName);
        }
        return result == null ? IBinding.NOT_FOUND_BINDING : result;
    }

    public IPartBinding getNewPartBinding(String[] packageName, String partName, int kind) {
        return null;
    }

    public boolean hasPackage(String[] packageName) {
        int i = 0;
        while (i < this.sysPackages.length) {
            ISystemPackageBuildPathEntry entry = this.sysPackages[i];
            if (entry.hasPackage(packageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IPackageBinding getRootPackage() {
        return this.rootPackageBinding;
    }

    public void addPartBindingToCache(IPartBinding partBinding) {
        this.addSystemEntry(partBinding);
    }

    private Map getSystemPackages() {
        if (this.systemPackages == Collections.EMPTY_MAP) {
            this.initializeMaps();
        }
        return this.systemPackages;
    }

    private Set getImplicitlyUsedEnumerationNames() {
        if (this.implicitlyUsedEnumerationNames == Collections.EMPTY_SET) {
            this.initializeMaps();
        }
        return this.implicitlyUsedEnumerationNames;
    }

    private Map getUnqualifiedSystemParts() {
        if (this.unqualifiedSystemParts == Collections.EMPTY_MAP) {
            this.initializeMaps();
        }
        return this.unqualifiedSystemParts;
    }

    public void addSystemEntry(IPartBinding part) {
        this.getUnqualifiedSystemParts().put(part.getName(), part);
        Map map = this.getPackageParts(part.getPackageName());
        map.put(part.getName(), part);
        if (part.getKind() == 11) {
            SystemLibraryManager.getInstance().addSystemLibrary((LibraryBinding)part);
        } else if (part.getKind() == 19) {
            if (this.enumerationIsImplicitlyUsed(part)) {
                EnumerationManager.getInstance().addResolvableDataBindings((EnumerationTypeBinding)part);
            }
        } else if (part.getKind() == 7) {
            AnnotationTypeManager.getInstance().addSystemPackageRecord((FlexibleRecordBinding)part);
        }
    }

    private boolean enumerationIsImplicitlyUsed(IPartBinding part) {
        return this.getImplicitlyUsedEnumerationNames().contains(part.getName());
    }

    private Map getPackageParts(String[] packageName) {
        HashMap map = (HashMap)this.systemPackages.get(packageName);
        if (map == null) {
            map = new HashMap();
            this.systemPackages.put(packageName, map);
        }
        return map;
    }

    private void initializeMaps() {
        this.systemPackages = new HashMap();
        this.unqualifiedSystemParts = new HashMap();
        this.implicitlyUsedEnumerationNames = new HashSet();
    }
}

