/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.compiler;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.compiler.ISystemPackageBuildPathEntryFactory;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.compiler.internal.core.builder.NullBuildNotifier;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.sdk.compile.IProcessor;
import org.eclipse.edt.compiler.internal.sdk.compile.SourcePathEntry;
import org.eclipse.edt.ide.core.ICompiler;
import org.eclipse.edt.ide.core.internal.builder.IDEEnvironment;
import org.eclipse.edt.ide.core.internal.compiler.ContributedSystemEnvironment;
import org.eclipse.edt.mof.egl.compiler.EGL2IREnvironment;
import org.eclipse.edt.mof.egl.compiler.Processor;
import org.eclipse.edt.mof.egl.compiler.SystemPackageBuildPathEntryFactory;
import org.eclipse.edt.mof.serialization.Environment;

public class SystemEnvironmentManager {
    private static Map<ICompiler, IDEEnvironment> storeMap = new HashMap<ICompiler, IDEEnvironment>();

    public static IDEEnvironment getSystemEnvironment(ICompiler compiler) {
        IDEEnvironment env;
        if (storeMap.containsKey(compiler)) {
            return storeMap.get(compiler);
        }
        File root = compiler.getSystemEnvironmentRoot();
        if (root == null || !root.exists()) {
            env = null;
        } else {
            Processor processor = new Processor((IBuildNotifier)NullBuildNotifier.getInstance(), new ICompilerOptions(){

                public boolean isVAGCompatible() {
                    return true;
                }

                public boolean isAliasJSFNames() {
                    return false;
                }
            }, null);
            env = new IDEEnvironment(null);
            env.appendEnvironment((org.eclipse.edt.mof.serialization.IEnvironment)Environment.INSTANCE);
            processor.setEnvironment((EGL2IREnvironment)env);
            SourcePathEntry.getInstance().setDeclaringEnvironment((IEnvironment)env);
            SourcePathEntry.getInstance().setProcessor((IProcessor)processor);
            ContributedSystemEnvironment systemEnv = new ContributedSystemEnvironment();
            systemEnv.initializeSystemPackages(root, (ISystemPackageBuildPathEntryFactory)new SystemPackageBuildPathEntryFactory((org.eclipse.edt.mof.serialization.IEnvironment)env, env.getConverter()));
        }
        storeMap.put(compiler, env);
        return env;
    }
}

