/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.compiler.workingcopy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.FunctionContainerBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.TopLevelFunctionBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IPartASTRequestor;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectInfoManager;
import org.eclipse.edt.ide.core.internal.partinfo.IPartOrigin;
import org.eclipse.edt.ide.core.search.ICompiledFileUnit;

public class CompiledFileUnit
implements ICompiledFileUnit,
IPartASTRequestor {
    File fileAST = null;
    FileBinding fileBinding = null;
    ArrayList boundPartList = new ArrayList();
    HashMap fileASTs = new HashMap();
    ArrayList asts = new ArrayList();
    HashMap referenceFiles = new HashMap();
    HashMap referencedParts = new HashMap();

    @Override
    public File getFile() {
        return this.fileAST;
    }

    @Override
    public Node[] getAllParts() {
        return this.referencedParts.keySet().toArray(new Node[this.referencedParts.size()]);
    }

    @Override
    public IFile getContainingFile(Node part) {
        IPartBinding binding;
        Part myPart;
        IFile retVal = null;
        if (this.referencedParts.containsKey(part)) {
            retVal = (IFile)this.referencedParts.get(part);
        }
        if (retVal == null && (myPart = this.getPart(part)) != null && (binding = (IPartBinding)myPart.getName().resolveBinding()) != null && binding.getEnvironment() instanceof WorkingCopyProjectEnvironment) {
            WorkingCopyProjectEnvironment env = (WorkingCopyProjectEnvironment)binding.getEnvironment();
            IProject project = env.getProject();
            IPartOrigin origin = WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project).getPartOrigin(binding.getPackageName(), binding.getName());
            if (origin != null) {
                retVal = origin.getEGLFile();
            }
        }
        return retVal;
    }

    private Part getPart(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Part) {
            return (Part)node;
        }
        return this.getPart(node.getParent());
    }

    @Override
    public HashMap getReferencedFiles() {
        return this.referenceFiles;
    }

    @Override
    public FileBinding getFileBinding() {
        return this.fileBinding;
    }

    @Override
    public List getFileParts() {
        return this.boundPartList;
    }

    public void setFileAST(File fileAST) {
        this.fileAST = fileAST;
    }

    public void setFileBinding(FileBinding fileBinding) {
        this.fileBinding = fileBinding;
    }

    public void addBoundPart(IFile file, Part part) {
        this.boundPartList.add(part);
    }

    @Override
    public Node getPartAST(IBinding partBinding) {
        if (partBinding != null && partBinding != IBinding.NOT_FOUND_BINDING) {
            Node part = (Node)this.fileASTs.get(partBinding);
            return part;
        }
        return null;
    }

    @Override
    public Node getPartInContextAST(FunctionContainerBinding functionContainerBinding, TopLevelFunctionBinding functionBinding) {
        for (Object nextKey : this.fileASTs.keySet()) {
            String nextKeyName;
            if (!(nextKey instanceof TopLevelFunctionBinding) || !(nextKeyName = ((IBinding)nextKey).getName().toLowerCase()).startsWith(String.valueOf(functionContainerBinding.getName().toLowerCase()) + "$") || !nextKeyName.endsWith(functionBinding.getPackageQualifiedName().toLowerCase())) continue;
            return (Node)this.fileASTs.get(nextKey);
        }
        return null;
    }

    @Override
    public void addPartAST(IFile file, Node part) {
        this.asts.add(part);
        this.referenceFiles.put(file, file);
        this.referencedParts.put(part, file);
    }

    public void indexASTs() {
        int i = 0;
        while (i < this.asts.size()) {
            NestedFunction function;
            IBinding binding;
            Node node = (Node)this.asts.get(i);
            if (node instanceof Part) {
                Part part = (Part)node;
                binding = part.getName().resolveBinding();
                if (binding != null && binding != IBinding.NOT_FOUND_BINDING) {
                    if (binding.isTypeBinding() && ((ITypeBinding)binding).isPartBinding()) {
                        this.fileASTs.put(binding, part);
                    } else if (binding.isFunctionBinding()) {
                        this.fileASTs.put(binding, part);
                    }
                }
            } else if (node instanceof NestedFunction && (binding = (function = (NestedFunction)node).getName().resolveBinding()) != null && binding != IBinding.NOT_FOUND_BINDING) {
                this.fileASTs.put(binding, function);
            }
            ++i;
        }
    }
}

