/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.compiler.workingcopy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.SystemEnvironment;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.internal.core.builder.AccumulatingProblemrRequestor;
import org.eclipse.edt.compiler.internal.core.builder.FunctionContainerContextTopLevelFunctionProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.NullProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.Problem;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.BindingCreator;
import org.eclipse.edt.compiler.internal.core.lookup.EnvironmentScope;
import org.eclipse.edt.compiler.internal.core.lookup.FileScope;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionContainerScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.lookup.SystemScope;
import org.eclipse.edt.compiler.internal.util.TopLevelFunctionInfo;
import org.eclipse.edt.ide.core.internal.compiler.Binder;
import org.eclipse.edt.ide.core.internal.compiler.Compiler;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IProblemRequestorFactory;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyASTManager;
import org.eclipse.edt.ide.core.internal.dependency.AbstractDependencyInfo;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectInfo;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectInfoManager;
import org.eclipse.edt.ide.core.internal.model.ClassFileElementInfo;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.partinfo.IPartOrigin;
import org.eclipse.edt.ide.core.internal.search.IFilePartInfo;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IClassFile;

public class WorkingCopyTopLevelFunctionProcessingQueue {
    private LinkedHashMap pendingUnits = new LinkedHashMap();
    private IPartBinding functionBeingProcessed;
    private HashSet processedUnits = new HashSet();
    private ArrayList topLevelFunctionInfos = new ArrayList();
    private WorkingCopyProjectEnvironment contextProjectEnvrionment;
    private FunctionContainerScope functionContainerScope;
    private AbstractDependencyInfo dependencyInfo;
    private WorkingCopyProjectInfo contextProjectInfo;
    private IPartBinding containerContext;
    private ICompilerOptions compilerOptions;
    private IProblemRequestorFactory problemRequestorFactory;

    public WorkingCopyTopLevelFunctionProcessingQueue(IProject project, FunctionContainerScope functionContainerScope, AbstractDependencyInfo dependencyInfo, ICompilerOptions compilerOptions, IProblemRequestorFactory problemRequestorFactory) {
        this.functionContainerScope = functionContainerScope;
        this.dependencyInfo = dependencyInfo;
        this.compilerOptions = compilerOptions;
        this.problemRequestorFactory = problemRequestorFactory;
        this.contextProjectInfo = WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project);
        this.contextProjectEnvrionment = WorkingCopyProjectEnvironmentManager.getInstance().getProjectEnvironment(project);
        this.containerContext = functionContainerScope.getPartBinding();
    }

    protected void addPart(IPartBinding function) {
        if (this.functionBeingProcessed != function && !this.processedUnits.contains(new WorkingCopyTopLevelFunctionProcessingUnitKey(function))) {
            this.pendingUnits.put(new WorkingCopyTopLevelFunctionProcessingUnitKey(function), new WorkingCopyTopLevelFunctionProcessingUnit(function));
        }
    }

    public void process() {
        while (!this.pendingUnits.isEmpty()) {
            Iterator iterator = this.pendingUnits.values().iterator();
            WorkingCopyTopLevelFunctionProcessingUnit processingUnit = (WorkingCopyTopLevelFunctionProcessingUnit)iterator.next();
            this.process(processingUnit);
        }
    }

    public TopLevelFunctionInfo[] getTopLevelFunctionInfos() {
        return this.topLevelFunctionInfos.toArray(new TopLevelFunctionInfo[this.topLevelFunctionInfos.size()]);
    }

    private void process(WorkingCopyTopLevelFunctionProcessingUnit processingUnit) {
        this.pendingUnits.remove(new WorkingCopyTopLevelFunctionProcessingUnitKey(processingUnit.function));
        this.functionBeingProcessed = processingUnit.function;
        this.compile(processingUnit);
        this.functionBeingProcessed = null;
        this.processedUnits.add(new WorkingCopyTopLevelFunctionProcessingUnitKey(processingUnit.function));
    }

    private void compile(WorkingCopyTopLevelFunctionProcessingUnit functionUnit) {
        if (functionUnit.function.getEnvironment() instanceof WorkingCopyProjectEnvironment) {
            this.compileUsingProjectEnvironment(functionUnit);
            return;
        }
        if (functionUnit.function.getEnvironment() instanceof ExternalProjectEnvironment) {
            this.compileUsingExternalProjectEnvironment(functionUnit);
            return;
        }
    }

    private void compileUsingExternalProjectEnvironment(WorkingCopyTopLevelFunctionProcessingUnit functionUnit) {
        IProblemRequestor problemRequestor;
        ExternalProjectEnvironment functionExternalProjectEnvironment = (ExternalProjectEnvironment)functionUnit.function.getEnvironment();
        IProject functionProject = functionExternalProjectEnvironment.getProject().getReferencingProject();
        String[] functionPackageName = functionUnit.function.getPackageName();
        String functionPackageNameString = this.asString(functionPackageName);
        String functionPartName = functionUnit.function.getName();
        String[] contextPackageName = this.containerContext.getPackageName();
        String contextPartName = this.containerContext.getName();
        String contextSpecificCaseSensitiveInternedFunctionName = functionUnit.contextSpecificCaseSensitiveInternedFunctionName;
        IClassFile classFile = this.getClassFile(functionProject, functionPackageNameString, functionPartName);
        String functionDeclaringFileSource = null;
        try {
            functionDeclaringFileSource = classFile.getSource();
        }
        catch (EGLModelException eGLModelException) {}
        String fileAstKey = this.getFileAstKey(classFile, functionProject, functionPackageNameString);
        File fileAST = WorkingCopyASTManager.getInstance().getFileAST(fileAstKey, functionDeclaringFileSource);
        TopLevelFunction functionAST = (TopLevelFunction)WorkingCopyASTManager.getInstance().getPartAST(fileAST, null, functionPartName);
        boolean isContainerContextDependent = functionAST.isContainerContextDependent();
        AccumulatingProblemrRequestor accumulationProblemRequestor = new AccumulatingProblemrRequestor();
        FunctionContainerContextTopLevelFunctionProblemRequestor functionProbReq = new FunctionContainerContextTopLevelFunctionProblemRequestor((IProblemRequestor)accumulationProblemRequestor, isContainerContextDependent);
        this.topLevelFunctionInfos.add(new TopLevelFunctionInfo(functionAST, fileAstKey, (IProblemRequestor)functionProbReq, (Object)classFile));
        IPartBinding functionBinding = new BindingCreator((IEnvironment)this.contextProjectEnvrionment, functionPackageName, contextSpecificCaseSensitiveInternedFunctionName, (Node)functionAST).getPartBinding();
        functionBinding.setEnvironment((IEnvironment)this.contextProjectEnvrionment);
        Scope scope = this.createScope(functionExternalProjectEnvironment, functionPackageName, contextPackageName, contextPartName, fileAST, fileAstKey, isContainerContextDependent);
        IFile file = this.contextProjectInfo.getPartOrigin(contextPackageName, contextPartName).getEGLFile();
        IProblemRequestor contextReq = this.problemRequestorFactory.getFileProblemRequestor(file);
        if (contextReq != null && contextReq != NullProblemRequestor.getInstance()) {
            Compiler.getInstance().compilePart((Node)functionAST, functionBinding, scope, this.dependencyInfo, (IProblemRequestor)functionProbReq, this.compilerOptions);
            if (functionProbReq.hasError()) {
                contextReq.acceptProblem((Node)this.getContextAst(file, contextPartName).getName(), 7999, new String[]{this.buildPartName(functionPackageName, functionPartName), contextPartName});
            }
        } else {
            Binder.getInstance().bindPart((Node)functionAST, functionBinding, scope, this.dependencyInfo, (IProblemRequestor)functionProbReq, this.compilerOptions);
        }
        if ((problemRequestor = this.problemRequestorFactory.getContainerContextTopLevelProblemRequestor(null, functionPartName, contextPartName, this.contextProjectInfo.getPartOrigin(this.containerContext.getPackageName(), this.containerContext.getName()).getEGLFile().getFullPath(), isContainerContextDependent)) != null && problemRequestor != NullProblemRequestor.getInstance()) {
            for (Problem prob : accumulationProblemRequestor.getProblems()) {
                problemRequestor.acceptProblem(prob.getStartOffset(), prob.getEndOffset(), prob.getSeverity(), prob.getProblemKind(), prob.getInserts());
            }
        }
        for (IPartBinding function : this.dependencyInfo.getTopLevelFunctions()) {
            this.addPart(function);
        }
    }

    private void compileUsingProjectEnvironmentWithEglar(WorkingCopyTopLevelFunctionProcessingUnit functionUnit) {
        IProblemRequestor problemRequestor;
        WorkingCopyProjectEnvironment functionProjectEnv = (WorkingCopyProjectEnvironment)functionUnit.function.getEnvironment();
        IProject functionProject = functionProjectEnv.getProject();
        String[] functionPackageName = functionUnit.function.getPackageName();
        String functionPackageNameString = this.asString(functionPackageName);
        String functionPartName = functionUnit.function.getName();
        String[] contextPackageName = this.containerContext.getPackageName();
        String contextPartName = this.containerContext.getName();
        String contextSpecificCaseSensitiveInternedFunctionName = functionUnit.contextSpecificCaseSensitiveInternedFunctionName;
        IClassFile classFile = this.getClassFile(functionProject, functionPackageNameString, functionPartName);
        String functionDeclaringFileSource = null;
        try {
            functionDeclaringFileSource = classFile.getSource();
        }
        catch (EGLModelException eGLModelException) {}
        String fileAstKey = this.getFileAstKey(classFile, functionProject, functionPackageNameString);
        File fileAST = WorkingCopyASTManager.getInstance().getFileAST(fileAstKey, functionDeclaringFileSource);
        TopLevelFunction functionAST = (TopLevelFunction)WorkingCopyASTManager.getInstance().getPartAST(fileAST, null, functionPartName);
        boolean isContainerContextDependent = functionAST.isContainerContextDependent();
        AccumulatingProblemrRequestor accumulationProblemRequestor = new AccumulatingProblemrRequestor();
        FunctionContainerContextTopLevelFunctionProblemRequestor functionProbReq = new FunctionContainerContextTopLevelFunctionProblemRequestor((IProblemRequestor)accumulationProblemRequestor, isContainerContextDependent);
        this.topLevelFunctionInfos.add(new TopLevelFunctionInfo(functionAST, fileAstKey, (IProblemRequestor)functionProbReq, (Object)classFile));
        IPartBinding functionBinding = new BindingCreator((IEnvironment)this.contextProjectEnvrionment, functionPackageName, contextSpecificCaseSensitiveInternedFunctionName, (Node)functionAST).getPartBinding();
        functionBinding.setEnvironment((IEnvironment)this.contextProjectEnvrionment);
        Scope scope = this.createScope(functionProjectEnv, functionPackageName, contextPackageName, contextPartName, fileAST, fileAstKey, isContainerContextDependent);
        IFile file = this.contextProjectInfo.getPartOrigin(contextPackageName, contextPartName).getEGLFile();
        IProblemRequestor contextReq = this.problemRequestorFactory.getFileProblemRequestor(file);
        if (contextReq != null && contextReq != NullProblemRequestor.getInstance()) {
            Compiler.getInstance().compilePart((Node)functionAST, functionBinding, scope, this.dependencyInfo, (IProblemRequestor)functionProbReq, this.compilerOptions);
            if (functionProbReq.hasError()) {
                contextReq.acceptProblem((Node)this.getContextAst(file, contextPartName).getName(), 7999, new String[]{this.buildPartName(functionPackageName, functionPartName), contextPartName});
            }
        } else {
            Binder.getInstance().bindPart((Node)functionAST, functionBinding, scope, this.dependencyInfo, (IProblemRequestor)functionProbReq, this.compilerOptions);
        }
        if ((problemRequestor = this.problemRequestorFactory.getContainerContextTopLevelProblemRequestor(null, functionPartName, contextPartName, this.contextProjectInfo.getPartOrigin(this.containerContext.getPackageName(), this.containerContext.getName()).getEGLFile().getFullPath(), isContainerContextDependent)) != null && problemRequestor != NullProblemRequestor.getInstance()) {
            for (Problem prob : accumulationProblemRequestor.getProblems()) {
                problemRequestor.acceptProblem(prob.getStartOffset(), prob.getEndOffset(), prob.getSeverity(), prob.getProblemKind(), prob.getInserts());
            }
        }
        for (IPartBinding function : this.dependencyInfo.getTopLevelFunctions()) {
            this.addPart(function);
        }
    }

    private void compileUsingProjectEnvironment(WorkingCopyTopLevelFunctionProcessingUnit functionUnit) {
        IProject functionProject = ((WorkingCopyProjectEnvironment)functionUnit.function.getEnvironment()).getProject();
        String[] functionPackageName = functionUnit.function.getPackageName();
        String functionPartName = functionUnit.function.getName();
        String[] contextPackageName = this.containerContext.getPackageName();
        String contextPartName = this.containerContext.getName();
        String contextSpecificCaseSensitiveInternedFunctionName = functionUnit.contextSpecificCaseSensitiveInternedFunctionName;
        IPartOrigin origin = WorkingCopyProjectInfoManager.getInstance().getProjectInfo(functionProject).getPartOrigin(functionPackageName, functionPartName);
        if (origin == null || origin.getEGLFile() == null) {
            this.compileUsingProjectEnvironmentWithEglar(functionUnit);
            return;
        }
        IFile functionDeclaringFile = origin.getEGLFile();
        TopLevelFunction functionAST = (TopLevelFunction)WorkingCopyASTManager.getInstance().getPartAST(functionDeclaringFile, functionPartName);
        boolean isContainerContextDependent = functionAST.isContainerContextDependent();
        IProblemRequestor problemRequestor = this.problemRequestorFactory.getContainerContextTopLevelProblemRequestor(functionDeclaringFile, functionPartName, contextPartName, this.contextProjectInfo.getPartOrigin(this.containerContext.getPackageName(), this.containerContext.getName()).getEGLFile().getFullPath(), isContainerContextDependent);
        this.topLevelFunctionInfos.add(new TopLevelFunctionInfo(functionAST, functionDeclaringFile.getFullPath().toString(), problemRequestor));
        IPartBinding functionBinding = new BindingCreator((IEnvironment)this.contextProjectEnvrionment, functionPackageName, contextSpecificCaseSensitiveInternedFunctionName, (Node)functionAST).getPartBinding();
        functionBinding.setEnvironment((IEnvironment)this.contextProjectEnvrionment);
        Scope scope = this.createScope(functionProject, functionPackageName, contextPackageName, contextPartName, functionDeclaringFile, isContainerContextDependent);
        if (problemRequestor != NullProblemRequestor.getInstance()) {
            Compiler.getInstance().compilePart((Node)functionAST, functionBinding, scope, this.dependencyInfo, problemRequestor, this.compilerOptions);
        } else {
            Binder.getInstance().bindPart((Node)functionAST, functionBinding, scope, this.dependencyInfo, problemRequestor, this.compilerOptions);
        }
        for (IPartBinding function : this.dependencyInfo.getTopLevelFunctions()) {
            this.addPart(function);
        }
    }

    private Scope createScope(WorkingCopyProjectEnvironment env, String[] functionPackageName, String[] contextPackageName, String contextPartName, File fileAST, String fileNameKey, boolean isContainerContextDependent) {
        FileScope fileScope;
        if (isContainerContextDependent) {
            String fileName = Util.getFilePartName(this.contextProjectInfo.getPartOrigin(contextPackageName, contextPartName).getEGLFile());
            IPartBinding fileBinding = this.contextProjectEnvrionment.getPartBinding(contextPackageName, fileName);
            fileScope = new FileScope((Scope)new EnvironmentScope((IEnvironment)this.contextProjectEnvrionment, (IDependencyRequestor)this.dependencyInfo), (FileBinding)fileBinding, (IDependencyRequestor)this.dependencyInfo);
        } else {
            FileBinding fileBinding = env.getDeclaringProjectBuildPathEntry().getFileBinding(functionPackageName, fileNameKey, fileAST);
            fileScope = new FileScope((Scope)new EnvironmentScope((IEnvironment)env, (IDependencyRequestor)this.dependencyInfo), fileBinding, (IDependencyRequestor)this.dependencyInfo);
            this.dependencyInfo.recordTypeBinding((ITypeBinding)fileBinding);
        }
        FunctionContainerScope scope = new FunctionContainerScope((Scope)new SystemScope((Scope)fileScope, (IEnvironment)SystemEnvironment.getInstance()), this.functionContainerScope);
        return scope;
    }

    private Scope createScope(ExternalProjectEnvironment env, String[] functionPackageName, String[] contextPackageName, String contextPartName, File fileAST, String fileNameKey, boolean isContainerContextDependent) {
        FileScope fileScope;
        if (isContainerContextDependent) {
            String fileName = Util.getFilePartName(this.contextProjectInfo.getPartOrigin(contextPackageName, contextPartName).getEGLFile());
            IPartBinding fileBinding = this.contextProjectEnvrionment.getPartBinding(contextPackageName, fileName);
            fileScope = new FileScope((Scope)new EnvironmentScope((IEnvironment)this.contextProjectEnvrionment, (IDependencyRequestor)this.dependencyInfo), (FileBinding)fileBinding, (IDependencyRequestor)this.dependencyInfo);
        } else {
            FileBinding fileBinding = env.getDeclaringProjectBuildPathEntry().getFileBinding(functionPackageName, fileNameKey, fileAST);
            fileScope = new FileScope((Scope)new EnvironmentScope((IEnvironment)env, (IDependencyRequestor)this.dependencyInfo), fileBinding, (IDependencyRequestor)this.dependencyInfo);
            this.dependencyInfo.recordTypeBinding((ITypeBinding)fileBinding);
        }
        FunctionContainerScope scope = new FunctionContainerScope((Scope)new SystemScope((Scope)fileScope, (IEnvironment)SystemEnvironment.getInstance()), this.functionContainerScope);
        return scope;
    }

    private Scope createScope(IProject functionProject, String[] functionPackageName, String[] contextPackageName, String contextPartName, IFile functionDeclaringFile, boolean isContainerContextDependent) {
        FileScope fileScope;
        String fileName;
        if (isContainerContextDependent) {
            fileName = Util.getFilePartName(this.contextProjectInfo.getPartOrigin(contextPackageName, contextPartName).getEGLFile());
            IPartBinding fileBinding = this.contextProjectEnvrionment.getPartBinding(contextPackageName, fileName);
            fileScope = new FileScope((Scope)new EnvironmentScope((IEnvironment)this.contextProjectEnvrionment, (IDependencyRequestor)this.dependencyInfo), (FileBinding)fileBinding, (IDependencyRequestor)this.dependencyInfo);
        } else {
            fileName = Util.getFilePartName(functionDeclaringFile);
            WorkingCopyProjectEnvironment functionProjectEnvironment = WorkingCopyProjectEnvironmentManager.getInstance().getProjectEnvironment(functionProject);
            IPartBinding fileBinding = functionProjectEnvironment.getPartBinding(functionPackageName, fileName);
            fileScope = new FileScope((Scope)new EnvironmentScope((IEnvironment)functionProjectEnvironment, (IDependencyRequestor)this.dependencyInfo), (FileBinding)fileBinding, (IDependencyRequestor)this.dependencyInfo);
            this.dependencyInfo.recordTypeBinding((ITypeBinding)fileBinding);
        }
        FunctionContainerScope scope = new FunctionContainerScope((Scope)new SystemScope((Scope)fileScope, (IEnvironment)SystemEnvironment.getInstance()), this.functionContainerScope);
        return scope;
    }

    private String asString(String[] arr) {
        if (arr == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < arr.length) {
            if (i > 0) {
                buffer.append(".");
            }
            buffer.append(arr[i]);
            ++i;
        }
        return buffer.toString();
    }

    private IClassFile getClassFile(IProject project, String packageName, String partName) {
        String classFileName = String.valueOf(partName.toLowerCase()) + ".ir";
        return IFilePartInfo.getClassFile((IResource)project, packageName, 1, classFileName);
    }

    private String getFileAstKey(IClassFile classFile, IProject project, String packageName) {
        if (classFile instanceof EGLElement) {
            try {
                Object info = ((EGLElement)((Object)classFile)).getElementInfo();
                if (info instanceof ClassFileElementInfo) {
                    IPath path = classFile.getPath();
                    return String.valueOf(path.toString()) + ":" + project.getName() + "/" + packageName + "/" + ((ClassFileElementInfo)info).getEglFileName();
                }
            }
            catch (EGLModelException eGLModelException) {}
        }
        return classFile.toString();
    }

    private Part getContextAst(IFile containerFile, String contextPartName) {
        return WorkingCopyASTManager.getInstance().getPartAST(containerFile, contextPartName);
    }

    private String buildPartName(String[] pkg, String part) {
        if (pkg == null || pkg.length == 0) {
            return part;
        }
        return String.valueOf(this.asString(pkg)) + "." + part;
    }

    private class WorkingCopyTopLevelFunctionProcessingUnit {
        IPartBinding function;
        String contextSpecificCaseSensitiveInternedFunctionName;

        WorkingCopyTopLevelFunctionProcessingUnit(IPartBinding function) {
            this.function = function;
            this.contextSpecificCaseSensitiveInternedFunctionName = this.createContextSpecificFunctionName();
        }

        private String createContextSpecificFunctionName() {
            StringBuffer contextSpecificFunctionNameBuffer = new StringBuffer();
            contextSpecificFunctionNameBuffer.append(String.valueOf(WorkingCopyTopLevelFunctionProcessingQueue.this.containerContext.getName()) + "$");
            int i = 0;
            while (i < this.function.getPackageName().length) {
                contextSpecificFunctionNameBuffer.append(String.valueOf(this.function.getPackageName()[i]) + ".");
                ++i;
            }
            contextSpecificFunctionNameBuffer.append(this.function.getName());
            return contextSpecificFunctionNameBuffer.toString();
        }
    }

    public class WorkingCopyTopLevelFunctionProcessingUnitKey {
        IPartBinding function;

        public WorkingCopyTopLevelFunctionProcessingUnitKey(IPartBinding function) {
            this.function = function;
        }

        public boolean equals(Object otherObject) {
            if (this == otherObject) {
                return true;
            }
            if (otherObject instanceof WorkingCopyTopLevelFunctionProcessingUnitKey) {
                WorkingCopyTopLevelFunctionProcessingUnitKey otherPUKey = (WorkingCopyTopLevelFunctionProcessingUnitKey)otherObject;
                return otherPUKey.function == this.function;
            }
            return false;
        }

        public int hashCode() {
            return this.function.getName().hashCode();
        }
    }
}

