/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.dependency;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.TopLevelFunctionBinding;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionContainerScope;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;
import org.eclipse.edt.ide.core.internal.dependency.IDependencyInfo;

public abstract class AbstractDependencyInfo
implements IDependencyInfo,
IDependencyRequestor {
    private Set topLevelFunctions = new LinkedHashSet();
    private FunctionContainerScope functionContainerScope;
    private boolean recordTopLevelFunctions = true;

    @Override
    public Set getTopLevelFunctions() {
        return Collections.unmodifiableSet(this.topLevelFunctions);
    }

    public void recordTopLevelFunctionBinding(IFunctionBinding functionBinding) {
        if (this.recordTopLevelFunctions && functionBinding.isTopLevelFunction()) {
            this.topLevelFunctions.add(functionBinding);
            String[] qualifiedName = ((TopLevelFunctionBinding)functionBinding).getPackageName();
            int length = qualifiedName.length;
            String[] stringArray = qualifiedName;
            qualifiedName = new String[length + 1];
            System.arraycopy(stringArray, 0, qualifiedName, 0, length);
            qualifiedName[length] = functionBinding.getName();
            this.recordQualifiedName(InternUtil.intern((String[])qualifiedName));
        }
    }

    protected abstract void recordQualifiedName(String[] var1);

    public void recordFunctionContainerScope(FunctionContainerScope scope) {
        this.functionContainerScope = scope;
    }

    @Override
    public FunctionContainerScope getFunctionContainerScope() {
        return this.functionContainerScope;
    }

    public void stopRecordingTopLevelFunctionBindings() {
        this.recordTopLevelFunctions = false;
    }

    public void startRecordingTopLevelFunctionBindings() {
        this.recordTopLevelFunctions = true;
    }
}

