/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.dependency;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;
import org.eclipse.edt.compiler.internal.core.utils.ReadWriteMonitor;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.dependency.DependencyEntry;
import org.eclipse.edt.ide.core.internal.dependency.Function;
import org.eclipse.edt.ide.core.internal.dependency.FunctionEntry;
import org.eclipse.edt.ide.core.internal.dependency.IDependencyGraphEntry;
import org.eclipse.edt.ide.core.internal.dependency.IDependencyGraphValue;
import org.eclipse.edt.ide.core.internal.dependency.IDependencyInfo;
import org.eclipse.edt.ide.core.internal.dependency.IFunctionRequestor;
import org.eclipse.edt.ide.core.internal.dependency.IOPool;
import org.eclipse.edt.ide.core.internal.dependency.IPartRequestor;
import org.eclipse.edt.ide.core.internal.dependency.Part;
import org.eclipse.edt.ide.core.internal.dependency.QualifiedName;
import org.eclipse.edt.ide.core.internal.dependency.QualifiedNameDependentEntry;
import org.eclipse.edt.ide.core.internal.dependency.SimpleName;
import org.eclipse.edt.ide.core.internal.dependency.SimpleNameDependentEntry;
import org.eclipse.edt.ide.core.internal.lookup.AbstractProjectEnvironment;

public class DependencyGraph {
    private static final String FUNCTIONS_DIRECTORY = "functions";
    private static final String DEPENDENTS_DIRECTORY = "dependents";
    private static final String DEPENDENCIES_DIRECTORY = "dependencies";
    private IPath functionsDirectory;
    private IPath dependentsDirectory;
    private IPath dependenciesDirectory;
    private static final boolean DEBUG = false;
    private static final String DEPENDENCY_GRAPH_FILE_EXTENSION = "dg";
    private ReadWriteMonitor monitor = new ReadWriteMonitor();
    private IOPool bufferPool = new IOPool();

    protected DependencyGraph(IProject project) {
        IPath cacheLocation = project.getWorkingLocation(EDTCoreIDEPlugin.getPlugin().getBundle().getSymbolicName());
        this.functionsDirectory = cacheLocation.append(FUNCTIONS_DIRECTORY);
        this.dependentsDirectory = cacheLocation.append(DEPENDENTS_DIRECTORY);
        this.dependenciesDirectory = cacheLocation.append(DEPENDENCIES_DIRECTORY);
    }

    private void recordSimpleNameDependency(String[] packageName, String partName, SimpleName simpleName) {
        Part entryKey = new Part(packageName, partName);
        DependencyEntry dependencyEntry = (DependencyEntry)this.getDependencyEntry(entryKey, 0);
        if (dependencyEntry == null) {
            dependencyEntry = new DependencyEntry();
        }
        dependencyEntry.addSimpleName(simpleName);
        this.putDependencyEntry(entryKey, 0, dependencyEntry);
    }

    private void recordQualifiedNameDependency(String[] packageName, String partName, QualifiedName qualifiedName) {
        Part entryKey = new Part(packageName, partName);
        DependencyEntry dependencyEntry = (DependencyEntry)this.getDependencyEntry(entryKey, 0);
        if (dependencyEntry == null) {
            dependencyEntry = new DependencyEntry();
        }
        dependencyEntry.addQualifiedName(qualifiedName);
        this.putDependencyEntry(entryKey, 0, dependencyEntry);
    }

    private void recordFunctionDependency(String[] packageName, String partName, Function function) {
        Part entryKey = new Part(packageName, partName);
        FunctionEntry functionEntry = (FunctionEntry)this.getDependencyEntry(entryKey, 3);
        if (functionEntry == null) {
            functionEntry = new FunctionEntry();
        }
        functionEntry.addFunction(function);
        this.putDependencyEntry(entryKey, 3, functionEntry);
    }

    private void recordSimpleNameDependent(String[] packageName, String partName, String filePartName, SimpleName entryKey) {
        SimpleNameDependentEntry dependentEntry = (SimpleNameDependentEntry)this.getDependencyEntry(entryKey, 2);
        if (dependentEntry == null) {
            dependentEntry = new SimpleNameDependentEntry();
        }
        dependentEntry.addPart(new Part(packageName, filePartName), new SimpleName(partName));
        this.putDependencyEntry(entryKey, 2, dependentEntry);
    }

    private void recordQualifiedNameDependent(String[] packageName, String partName, QualifiedName entryKey) {
        QualifiedNameDependentEntry dependentEntry = (QualifiedNameDependentEntry)this.getDependencyEntry(entryKey, 1);
        if (dependentEntry == null) {
            dependentEntry = new QualifiedNameDependentEntry();
        }
        dependentEntry.addPart(new Part(packageName, partName));
        this.putDependencyEntry(entryKey, 1, dependentEntry);
    }

    private void removeSimpleNameDependency(String[] packageName, String partName, SimpleName simpleName) {
        Part entryKey = new Part(packageName, partName);
        DependencyEntry dependencyEntry = (DependencyEntry)this.getDependencyEntry(entryKey, 0);
        if (dependencyEntry != null) {
            dependencyEntry.removeSimpleName(simpleName);
            if (dependencyEntry.isEmpty()) {
                this.removeDependencyEntry(entryKey, 0);
            } else {
                this.putDependencyEntry(entryKey, 0, dependencyEntry);
            }
        }
    }

    private void removeSimpleNameDependent(String[] packageName, String partName, String filePartName, SimpleName entryKey) {
        SimpleNameDependentEntry dependentEntry = (SimpleNameDependentEntry)this.getDependencyEntry(entryKey, 2);
        if (dependentEntry != null) {
            dependentEntry.removePart(new Part(packageName, filePartName), new SimpleName(partName));
            if (dependentEntry.isEmpty()) {
                this.removeDependencyEntry(entryKey, 2);
            } else {
                this.putDependencyEntry(entryKey, 2, dependentEntry);
            }
        }
    }

    private void removeQualifiedNameDependency(String[] packageName, String partName, QualifiedName qualifiedName) {
        Part entryKey = new Part(packageName, partName);
        DependencyEntry dependencyEntry = (DependencyEntry)this.getDependencyEntry(entryKey, 0);
        if (dependencyEntry != null) {
            dependencyEntry.removeQualifiedName(qualifiedName);
            if (dependencyEntry.isEmpty()) {
                this.removeDependencyEntry(entryKey, 0);
            } else {
                this.putDependencyEntry(entryKey, 0, dependencyEntry);
            }
        }
    }

    private void removeQualifiedNameDependent(String[] packageName, String partName, QualifiedName entryKey) {
        QualifiedNameDependentEntry dependentEntry = (QualifiedNameDependentEntry)this.getDependencyEntry(entryKey, 1);
        if (dependentEntry != null) {
            dependentEntry.removePart(new Part(packageName, partName));
            if (dependentEntry.isEmpty()) {
                this.removeDependencyEntry(entryKey, 1);
            } else {
                this.putDependencyEntry(entryKey, 1, dependentEntry);
            }
        }
    }

    private void removeFunctionDependency(String[] packageName, String partName, Function function) {
        Part entryKey = new Part(packageName, partName);
        FunctionEntry functionEntry = (FunctionEntry)this.getDependencyEntry(entryKey, 3);
        if (functionEntry != null) {
            functionEntry.removeFunction(function);
            if (functionEntry.isEmpty()) {
                this.removeDependencyEntry(entryKey, 3);
            } else {
                this.putDependencyEntry(entryKey, 3, functionEntry);
            }
        }
    }

    public void findDependents(String[] packageName, String partName, IPartRequestor requestor) {
        this.monitor.enterRead();
        try {
            System.currentTimeMillis();
            if (packageName.length == 0) {
                this.findDependents(partName, requestor);
            } else {
                String[] qualifiedNameArray = new String[packageName.length + 1];
                System.arraycopy(packageName, 0, qualifiedNameArray, 0, packageName.length);
                qualifiedNameArray[qualifiedNameArray.length - 1] = partName;
                this.findQualifiedNameDependents(InternUtil.intern((String[])qualifiedNameArray), requestor);
                this.findMatchingDependents(packageName, partName, requestor);
            }
        }
        finally {
            this.monitor.exitRead();
        }
    }

    private void findMatchingDependents(String[] packageName, String partName, IPartRequestor requestor) {
        SimpleNameDependentEntry dependentEntry = (SimpleNameDependentEntry)this.getDependencyEntry(new SimpleName(partName), 2);
        if (dependentEntry != null) {
            final ArrayList fileParts = new ArrayList();
            this.findDependents(packageName, new IPartRequestor(){

                @Override
                public void acceptPart(String[] packageName, String partName) {
                    Part filePart = new Part(packageName, partName);
                    fileParts.add(filePart);
                }
            });
            for (Part filePart : fileParts) {
                HashSet partsPerFile;
                if (filePart == null || (partsPerFile = dependentEntry.getParts(filePart)) == null) continue;
                for (SimpleName part : partsPerFile) {
                    requestor.acceptPart(filePart.getPackageName(), part.getSimpleName());
                }
            }
        }
    }

    public void findDependents(String[] packageName, IPartRequestor requestor) {
        this.monitor.enterRead();
        try {
            System.currentTimeMillis();
            if (packageName.length > 1) {
                this.findQualifiedNameDependents(packageName, requestor);
            } else {
                this.findDependents(packageName[0], requestor);
            }
        }
        finally {
            this.monitor.exitRead();
        }
    }

    private void findQualifiedNameDependents(String[] qualifiedName, IPartRequestor requestor) {
        QualifiedName entryKey = new QualifiedName(qualifiedName);
        QualifiedNameDependentEntry dependentEntry = (QualifiedNameDependentEntry)this.getDependencyEntry(entryKey, 1);
        if (dependentEntry != null) {
            Set dependents = dependentEntry.getParts();
            for (Part dependent : dependents) {
                requestor.acceptPart(dependent.getPackageName(), dependent.getPartName());
            }
        }
    }

    public void findDependents(String simpleName, IPartRequestor requestor) {
        SimpleName entryKey = new SimpleName(simpleName);
        SimpleNameDependentEntry dependentEntry = (SimpleNameDependentEntry)this.getDependencyEntry(entryKey, 2);
        if (dependentEntry != null) {
            HashSet dependents = dependentEntry.getFileParts();
            for (Part filePart : dependents) {
                HashSet partsPerFile = dependentEntry.getParts(filePart);
                for (SimpleName part : partsPerFile) {
                    requestor.acceptPart(filePart.getPackageName(), part.getSimpleName());
                }
            }
        }
    }

    public void findFunctionDependencies(String[] packageName, String partName, IFunctionRequestor requestor) {
        this.monitor.enterRead();
        try {
            System.currentTimeMillis();
            Part entryKey = new Part(packageName, partName);
            FunctionEntry functionEntry = (FunctionEntry)this.getDependencyEntry(entryKey, 3);
            if (functionEntry != null) {
                Set functions = functionEntry.getFunctions();
                for (Function function : functions) {
                    requestor.acceptFunction(function.getProjectName(), function.getPackageName(), function.getPartName());
                }
            }
        }
        finally {
            this.monitor.exitRead();
        }
    }

    public void removePart(String[] packageName, String partName, String filePartName) {
        this.monitor.enterWrite();
        try {
            Part entryKey = new Part(packageName, partName);
            DependencyEntry dependencies = (DependencyEntry)this.getDependencyEntry(entryKey, 0);
            if (dependencies != null) {
                this.removeSimpleNames(packageName, partName, filePartName, dependencies.getSimpleNames());
                this.removeQualifiedNames(packageName, partName, dependencies.getQualifiedNames());
            }
            this.removeDependencyEntry(entryKey, 0);
            this.removeDependencyEntry(entryKey, 3);
        }
        finally {
            this.monitor.exitWrite();
        }
    }

    private void removeQualifiedNames(String[] packageName, String partName, Set qualifiedNames) {
        for (QualifiedName qualifiedName : qualifiedNames) {
            this.removeQualifiedNameDependent(packageName, partName, qualifiedName);
        }
    }

    private void removeSimpleNames(String[] packageName, String partName, String filePartName, Set simpleNames) {
        for (SimpleName simpleName : simpleNames) {
            this.removeSimpleNameDependent(packageName, partName, filePartName, simpleName);
        }
    }

    public void putPart(String[] packageName, String partName, String filePartName, IDependencyInfo dependencyInfo) {
        this.monitor.enterWrite();
        try {
            Part entryKey = new Part(packageName, partName);
            DependencyEntry dependencies = (DependencyEntry)this.getDependencyEntry(entryKey, 0);
            this.putSimpleNames(packageName, partName, filePartName, dependencyInfo, dependencies);
            this.putQualifiedNames(packageName, partName, dependencyInfo, dependencies);
            FunctionEntry functionDependencies = (FunctionEntry)this.getDependencyEntry(entryKey, 3);
            this.putFunctionDependencies(packageName, partName, dependencyInfo, functionDependencies);
        }
        finally {
            this.monitor.exitWrite();
        }
    }

    private void putQualifiedNames(String[] packageName, String partName, IDependencyInfo newDependencies, DependencyEntry previousDependencies) {
        Set previousQualifiedNames = previousDependencies != null ? new HashSet(previousDependencies.getQualifiedNames()) : Collections.EMPTY_SET;
        Iterator iter = newDependencies.getQualifiedNames().iterator();
        while (iter.hasNext()) {
            QualifiedName qualifiedName = new QualifiedName((String[])iter.next());
            if (!previousQualifiedNames.contains(qualifiedName)) {
                this.recordQualifiedNameDependency(packageName, partName, qualifiedName);
                this.recordQualifiedNameDependent(packageName, partName, qualifiedName);
                continue;
            }
            previousQualifiedNames.remove(qualifiedName);
        }
        for (QualifiedName qualifiedName : previousQualifiedNames) {
            this.removeQualifiedNameDependency(packageName, partName, qualifiedName);
            this.removeQualifiedNameDependent(packageName, partName, qualifiedName);
        }
    }

    private void putSimpleNames(String[] packageName, String partName, String filePartName, IDependencyInfo newDependencies, DependencyEntry previousDependencies) {
        Set previousSimpleNames = previousDependencies != null ? new HashSet(previousDependencies.getSimpleNames()) : Collections.EMPTY_SET;
        Iterator iter = newDependencies.getSimpleNames().iterator();
        while (iter.hasNext()) {
            SimpleName simpleName = new SimpleName((String)iter.next());
            if (!previousSimpleNames.contains(simpleName)) {
                this.recordSimpleNameDependency(packageName, partName, simpleName);
                this.recordSimpleNameDependent(packageName, partName, filePartName, simpleName);
                continue;
            }
            previousSimpleNames.remove(simpleName);
        }
        for (SimpleName simpleName : previousSimpleNames) {
            this.removeSimpleNameDependency(packageName, partName, simpleName);
            this.removeSimpleNameDependent(packageName, partName, filePartName, simpleName);
        }
    }

    private void putFunctionDependencies(String[] packageName, String partName, IDependencyInfo newFunctions, FunctionEntry functionEntry) {
        Set previousFunctions = functionEntry != null ? new HashSet(functionEntry.getFunctions()) : Collections.EMPTY_SET;
        for (IPartBinding functionBinding : newFunctions.getTopLevelFunctions()) {
            Function function = new Function(((AbstractProjectEnvironment)functionBinding.getEnvironment()).getProjectName(), functionBinding.getPackageName(), functionBinding.getName());
            if (!previousFunctions.contains(function)) {
                this.recordFunctionDependency(packageName, partName, function);
                continue;
            }
            previousFunctions.remove(function);
        }
        for (Function function : previousFunctions) {
            this.removeFunctionDependency(packageName, partName, function);
        }
    }

    public void save() {
        this.monitor.enterWrite();
        try {
            this.bufferPool.flush();
        }
        finally {
            this.monitor.exitWrite();
        }
    }

    public void clear() {
        this.monitor.enterWrite();
        this.bufferPool.clear();
        try {
            this.clearDirectory(this.dependenciesDirectory.toFile());
            this.clearDirectory(this.dependentsDirectory.toFile());
            this.clearDirectory(this.functionsDirectory.toFile());
        }
        finally {
            this.monitor.exitWrite();
        }
    }

    private void clearDirectory(File cacheDir) {
        if (cacheDir.exists()) {
            File[] graphFiles = cacheDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(DependencyGraph.DEPENDENCY_GRAPH_FILE_EXTENSION);
                }
            });
            int i = 0;
            while (i < graphFiles.length) {
                graphFiles[i].delete();
                ++i;
            }
        }
    }

    private IPath getBufferName(IDependencyGraphValue key, int dependencyType) {
        int numBuffers;
        IPath outputFolder;
        switch (dependencyType) {
            case 0: {
                outputFolder = this.dependenciesDirectory;
                numBuffers = 500;
                break;
            }
            case 1: 
            case 2: {
                outputFolder = this.dependentsDirectory;
                numBuffers = 500;
                break;
            }
            case 3: {
                outputFolder = this.functionsDirectory;
                numBuffers = 10;
                break;
            }
            default: {
                throw new BuildException("Invalid Dependency Type");
            }
        }
        StringBuffer outputFileName = new StringBuffer(String.valueOf(Math.abs(key.getNormalizedHashCode()) % numBuffers)).append(DEPENDENCY_GRAPH_FILE_EXTENSION);
        return outputFolder.append(outputFileName.toString());
    }

    private IDependencyGraphEntry getDependencyEntry(IDependencyGraphValue key, int type) {
        HashMap dependencyMap = this.bufferPool.get(this.getBufferName(key, type));
        if (dependencyMap != null) {
            return (IDependencyGraphEntry)dependencyMap.get(key);
        }
        return null;
    }

    private void putDependencyEntry(IDependencyGraphValue key, int type, IDependencyGraphEntry value) {
        HashMap<IDependencyGraphValue, IDependencyGraphEntry> dependencyMap = this.bufferPool.get(this.getBufferName(key, type));
        if (dependencyMap == null) {
            dependencyMap = new HashMap<IDependencyGraphValue, IDependencyGraphEntry>();
        }
        dependencyMap.put(key, value);
        this.bufferPool.put(this.getBufferName(key, type), dependencyMap);
    }

    private void removeDependencyEntry(IDependencyGraphValue key, int type) {
        HashMap dependencyMap = this.bufferPool.get(this.getBufferName(key, type));
        if (dependencyMap != null) {
            dependencyMap.remove(key);
            if (dependencyMap.size() == 0) {
                this.bufferPool.remove(this.getBufferName(key, type));
            } else {
                this.bufferPool.put(this.getBufferName(key, type), dependencyMap);
            }
        }
    }
}

