/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.dependency;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;
import org.eclipse.edt.ide.core.internal.dependency.AbstractDependencyInfo;
import org.eclipse.edt.ide.core.internal.dependency.IDependencyInfo;

public class DependencyInfo
extends AbstractDependencyInfo
implements IDependencyInfo,
IDependencyRequestor {
    private Set simpleNames = new HashSet();
    private Set qualifiedNames = new HashSet();

    @Override
    public Set getQualifiedNames() {
        return Collections.unmodifiableSet(this.qualifiedNames);
    }

    @Override
    public Set getSimpleNames() {
        return Collections.unmodifiableSet(this.simpleNames);
    }

    public void recordName(Name name) {
        if (name.isSimpleName()) {
            this.recordSimpleName(name.getIdentifier());
        } else if (name.isQualifiedName()) {
            this.recordQualifiedName(InternUtil.intern((String[])((QualifiedName)name).getNameComponents()));
        }
    }

    public void recordSimpleName(String simpleName) {
        if (!this.containsSimpleName(simpleName)) {
            this.addSimpleName(simpleName);
        }
    }

    public void recordBinding(IBinding binding) {
        if (!binding.isDataBinding()) {
            if (binding.isTypeBinding()) {
                this.recordTypeBinding((ITypeBinding)binding);
            } else if (binding.isPackageBinding()) {
                this.recordPackageBinding((IPackageBinding)binding);
            }
        }
    }

    public void recordPackageBinding(IPackageBinding packageBinding) {
        this.recordQualifiedName(InternUtil.intern((String[])packageBinding.getPackageName()));
    }

    public void recordTypeBinding(ITypeBinding typeBinding) {
        if (!Binding.isValidBinding((IBinding)typeBinding)) {
            return;
        }
        if (typeBinding.getKind() == 18 || typeBinding.getKind() == 3) {
            return;
        }
        if (typeBinding.getKind() == 2) {
            this.recordTypeBinding(typeBinding.getBaseType());
            return;
        }
        if (typeBinding.getKind() == 20 && !typeBinding.isPartBinding()) {
            return;
        }
        if (typeBinding.getKind() == 28) {
            List extendedTypes = ((ExternalTypeBinding)typeBinding).getExtendedTypes();
            Iterator iter = extendedTypes.iterator();
            while (iter.hasNext()) {
                this.doRecordTypeBinding((ITypeBinding)iter.next());
            }
        }
        this.doRecordTypeBinding(typeBinding);
    }

    private void doRecordTypeBinding(ITypeBinding typeBinding) {
        String[] qualifiedName = typeBinding.getPackageName();
        int length = qualifiedName.length;
        String[] stringArray = qualifiedName;
        qualifiedName = new String[length + 1];
        System.arraycopy(stringArray, 0, qualifiedName, 0, length);
        qualifiedName[length] = typeBinding.getName();
        this.recordQualifiedName(InternUtil.intern((String[])qualifiedName));
    }

    @Override
    protected void recordQualifiedName(String[] qualifiedName) {
        int length = qualifiedName.length;
        if (length > 1) {
            while (!this.containsQualifiedName(qualifiedName)) {
                this.addQualifiedName(qualifiedName);
                if (length == 2) {
                    this.recordSimpleName(qualifiedName[0]);
                    this.recordSimpleName(qualifiedName[1]);
                    return;
                }
                this.recordSimpleName(qualifiedName[--length]);
                String[] stringArray = qualifiedName;
                qualifiedName = new String[length];
                System.arraycopy(stringArray, 0, qualifiedName, 0, length);
                qualifiedName = InternUtil.intern((String[])qualifiedName);
            }
        } else if (length == 1) {
            this.recordSimpleName(qualifiedName[0]);
        }
    }

    private void addSimpleName(String simpleName) {
        this.simpleNames.add(simpleName);
    }

    private void addQualifiedName(String[] qualifiedName) {
        this.qualifiedNames.add(qualifiedName);
    }

    private boolean containsSimpleName(String simpleName) {
        return this.simpleNames.contains(simpleName);
    }

    private boolean containsQualifiedName(String[] qualifiedName) {
        return this.qualifiedNames.contains(qualifiedName);
    }
}

