/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.generation;

import com.ibm.icu.util.StringTokenizer;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;
import org.eclipse.edt.compiler.internal.util.EGLMessage;
import org.eclipse.edt.ide.core.CoreIDEPluginStrings;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.ide.core.Logger;
import org.eclipse.edt.ide.core.generation.IGenerationMessageRequestor;
import org.eclipse.edt.ide.core.internal.binding.BinaryFileManager;
import org.eclipse.edt.ide.core.internal.builder.IDEEnvironment;
import org.eclipse.edt.ide.core.internal.generation.GenerateOperation;
import org.eclipse.edt.ide.core.internal.generation.GenerationRequest;
import org.eclipse.edt.ide.core.internal.generation.IEGLPartWrapper;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfo;
import org.eclipse.edt.ide.core.internal.lookup.generate.GenerateEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.generate.GenerateEnvironmentManager;
import org.eclipse.edt.ide.core.internal.utils.StringOutputBuffer;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.mof.egl.InvalidPartTypeException;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PartNotFoundException;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class GeneratePartsOperation
extends GenerateOperation {
    private static final Object lock = new Object();
    private ArrayList<GenerationRequest> genRequestList = new ArrayList();
    private final boolean invokedByBuild;

    public GeneratePartsOperation(boolean invokedByBuild) {
        this.invokedByBuild = invokedByBuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGenerationRequest(GenerationRequest request) {
        ArrayList<GenerationRequest> arrayList = this.genRequestList;
        synchronized (arrayList) {
            this.genRequestList.add(request);
        }
    }

    public void generate(GenerationRequest request) {
        this.addGenerationRequest(request);
        Job generationJob = this.createGenerationJob(true, false);
        generationJob.schedule();
    }

    public void generate(GenerationRequest[] requests, boolean respectBuildBeforeGenerate, boolean runInBackground) {
        int i = 0;
        while (i < requests.length) {
            this.addGenerationRequest(requests[i]);
            ++i;
        }
        Job generationJob = this.createGenerationJob(respectBuildBeforeGenerate, runInBackground);
        generationJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IEGLPartWrapper[] parts, boolean respectBuildBeforeGenerate, boolean runInBackground) {
        GenerationRequest gr = new GenerationRequest(parts);
        ArrayList<GenerationRequest> arrayList = this.genRequestList;
        synchronized (arrayList) {
            this.genRequestList.add(gr);
        }
        Job generationJob = this.createGenerationJob(respectBuildBeforeGenerate, runInBackground);
        generationJob.schedule();
    }

    private Job createGenerationJob(boolean respectBuildBeforeGenerate, boolean runInBackground) {
        boolean build;
        if (respectBuildBeforeGenerate && !ResourcesPlugin.getWorkspace().isAutoBuilding() && (build = false)) {
            try {
                ResourcesPlugin.getWorkspace().build(10, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        Job generationJob = new Job(CoreIDEPluginStrings.GeneratePartsOperation_JobName){

            public boolean shouldRun() {
                return super.shouldRun() && !GeneratePartsOperation.this.isWorkbenchClosing();
            }

            public IStatus run(IProgressMonitor monitor) {
                WorkspaceModifyOperation modifyOperation = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        GeneratePartsOperation.this.generateParts(monitor);
                    }
                };
                try {
                    modifyOperation.run(monitor);
                }
                catch (InvocationTargetException e) {
                    Logger.log((Object)this, "GeneratePartsOperation.createGenerationJob():  InvocationTargetException", e);
                }
                catch (InterruptedException e) {
                    Logger.log((Object)this, "GeneratePartsOperation.createGenerationJob():  InterruptedException", e);
                }
                return Status.OK_STATUS;
            }
        };
        generationJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        generationJob.setUser(!runInBackground);
        generationJob.setSystem(false);
        generationJob.setPriority(30);
        return generationJob;
    }

    protected static IGenerationMessageRequestor createMessageRequestor() {
        return new IGenerationMessageRequestor(){
            ArrayList list = new ArrayList();
            boolean error = false;

            @Override
            public void addMessage(EGLMessage message) {
                this.list.add(message);
                if (message.isError()) {
                    this.error = true;
                }
            }

            @Override
            public void addMessages(List list) {
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    this.addMessage((EGLMessage)i.next());
                }
            }

            @Override
            public List getMessages() {
                return this.list;
            }

            @Override
            public boolean isError() {
                return this.error;
            }

            @Override
            public void clear() {
                this.error = false;
                this.list = new ArrayList();
            }
        };
    }

    protected boolean isWorkbenchClosing() {
        try {
            return PlatformUI.getWorkbench().isClosing();
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public void generateParts(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 10[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void handleRuntimeException(RuntimeException e, IGenerationMessageRequestor messageRequestor, String partName, HashSet seen) {
        if (seen.contains(e)) {
            this.handleUnknownException(e, messageRequestor);
            return;
        }
        seen.add(e);
        Throwable cause = e.getCause();
        if (cause instanceof PartNotFoundException) {
            this.buildPartNotFoundMessage((PartNotFoundException)cause, messageRequestor, partName);
            return;
        }
        if (cause instanceof InvalidPartTypeException) {
            this.buildInvalidPartTypeMessage((InvalidPartTypeException)cause, messageRequestor, partName);
            return;
        }
        if (cause instanceof RuntimeException) {
            this.handleRuntimeException((RuntimeException)cause, messageRequestor, partName, seen);
            return;
        }
        this.handleUnknownException(e, messageRequestor);
    }

    protected void handleUnknownException(Exception e, IGenerationMessageRequestor messageRequestor) {
        this.buildExceptionMessage(e, messageRequestor);
        GeneratePartsOperation.buildStackTraceMessages(e, messageRequestor);
        Logger.log(this, "GeneratePartsOperation.generateParts():  Error during generation", e);
    }

    protected void clearGenerationCaches() {
        GenerateEnvironmentManager.getInstance().clearAllCaches();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasError(IFile file) {
        if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            return false;
        }
        if (file == null || !file.exists()) {
            return false;
        }
        try {
            IMarker[] markers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
            if (markers == null) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= markers.length) {
                    return false;
                }
                int severity = markers[i].getAttribute("severity", 0);
                if (severity >= 2) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    protected Part findPart(String partName, GenerateEnvironment environment) throws PartNotFoundException {
        String[] packageName = this.getPackageName(partName);
        int index = partName.lastIndexOf(".");
        String name = partName;
        if (index > -1) {
            name = name.substring(index + 1);
        }
        return environment.findPart(InternUtil.intern((String[])packageName), InternUtil.intern((String)name));
    }

    @Override
    protected String[] getPackageName(String partName) {
        ArrayList<String> list = new ArrayList<String>();
        String remaining = partName;
        int index = partName.indexOf(".");
        while (index > -1) {
            String pkg = remaining.substring(0, index);
            remaining = remaining.substring(index + 1);
            list.add(pkg);
            index = remaining.indexOf(".");
        }
        return list.toArray(new String[list.size()]);
    }

    protected void buildPartNotFoundMessage(PartNotFoundException e, IGenerationMessageRequestor result, String partName) {
        EGLMessage message = EGLMessage.createEGLValidationErrorMessage((String)"9001", null, (String[])new String[]{partName, e.getMessage()});
        result.addMessage(message);
    }

    protected void buildInvalidPartTypeMessage(InvalidPartTypeException e, IGenerationMessageRequestor result, String partName) {
        EGLMessage message = EGLMessage.createEGLValidationErrorMessage((String)"9001", null, (String[])new String[]{partName, e.getMessage()});
        result.addMessage(message);
    }

    private void invokeGenerators(IFile file, Part part) throws Exception {
        IGenerator[] generators = ProjectSettingsUtility.getGenerators((IResource)file);
        if (generators.length != 0) {
            IDEEnvironment env = BinaryFileManager.getInstance().getEnvironment(file.getProject());
            int i = 0;
            while (i < generators.length) {
                generators[i].generate(file, (Part)part.clone(), (IEnvironment)env, this.invokedByBuild);
                ++i;
            }
        }
    }

    public void buildExceptionMessage(Exception e, IGenerationMessageRequestor result) {
        String text = e.getMessage();
        if (text != null) {
            EGLMessage message = EGLMessage.createEGLValidationErrorMessage((String)"9998", null, (String)text);
            result.addMessage(message);
        }
    }

    public static void buildStackTraceMessages(Throwable e, IGenerationMessageRequestor result) {
        StringOutputBuffer buffer = new StringOutputBuffer();
        PrintWriter writer = new PrintWriter(buffer);
        e.printStackTrace(writer);
        writer.flush();
        String text = buffer.toString();
        StringTokenizer tokenizer = new StringTokenizer(text, "\n\r\f");
        while (tokenizer.hasMoreElements()) {
            char[] token = tokenizer.nextToken().toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            int i = 0;
            while (i < token.length) {
                if (token[i] == '\t') {
                    stringBuffer.append("      ");
                } else {
                    stringBuffer.append(token[i]);
                }
                ++i;
            }
            EGLMessage message = EGLMessage.createEGLValidationErrorMessage((String)"9999", null, (String)stringBuffer.toString());
            result.addMessage(message);
        }
    }

    @Override
    protected String[] getPackageName(String filename, ProjectInfo projectInfo) {
        Path path = new Path(filename);
        path = path.removeFirstSegments(1);
        path = path.removeLastSegments(1);
        String[] retVal = Util.pathToStringArray((IPath)path);
        while (retVal.length > 0) {
            if (projectInfo.hasPackage(InternUtil.intern((String[])retVal))) break;
            path = path.removeFirstSegments(1);
            retVal = Util.pathToStringArray((IPath)path);
        }
        return retVal;
    }

    protected String[] getPackageName(String filename, GenerateEnvironment env) {
        Path path = new Path(filename);
        path = path.removeFirstSegments(1);
        path = path.removeLastSegments(1);
        String[] retVal = Util.pathToStringArray((IPath)path);
        while (retVal.length > 0) {
            if (env.hasPackage(InternUtil.intern((String[])retVal))) break;
            path = path.removeFirstSegments(1);
            retVal = Util.pathToStringArray((IPath)path);
        }
        return retVal;
    }

    @Override
    protected IProject getProject(String filename) {
        Path path = new Path(filename);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
        return project;
    }
}

