/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.generation;

import org.eclipse.edt.compiler.internal.interfaces.IEGLComponentMessageContributor;
import org.eclipse.edt.compiler.internal.interfaces.IEGLLocation;
import org.eclipse.edt.compiler.internal.interfaces.IEGLMessageContributor;
import org.eclipse.edt.compiler.internal.util.EGLMessage;
import org.eclipse.edt.compiler.internal.util.IGenerationResultsMessage;

public class GenerationResultsMessage
implements IGenerationResultsMessage {
    String resourceName;
    int severity;
    String[] inserts;
    String id;
    int startOffset;
    int endOffset;
    int startLine;

    public GenerationResultsMessage(EGLMessage eglMsg) {
        if (eglMsg != null) {
            this.resourceName = eglMsg.getResourceName();
            this.severity = eglMsg.getSeverity();
            this.inserts = eglMsg.getParams();
            this.id = eglMsg.getId();
            this.startOffset = eglMsg.getStartOffset();
            this.endOffset = eglMsg.getEndOffset();
            this.startLine = eglMsg.getStartLine();
        }
    }

    public String[] getInserts() {
        return this.inserts;
    }

    public String getBuiltMessage() {
        return this.createEGLMessage().getBuiltMessage();
    }

    public String getBuiltMessageWithLineAndColumn() {
        return this.createEGLMessage().getBuiltMessageWithLineAndColumn();
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public String getId() {
        return this.id;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public int getSeverity() {
        return this.severity;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public boolean isError() {
        return this.getSeverity() == 1;
    }

    private IEGLMessageContributor getContributor() {
        if (this.resourceName == null) {
            return null;
        }
        return new IEGLMessageContributor(){

            public IEGLLocation getEnd() {
                return GenerationResultsMessage.this.getLocation(GenerationResultsMessage.this.endOffset, 0);
            }

            public IEGLComponentMessageContributor getMessageContributor() {
                return null;
            }

            public String getResourceName() {
                return GenerationResultsMessage.this.resourceName;
            }

            public IEGLLocation getStart() {
                return GenerationResultsMessage.this.getLocation(GenerationResultsMessage.this.startOffset, GenerationResultsMessage.this.startLine);
            }
        };
    }

    private IEGLLocation getLocation(final int offset, final int line) {
        return new IEGLLocation(){

            public int getColumn() {
                return 0;
            }

            public int getLength() {
                return 0;
            }

            public int getLine() {
                return line;
            }

            public int getOffset() {
                return offset;
            }
        };
    }

    private EGLMessage createEGLMessage() {
        if (this.severity == 1) {
            return EGLMessage.createEGLValidationErrorMessage((String)this.getId(), (Object)this.getContributor(), (String[])this.getInserts());
        }
        if (this.severity == 2) {
            return EGLMessage.createEGLValidationWarningMessage((String)this.getId(), (Object)this.getContributor(), (String[])this.getInserts());
        }
        return EGLMessage.createEGLValidationInformationalMessage((String)this.getId(), (Object)this.getContributor(), (String[])this.getInserts());
    }
}

