/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.generation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.util.SimpleLineTracker;
import org.eclipse.edt.ide.core.internal.lookup.FileInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfo;
import org.eclipse.edt.mof.egl.compiler.Context;

public class IDEContext
extends Context {
    private IFile file;
    private IProject project;
    private SimpleLineTracker lineTracker;

    public IDEContext(IFile file) {
        super(file.getFullPath().toString(), file.getName());
        this.file = file;
        this.project = file.getProject();
    }

    private IFile getFile() {
        if (this.file == null && this.getFileName() != null) {
            Path path = new Path(this.getFileName());
            try {
                this.file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.file;
    }

    private IProject getProject() {
        IFile contextFile;
        if (this.project == null && (contextFile = this.getFile()) != null) {
            this.project = contextFile.getProject();
        }
        return this.project;
    }

    public int getLineNumber(Node node) {
        IFileInfo fileInfo = FileInfoManager.getInstance().getFileInfo(this.getProject(), this.getFile().getProjectRelativePath());
        if (fileInfo != null) {
            return fileInfo.getLineNumberForOffset(node.getOffset()) + 1;
        }
        return 0;
    }

    protected int getLineNumberFromSource(int offset) {
        if (this.getLineTracker() == null) {
            return 0;
        }
        int[] lineOffsets = this.getLineTracker().getLineOffsets();
        int i = 0;
        while (i < lineOffsets.length) {
            if (lineOffsets[i] == offset) {
                return i;
            }
            if (lineOffsets[i] > offset) {
                return i - 1;
            }
            ++i;
        }
        return 0;
    }

    private SimpleLineTracker getLineTracker() {
        return this.lineTracker;
    }

    public String getAbsolutePath(String fileName) {
        IFile file = this.getFile(fileName);
        if (file == null || !file.exists()) {
            return fileName;
        }
        return file.getLocation().toString();
    }

    public IFile getFile(String fileName) {
        if (fileName == null) {
            return null;
        }
        Path path = new Path(fileName);
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

