/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.lookup.IBuildPathEntry;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProject;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectManager;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.JarPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLModelMarker;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.utils.EGLProjectFileUtility;

public abstract class AbstractProjectBuildPath {
    protected IProject project;
    private Boolean readOnly;
    private Boolean binary;

    public AbstractProjectBuildPath(IProject project) {
        this.project = project;
    }

    public void updateEGLPath() {
        try {
            EGLProject eglProject = (EGLProject)EGLCore.create(this.project);
            eglProject.getExpandedEGLPath(true, true);
        }
        catch (EGLModelException e) {
            throw new BuildException((Throwable)((Object)e));
        }
    }

    public boolean isReadOnly() {
        if (this.readOnly == null) {
            IEGLProject eglProject = EGLCore.create(this.project);
            this.readOnly = new Boolean(eglProject.isReadOnly());
        }
        return this.readOnly;
    }

    public void clearReadOnly() {
        this.readOnly = null;
    }

    public boolean isBinary() {
        if (this.binary == null) {
            IEGLProject eglProject = EGLCore.create(this.project);
            this.binary = new Boolean(eglProject.isBinary());
        }
        return this.binary;
    }

    public IContainer getOutputLocation() {
        Object outputContainer = null;
        IEGLProject eglProject = EGLCore.create(this.project);
        IPath outputLocation = eglProject.getPath().append(EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString("eglOutputFolder"));
        outputContainer = outputLocation.segmentCount() == 1 ? eglProject.getProject() : ResourcesPlugin.getWorkspace().getRoot().getFolder(outputLocation);
        return outputContainer;
    }

    public IContainer[] getSourceLocations() {
        try {
            IEGLProject eglProject = EGLCore.create(this.project);
            IPackageFragmentRoot[] packageFragmentRoots = eglProject.getPackageFragmentRoots();
            ArrayList<IContainer> sourceLocationsArr = new ArrayList<IContainer>();
            int i = 0;
            while (i < packageFragmentRoots.length) {
                if (!(packageFragmentRoots[i] instanceof JarPackageFragmentRoot)) {
                    IContainer root = (IContainer)packageFragmentRoots[i].getResource();
                    sourceLocationsArr.add(root);
                }
                ++i;
            }
            IContainer[] sourceLocations = new IContainer[sourceLocationsArr.size()];
            sourceLocationsArr.toArray(sourceLocations);
            return sourceLocations;
        }
        catch (EGLModelException e) {
            throw new BuildException("Error initializing ProjectBuildPath:SourceLocations", (Throwable)((Object)e));
        }
    }

    public IProject[] getRequiredProjects() {
        return this.getRequiredProjects(false);
    }

    private Object getProject(String projectName, boolean searchThroughExternalProjects) {
        ExternalProject extProj;
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (newProject != null && newProject.exists()) {
            return newProject;
        }
        if (searchThroughExternalProjects && (extProj = ExternalProjectManager.getInstance().getProject(projectName, this.getProject())) != null) {
            return extProj;
        }
        return newProject;
    }

    private List getRequiredProjects(ExternalProject project, List alreadySeen) {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        if (alreadySeen.contains(project) || project == null) {
            return projects;
        }
        IEGLPathEntry[] entries = project.getResolvedEGLPath();
        int i = 0;
        while (i < entries.length) {
            IProject wsProject;
            if (this.isExternalProjectEntry(entries[i])) {
                projects.addAll(this.getRequiredProjects(ExternalProjectManager.getInstance().getProject(entries[i], project.getReferencingProject()), alreadySeen));
            } else if (entries[i].getEntryKind() == 2 && (wsProject = ResourcesPlugin.getWorkspace().getRoot().getProject(entries[i].getPath().lastSegment())) != null && wsProject.exists()) {
                projects.add(wsProject);
            }
            ++i;
        }
        return projects;
    }

    public IProject[] getRequiredProjects(boolean searchThroughExternalProjects) {
        try {
            ArrayList seenExternalProjects = new ArrayList();
            IEGLProject eglProject = EGLCore.create(this.project);
            String[] requiredProjectNames = eglProject.getRequiredProjectNames(searchThroughExternalProjects);
            ArrayList<Object> requiredProjects = new ArrayList<Object>();
            int i = 0;
            while (i < requiredProjectNames.length) {
                Object reqProject = this.getProject(requiredProjectNames[i], searchThroughExternalProjects);
                if (reqProject instanceof ExternalProject) {
                    List extProjectReqires = this.getRequiredProjects((ExternalProject)reqProject, seenExternalProjects);
                    for (IProject proj : extProjectReqires) {
                        if (requiredProjects.contains(proj)) continue;
                        requiredProjects.add(proj);
                    }
                } else if (!requiredProjects.contains(reqProject)) {
                    requiredProjects.add(reqProject);
                }
                ++i;
            }
            return requiredProjects.toArray(new IProject[requiredProjects.size()]);
        }
        catch (EGLModelException e) {
            throw new BuildException("Error initializing ProjectBuildPath:RequiredProjects", (Throwable)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEGLPathBroken() {
        try {
            IMarker[] markers = this.project.findMarkers(IEGLModelMarker.BUILDPATH_PROBLEM_MARKER, false, 0);
            int i = 0;
            int l = markers.length;
            while (true) {
                if (i >= l) {
                    return false;
                }
                if ((Integer)markers[i].getAttribute("severity") == 2) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public boolean hasCycle() {
        try {
            IEGLProject eglProject = EGLCore.create(this.project);
            return eglProject.hasEGLPathCycle(eglProject.getResolvedEGLPath(true));
        }
        catch (EGLModelException e) {
            throw new BuildException((Throwable)((Object)e));
        }
    }

    public IProject[] getCycleParticipants() {
        try {
            IEGLProject eglProject = EGLCore.create(this.project);
            HashSet cycleParticipants = new HashSet();
            ((EGLProject)eglProject).updateCycleParticipants(eglProject.getResolvedEGLPath(true), new ArrayList(2), cycleParticipants, ResourcesPlugin.getWorkspace().getRoot(), new HashSet(2));
            IProject[] projects = new IProject[cycleParticipants.size()];
            Iterator iter = cycleParticipants.iterator();
            int i = 0;
            while (iter.hasNext()) {
                IPath path = (IPath)iter.next();
                IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                projects[i++] = proj;
            }
            return projects;
        }
        catch (EGLModelException e) {
            throw new BuildException((Throwable)((Object)e));
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public String toString() {
        return this.project.getName();
    }

    public void clear() {
        this.readOnly = null;
        this.binary = null;
    }

    protected void initializeEGLPathEntriesHelper(List entries, Set visitedProjects, IProject project, Object requestingProject) {
        visitedProjects.add(project);
        IEGLProject eglProject = EGLCore.create(project);
        try {
            if (((IProject)eglProject.getResource()).isOpen()) {
                IEGLPathEntry[] resolvedEGLPath = eglProject.getResolvedEGLPath(true);
                int i = 0;
                while (i < resolvedEGLPath.length) {
                    ExternalProject requiredProject;
                    if (this.isExternalProjectEntry(resolvedEGLPath[i])) {
                        if ((project == requestingProject || resolvedEGLPath[i].isExported()) && (requiredProject = ExternalProjectManager.getInstance().getProject(resolvedEGLPath[i], project)) != null && !visitedProjects.contains(requiredProject)) {
                            this.initializeEGLPathEntriesHelper(entries, visitedProjects, requiredProject, requestingProject);
                        }
                    } else if (resolvedEGLPath[i].getEntryKind() == 3) {
                        entries.add(this.getProjectBuildPathEntry(project));
                    } else if (resolvedEGLPath[i].getEntryKind() == 1) {
                        if (project == requestingProject || resolvedEGLPath[i].isExported()) {
                            entries.add(this.getZipFileBuildPathEntry(project, this.resolvePath(resolvedEGLPath[i].getPath(), project, null)));
                        }
                    } else if (resolvedEGLPath[i].getEntryKind() == 2 && (project == requestingProject || resolvedEGLPath[i].isExported()) && !visitedProjects.contains(requiredProject = ResourcesPlugin.getWorkspace().getRoot().getProject(resolvedEGLPath[i].getPath().toString()))) {
                        this.initializeEGLPathEntriesHelper(entries, visitedProjects, (IProject)requiredProject, requestingProject);
                    }
                    ++i;
                }
            }
        }
        catch (EGLModelException e) {
            throw new BuildException((Throwable)((Object)e));
        }
    }

    private IPath resolvePath(IPath path, IProject wsProject, ExternalProject extProject) {
        return new EGLProjectFileUtility().resolvePathToEGLAR(path, wsProject, extProject);
    }

    private boolean isExternalProjectEntry(IEGLPathEntry entry) {
        return entry.isBinaryProject() && entry.isExternal();
    }

    protected void initializeEGLPathEntriesHelper(List entries, Set visitedProjects, ExternalProject project, Object requestingProject) {
        visitedProjects.add(project);
        IEGLPathEntry[] resolvedEGLPath = project.getResolvedEGLPath();
        entries.add(this.getProjectBuildPathEntry(project));
        int i = 0;
        while (i < resolvedEGLPath.length) {
            ExternalProject requiredProject;
            if (this.isExternalProjectEntry(resolvedEGLPath[i])) {
                if ((project == requestingProject || resolvedEGLPath[i].isExported()) && (requiredProject = ExternalProjectManager.getInstance().getProject(resolvedEGLPath[i], project.getReferencingProject())) != null && !visitedProjects.contains(requiredProject)) {
                    this.initializeEGLPathEntriesHelper(entries, visitedProjects, requiredProject, requestingProject);
                }
            } else if (resolvedEGLPath[i].getEntryKind() == 1) {
                if (project == requestingProject || resolvedEGLPath[i].isExported()) {
                    entries.add(this.getZipFileBuildPathEntry(project, this.resolvePath(resolvedEGLPath[i].getPath(), project.getReferencingProject(), project)));
                }
            } else if (resolvedEGLPath[i].getEntryKind() == 2 && (project == requestingProject || resolvedEGLPath[i].isExported()) && !visitedProjects.contains(requiredProject = ResourcesPlugin.getWorkspace().getRoot().getProject(resolvedEGLPath[i].getPath().toString()))) {
                this.initializeEGLPathEntriesHelper(entries, visitedProjects, (IProject)requiredProject, requestingProject);
            }
            ++i;
        }
    }

    protected abstract IBuildPathEntry getProjectBuildPathEntry(ExternalProject var1);

    protected abstract IBuildPathEntry getProjectBuildPathEntry(IProject var1);

    protected abstract IBuildPathEntry getZipFileBuildPathEntry(Object var1, IPath var2);
}

