/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;
import org.eclipse.edt.ide.core.internal.lookup.FileInfo;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfo;

public class CachedFileInfoReader {
    private IPath fileInfoPath;

    public CachedFileInfoReader(IPath fileInfoPath) {
        this.fileInfoPath = fileInfoPath;
    }

    public IFileInfo read() {
        FileInfo fileInfo = new FileInfo();
        try {
            DataInputStream inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.fileInfoPath.toFile())));
            try {
                int numLines = inputStream.readInt();
                int[] lineOffsets = new int[numLines];
                int i = 0;
                while (i < numLines) {
                    lineOffsets[i] = inputStream.readInt();
                    ++i;
                }
                fileInfo.setLineOffsets(lineOffsets);
                int numParts = inputStream.readInt();
                String partName = null;
                String caseSensitivePartName = null;
                int i2 = 0;
                while (i2 < numParts) {
                    partName = inputStream.readUTF();
                    caseSensitivePartName = inputStream.readUTF();
                    int partType = inputStream.readInt();
                    int elementOffset = inputStream.readInt();
                    int elementLength = inputStream.readInt();
                    int md5KeyLength = inputStream.readInt();
                    byte[] md5Key = new byte[md5KeyLength];
                    inputStream.read(md5Key, 0, md5KeyLength);
                    fileInfo.addPart(InternUtil.intern((String)partName), partType, elementOffset, elementLength, InternUtil.internCaseSensitive((String)caseSensitivePartName), md5Key);
                    ++i2;
                }
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException e) {
            throw new BuildException("IOException", (Throwable)e);
        }
        return fileInfo;
    }
}

