/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.io.ZipFileBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProject;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.utils.AbsolutePathUtility;
import org.eclipse.edt.mof.serialization.IZipFileEntryManager;

public class EclipseZipFileBuildPathEntry
extends ZipFileBuildPathEntry
implements IZipFileEntryManager {
    private IPath path = null;
    private Object project;

    public EclipseZipFileBuildPathEntry(Object project, IPath path) {
        super(AbsolutePathUtility.getAbsolutePathString(path));
        this.path = path;
        this.project = project;
        this.processEntries();
    }

    public IPath getZipFilePath() {
        return this.path;
    }

    public IPartBinding getPartBinding(String[] packageName, String partName) {
        IPartBinding retVal = super.getPartBinding(packageName, partName);
        if (retVal != null) {
            retVal.setEnvironment(this.getEnvironment());
        }
        return retVal;
    }

    protected IEnvironment getEnvironment() {
        if (this.getProject() instanceof IProject) {
            return ProjectEnvironmentManager.getInstance().getProjectEnvironment((IProject)this.getProject());
        }
        return ExternalProjectEnvironmentManager.getInstance().getProjectEnvironment((ExternalProject)this.getProject());
    }

    public Object getProject() {
        return this.project;
    }

    public boolean hasEntry(String entry) {
        entry = entry.toUpperCase().toLowerCase();
        String[] entries = this.getAllEntries();
        int i = 0;
        while (i < entries.length) {
            if (entry.equals(entries[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

