/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.EGLPathEntry;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.utils.FileContentsUtility;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ExternalProject {
    String name;
    String installLocation;
    IEGLPathEntry[] pathEntries;
    private IProject referencingProject;

    public ExternalProject(String name, String installLocation) {
        this.name = name;
        this.installLocation = installLocation;
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.installLocation;
    }

    public IEGLPathEntry[] getResolvedEGLPath() {
        if (this.pathEntries != null) {
            return this.pathEntries;
        }
        this.pathEntries = this.primGetResolvedEGLPath();
        return this.pathEntries;
    }

    private IEGLPathEntry[] primGetResolvedEGLPath() {
        if (this.installLocation == null) {
            return new IEGLPathEntry[0];
        }
        String fileName = String.valueOf(this.installLocation) + File.separator + ".eglPath";
        try {
            String contents = this.getFileContents(fileName);
            IEGLPathEntry[] entries = this.decodeEGLPath(contents);
            return this.getResolvedEGLPath(entries);
        }
        catch (Exception e) {
            e.printStackTrace();
            Util.log(e, "Exception while reading " + this.installLocation + "/.eglpath, will mark eglpath as invalid");
            return new IEGLPathEntry[0];
        }
    }

    public IEGLPathEntry[] getResolvedEGLPath(IEGLPathEntry[] eglpathEntries) {
        int length = eglpathEntries.length;
        ArrayList<IEGLPathEntry> resolvedEntries = new ArrayList<IEGLPathEntry>();
        int i = 0;
        while (i < length) {
            IEGLPathEntry rawEntry = eglpathEntries[i];
            switch (rawEntry.getEntryKind()) {
                case 4: {
                    IEGLPathEntry resolvedEntry = EGLCore.getResolvedEGLPathEntry(rawEntry);
                    if (resolvedEntry == null) break;
                    resolvedEntries.add(resolvedEntry);
                    break;
                }
                case 5: {
                    resolvedEntries.add(rawEntry);
                    break;
                }
                case 1: {
                    IEGLPathEntry resolvedEntry = ((EGLPathEntry)rawEntry).resolvedDotDot();
                    if (resolvedEntry == null) break;
                    resolvedEntries.add(resolvedEntry);
                    break;
                }
                default: {
                    resolvedEntries.add(rawEntry);
                }
            }
            ++i;
        }
        IEGLPathEntry[] resolvedPath = new IEGLPathEntry[resolvedEntries.size()];
        resolvedEntries.toArray(resolvedPath);
        return resolvedPath;
    }

    private String getFileContents(String fileName) throws Exception {
        return FileContentsUtility.getFileContentsFromXML(fileName);
    }

    private IEGLPathEntry[] decodeEGLPath(String xmlPath) {
        IEGLPathEntry defaultOutput;
        ArrayList<IEGLPathEntry> paths;
        block17: {
            paths = new ArrayList<IEGLPathEntry>();
            defaultOutput = null;
            if (xmlPath != null) break block17;
            return null;
        }
        try {
            Element cpElement;
            StringReader reader = new StringReader(xmlPath);
            try {
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
                }
                catch (SAXException sAXException) {
                    throw new IOException(EGLModelResources.fileBadFormat);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new IOException(EGLModelResources.fileBadFormat);
                }
            }
            finally {
                reader.close();
            }
            if (!cpElement.getNodeName().equalsIgnoreCase("eglpath")) {
                throw new IOException(EGLModelResources.fileBadFormat);
            }
            NodeList list = cpElement.getElementsByTagName("eglpathentry");
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                IEGLPathEntry entry;
                Node node = list.item(i);
                if (node.getNodeType() == 1 && (entry = EGLPathEntry.elementDecode((Element)node, (IPath)new Path("/" + this.name), this.name)) != null) {
                    if (entry.getContentKind() == 10) {
                        defaultOutput = entry;
                    } else {
                        paths.add(entry);
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            Util.log(e, "Exception while retrieving " + this.installLocation + "/.eglpath, will mark eglpath as invalid");
            return new IEGLPathEntry[0];
        }
        catch (Exception e) {
            Util.log(e, "Exception while retrieving " + this.installLocation + "/.eglpath, will mark eglpath as invalid");
            return new IEGLPathEntry[0];
        }
        int pathSize = paths.size();
        if (pathSize > 0 || defaultOutput != null) {
            IEGLPathEntry[] entries = new IEGLPathEntry[pathSize + (defaultOutput == null ? 0 : 1)];
            paths.toArray(entries);
            if (defaultOutput != null) {
                entries[pathSize] = defaultOutput;
            }
            return entries;
        }
        return null;
    }

    public IProject getReferencingProject() {
        return this.referencingProject;
    }

    public void setReferencingProject(IProject referencingProject) {
        this.referencingProject = referencingProject;
    }
}

