/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.lookup.IBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.AbstractProjectBuildPath;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProject;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.ZipFileBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.IWorkingCopyBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyZipFileBuildPathEntry;

public class ExternalProjectBuildPath
extends AbstractProjectBuildPath {
    ExternalProject extProject;
    boolean isWCC;

    public ExternalProjectBuildPath(ExternalProject project, boolean isWCC) {
        super(null);
        this.extProject = project;
        this.isWCC = isWCC;
    }

    @Override
    protected IBuildPathEntry getProjectBuildPathEntry(IProject project) {
        if (this.isWCC) {
            return WorkingCopyProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(project);
        }
        return ProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(project);
    }

    @Override
    protected IBuildPathEntry getZipFileBuildPathEntry(Object project, IPath zipFilePath) {
        if (this.isWCC) {
            return new WorkingCopyZipFileBuildPathEntry(project, zipFilePath);
        }
        return ZipFileBuildPathEntryManager.getInstance().getZipFileBuildPathEntry(project, zipFilePath);
    }

    public IBuildPathEntry[] getBuildPathEntries() {
        if (this.isWCC) {
            ArrayList projectInfoEnvironments = new ArrayList();
            this.initializeEGLPathEntriesHelper(projectInfoEnvironments, new HashSet(), this.extProject, (Object)this.extProject);
            return projectInfoEnvironments.toArray(new IWorkingCopyBuildPathEntry[projectInfoEnvironments.size()]);
        }
        ArrayList projectInfoEnvironments = new ArrayList();
        this.initializeEGLPathEntriesHelper(projectInfoEnvironments, new HashSet(), this.extProject, (Object)this.extProject);
        return projectInfoEnvironments.toArray(new IBuildPathEntry[projectInfoEnvironments.size()]);
    }

    @Override
    protected IBuildPathEntry getProjectBuildPathEntry(ExternalProject project) {
        if (this.isWCC) {
            return ExternalProjectBuildPathEntryManager.getWCCInstance().getProjectBuildPathEntry(project);
        }
        return ExternalProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(project);
    }

    @Override
    public void updateEGLPath() {
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public IContainer getOutputLocation() {
        return null;
    }

    @Override
    public IContainer[] getSourceLocations() {
        return new IContainer[0];
    }

    @Override
    public IProject[] getRequiredProjects() {
        return new IProject[0];
    }

    @Override
    public boolean isEGLPathBroken() {
        return false;
    }

    @Override
    public boolean hasCycle() {
        return false;
    }

    @Override
    public IProject[] getCycleParticipants() {
        return new IProject[0];
    }

    @Override
    public String toString() {
        return this.project.getName();
    }
}

