/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import org.eclipse.core.resources.IFile;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.EGLAliasJsfNamesSetting;
import org.eclipse.edt.compiler.internal.EGLVAGCompatibilitySetting;
import org.eclipse.edt.compiler.internal.core.compiler.BindingCompletor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.NullDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.BindingCreator;
import org.eclipse.edt.compiler.internal.core.lookup.EnvironmentScope;
import org.eclipse.edt.compiler.internal.core.lookup.IBuildPathEntry;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;
import org.eclipse.edt.compiler.internal.core.utils.PartBindingCache;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProject;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.IWorkingCopyBuildPathEntry;
import org.eclipse.edt.ide.core.internal.partinfo.IPartOrigin;

public class ExternalProjectBuildPathEntry
implements IBuildPathEntry,
IWorkingCopyBuildPathEntry {
    ExternalProject project;
    private PartBindingCache fileBindingCache = new PartBindingCache();
    private IEnvironment declaringEnvironment;

    public ExternalProjectBuildPathEntry(ExternalProject project) {
        this.project = project;
    }

    public void setDeclaringEnvironment(IEnvironment declaringEnvironment) {
        this.declaringEnvironment = declaringEnvironment;
    }

    public String getID() {
        return this.project.getName();
    }

    public IPartBinding getPartBinding(String[] packageName, String partName) {
        return null;
    }

    public IPartBinding getCachedPartBinding(String[] packageName, String partName) {
        return null;
    }

    public IEnvironment getRealizingEnvironment() {
        return null;
    }

    public boolean hasPackage(String[] packageName) {
        return false;
    }

    public int hasPart(String[] packageName, String partName) {
        return 0;
    }

    public boolean isProject() {
        return true;
    }

    public boolean isZipFile() {
        return false;
    }

    @Override
    public IPartOrigin getPartOrigin(String[] packageName, String partName) {
        return new IPartOrigin(){

            @Override
            public IFile getEGLFile() {
                return null;
            }

            @Override
            public boolean isOriginEGLFile() {
                return false;
            }

            @Override
            public boolean isSourceCodeAvailable() {
                return false;
            }

            public String getSourcePath() {
                return null;
            }
        };
    }

    public ExternalProject getProject() {
        return this.project;
    }

    public FileBinding getFileBinding(String[] packageName, String fileName, File fileAST) {
        String caseInsensitiveInternedFileName = InternUtil.intern((String)fileName);
        FileBinding fileBinding = this.getFileBindingFromCache(packageName, caseInsensitiveInternedFileName);
        if (fileBinding != null) {
            return fileBinding;
        }
        fileBinding = (FileBinding)new BindingCreator(this.declaringEnvironment, packageName, caseInsensitiveInternedFileName, (Node)fileAST).getPartBinding();
        fileBinding.setEnvironment(this.declaringEnvironment);
        EnvironmentScope scope = new EnvironmentScope(this.declaringEnvironment, (IDependencyRequestor)NullDependencyRequestor.getInstance());
        BindingCompletor.getInstance().completeBinding((Node)fileAST, (IPartBinding)fileBinding, (Scope)scope, new ICompilerOptions(){

            public boolean isVAGCompatible() {
                return EGLVAGCompatibilitySetting.isVAGCompatibility();
            }

            public boolean isAliasJSFNames() {
                return EGLAliasJsfNamesSetting.isAliasJsfNames();
            }
        });
        this.fileBindingCache.put(packageName, caseInsensitiveInternedFileName, (IPartBinding)fileBinding);
        return fileBinding;
    }

    public void clear() {
        this.fileBindingCache = new PartBindingCache();
    }

    public FileBinding getFileBindingFromCache(String[] packageName, String partName) {
        return (FileBinding)this.fileBindingCache.get(packageName, partName);
    }

    public IPartBinding getNewPartBinding(String[] packageName, String caseSensitiveInternedPartName, int kind) {
        if (kind != 16) {
            throw new UnsupportedOperationException("ExternalProjectBuildPathEntry.getNewPartBinding : invalid part type");
        }
        String caseInsensitiveInternedPartName = InternUtil.intern((String)caseSensitiveInternedPartName);
        FileBinding fileBinding = (FileBinding)this.fileBindingCache.get(packageName, caseInsensitiveInternedPartName);
        if (fileBinding == null) {
            fileBinding = (FileBinding)PartBinding.newPartBinding((int)kind, (String[])packageName, (String)caseSensitiveInternedPartName);
            this.fileBindingCache.put(packageName, caseInsensitiveInternedPartName, (IPartBinding)fileBinding);
        } else {
            fileBinding.clear();
        }
        return fileBinding;
    }
}

