/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProject;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathEntry;

public class ExternalProjectBuildPathEntryManager {
    private static final ExternalProjectBuildPathEntryManager INSTANCE = new ExternalProjectBuildPathEntryManager(false);
    private static final ExternalProjectBuildPathEntryManager WCC_INSTANCE = new ExternalProjectBuildPathEntryManager(true);
    private Map projectBuildPathEntries;
    private boolean isWCC;

    private ExternalProjectBuildPathEntryManager(boolean isWCC) {
        this.isWCC = isWCC;
        this.init();
    }

    private void init() {
        this.projectBuildPathEntries = new HashMap();
    }

    public static ExternalProjectBuildPathEntryManager getInstance() {
        return INSTANCE;
    }

    public static ExternalProjectBuildPathEntryManager getWCCInstance() {
        return WCC_INSTANCE;
    }

    public ExternalProjectBuildPathEntry getProjectBuildPathEntry(ExternalProject project) {
        ExternalProjectBuildPathEntry result = (ExternalProjectBuildPathEntry)this.projectBuildPathEntries.get(project);
        if (result == null) {
            result = new ExternalProjectBuildPathEntry(project);
            this.projectBuildPathEntries.put(project, result);
        }
        IEnvironment env = this.isWCC ? ExternalProjectEnvironmentManager.getWCCInstance().getProjectEnvironment(project) : ExternalProjectEnvironmentManager.getInstance().getProjectEnvironment(project);
        result.setDeclaringEnvironment(env);
        return result;
    }

    public void remove(IProject project) {
        this.projectBuildPathEntries.remove(project);
    }

    public void clear(IProject project) {
        ProjectBuildPathEntry result = (ProjectBuildPathEntry)this.projectBuildPathEntries.get(project);
        if (result != null) {
            result.clear();
        }
    }

    public void clearAll() {
        this.projectBuildPathEntries.clear();
    }

    public int getCount() {
        return this.projectBuildPathEntries.size();
    }

    protected static void clear() {
        INSTANCE.clearAll();
        WCC_INSTANCE.clearAll();
    }
}

