/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.util.HashMap;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProject;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectBuildPath;

public class ExternalProjectBuildPathManager {
    private static ExternalProjectBuildPathManager INSTANCE = new ExternalProjectBuildPathManager(false);
    private static ExternalProjectBuildPathManager WCC_INSTANCE = new ExternalProjectBuildPathManager(true);
    private boolean isWCC;
    private HashMap projectBuildPathMap = new HashMap(5);

    public static ExternalProjectBuildPathManager getInstance() {
        return INSTANCE;
    }

    public static ExternalProjectBuildPathManager getWCCInstance() {
        return WCC_INSTANCE;
    }

    private ExternalProjectBuildPathManager(boolean isWCC) {
        this.isWCC = isWCC;
    }

    public ExternalProjectBuildPath getProjectBuildPath(ExternalProject project) {
        ExternalProjectBuildPath prjBuildPath = (ExternalProjectBuildPath)this.projectBuildPathMap.get(project);
        if (prjBuildPath == null) {
            prjBuildPath = new ExternalProjectBuildPath(project, this.isWCC);
            this.projectBuildPathMap.put(project, prjBuildPath);
        }
        return prjBuildPath;
    }

    public void clear(ExternalProject project) {
        ExternalProjectBuildPath prjBuildPath = (ExternalProjectBuildPath)this.projectBuildPathMap.get(project);
        if (prjBuildPath != null) {
            prjBuildPath.clear();
        }
    }

    public void remove(ExternalProject project) {
        this.projectBuildPathMap.remove(project);
    }

    protected void clearAll() {
        this.projectBuildPathMap.clear();
    }

    protected static void clear() {
        INSTANCE.clearAll();
        WCC_INSTANCE.clearAll();
    }

    public int getCount() {
        return this.projectBuildPathMap.size();
    }
}

