/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import org.eclipse.edt.compiler.SystemEnvironment;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.PackageBinding;
import org.eclipse.edt.compiler.internal.core.lookup.IBuildPathEntry;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;
import org.eclipse.edt.ide.core.internal.lookup.AbstractProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProject;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectBuildPath;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.partinfo.IPartOrigin;

public class ExternalProjectEnvironment
extends AbstractProjectEnvironment {
    public static final String[] defaultPackage = InternUtil.intern((String[])new String[0]);
    private ExternalProject project;
    private ExternalProjectBuildPathEntry declaringProjectBuildPathEntry;
    private IBuildPathEntry[] buildPathEntries;
    private PackageBinding rootPackageBinding = new PackageBinding(defaultPackage, null, (IEnvironment)this);
    private boolean isWCC;

    protected ExternalProjectEnvironment(ExternalProject project, boolean isWCC) {
        this.isWCC = isWCC;
        this.project = project;
    }

    protected void setProjectBuildPathEntries(IBuildPathEntry[] projectBuildPathEntries) {
        this.buildPathEntries = projectBuildPathEntries;
    }

    protected void setDeclaringProjectBuildPathEntry(ExternalProjectBuildPathEntry entry) {
        this.declaringProjectBuildPathEntry = entry;
    }

    public ExternalProjectBuildPathEntry getDeclaringProjectBuildPathEntry() {
        return this.declaringProjectBuildPathEntry;
    }

    public IPartBinding getPartBinding(String[] packageName, String partName) {
        IPartBinding result = null;
        int i = 0;
        while (i < this.buildPathEntries.length) {
            result = this.buildPathEntries[i].getPartBinding(packageName, partName);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return SystemEnvironment.getInstance().getPartBinding(packageName, partName);
    }

    public IPartBinding getNewPartBinding(String[] packageName, String caseSensitiveInternedPartName, int kind) {
        return this.declaringProjectBuildPathEntry.getNewPartBinding(packageName, caseSensitiveInternedPartName, kind);
    }

    public boolean hasPackage(String[] packageName) {
        int i = 0;
        while (i < this.buildPathEntries.length) {
            if (this.buildPathEntries[i].hasPackage(packageName)) {
                return true;
            }
            ++i;
        }
        return SystemEnvironment.getInstance().hasPackage(packageName);
    }

    public IPackageBinding getRootPackage() {
        return this.rootPackageBinding;
    }

    public void clearRootPackage() {
        this.rootPackageBinding = new PackageBinding(defaultPackage, null, (IEnvironment)this);
    }

    public ExternalProject getProject() {
        return this.project;
    }

    public void clear() {
        this.buildPathEntries = null;
        ExternalProjectBuildPath projectBuildPath = this.isWCC ? ExternalProjectBuildPathManager.getWCCInstance().getProjectBuildPath(this.project) : ExternalProjectBuildPathManager.getInstance().getProjectBuildPath(this.project);
        this.buildPathEntries = projectBuildPath.getBuildPathEntries();
    }

    public IPartOrigin getPartOrigin(String[] packageName, String partName) {
        return null;
    }

    public IPartBinding level01Compile(String[] packageName, String caseSensitiveInternedPartName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getProjectName() {
        return this.getProject().getName();
    }
}

