/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.compiler.internal.core.lookup.IBuildPathEntry;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProject;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectBuildPath;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectEnvironment;

public class ExternalProjectEnvironmentManager {
    private Map projectEnvironments;
    private static final ExternalProjectEnvironmentManager INSTANCE = new ExternalProjectEnvironmentManager(false);
    private static final ExternalProjectEnvironmentManager WCC_INSTANCE = new ExternalProjectEnvironmentManager(true);
    private boolean isWCC;

    private ExternalProjectEnvironmentManager(boolean isWCC) {
        this.isWCC = isWCC;
        this.init();
    }

    public static ExternalProjectEnvironmentManager getInstance() {
        return INSTANCE;
    }

    public static ExternalProjectEnvironmentManager getWCCInstance() {
        return WCC_INSTANCE;
    }

    public void clearAll() {
        this.init();
    }

    protected static void clear() {
        INSTANCE.clearAll();
        WCC_INSTANCE.clearAll();
    }

    public void clear(ExternalProject project) {
        ExternalProjectEnvironment result = (ExternalProjectEnvironment)this.projectEnvironments.get(project);
        if (result != null) {
            result.clear();
        }
    }

    public void remove(ExternalProject project) {
        this.projectEnvironments.remove(project);
    }

    private void init() {
        this.projectEnvironments = new HashMap();
    }

    public IEnvironment getProjectEnvironment(ExternalProject project) {
        ExternalProjectEnvironment result = (ExternalProjectEnvironment)this.projectEnvironments.get(project);
        if (result == null) {
            result = new ExternalProjectEnvironment(project, this.isWCC);
            this.projectEnvironments.put(project, result);
            result.setProjectBuildPathEntries(this.getProjectBuildPathEntriesFor(project));
            result.setDeclaringProjectBuildPathEntry(ExternalProjectBuildPathEntryManager.getInstance().getProjectBuildPathEntry(project));
        }
        return result;
    }

    private IBuildPathEntry[] getProjectBuildPathEntriesFor(ExternalProject project) {
        ExternalProjectBuildPath projectBuildPath = this.isWCC ? ExternalProjectBuildPathManager.getWCCInstance().getProjectBuildPath(project) : ExternalProjectBuildPathManager.getInstance().getProjectBuildPath(project);
        return projectBuildPath.getBuildPathEntries();
    }

    public int getCount() {
        return this.projectEnvironments.size();
    }
}

