/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;
import org.eclipse.edt.ide.core.Logger;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProject;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.ExternalProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPath;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.IProjectsChangedListener;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.model.bde.ExternalPluginModel;
import org.eclipse.edt.ide.core.internal.model.bde.IPluginModelListener;
import org.eclipse.edt.ide.core.internal.model.bde.PluginModelDelta;
import org.eclipse.edt.ide.core.internal.requestors.IDECommandRequestor;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.bde.IPluginModelBase;
import org.eclipse.edt.ide.core.model.bde.PluginRegistry;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JavaProject;

public class ExternalProjectManager
implements IPluginModelListener,
IProjectsChangedListener {
    private static ExternalProjectManager instance = new ExternalProjectManager();
    private HashMap projects = new HashMap();

    private ExternalProjectManager() {
        EGLModelManager.getEGLModelManager().deltaProcessor.addProjectsChangedListener(this);
    }

    public static ExternalProjectManager getInstance() {
        return instance;
    }

    public ExternalProject getProject(IEGLPathEntry entry, IProject wsProject) {
        return this.getProject(this.getProjectName(entry), wsProject);
    }

    public String getProjectName(IEGLPathEntry entry) {
        return Util.getExternalProjectName(entry);
    }

    public ExternalProject getProject(String str, IProject wsProject) {
        String name = InternUtil.intern((String)str);
        ExternalProject proj = (ExternalProject)this.projects.get(name);
        if (proj == null) {
            IPluginModelBase model = this.getModel(str);
            if (model == null) {
                return null;
            }
            proj = new ExternalProject(str, model.getInstallLocation());
            proj.setReferencingProject(wsProject);
            this.projects.put(name, proj);
        }
        return proj;
    }

    private IPluginModelBase getModel(String name) {
        IPluginModelBase[] models = this.getModels();
        int i = 0;
        while (i < models.length) {
            if (models[i] instanceof ExternalPluginModel && name.equalsIgnoreCase(this.getProjectName(models[i]))) {
                return models[i];
            }
            ++i;
        }
        return null;
    }

    private IPluginModelBase[] getModels() {
        return PluginRegistry.getActiveModels();
    }

    private String getProjectName(IPluginModelBase model) {
        String str = model.getInstallLocation();
        Path path = new Path(str);
        return path.lastSegment();
    }

    public void removeProject(ExternalProject proj) {
        this.removeProject(proj.getName());
    }

    public void removeProject(String name) {
        this.projects.remove(InternUtil.intern((String)name));
    }

    public void removeAll() {
        this.projects = new HashMap();
    }

    private void setDynamicProjectReferences() {
        this.clearEverything();
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects(8);
        int i = 0;
        while (i < allProjects.length) {
            IProject project = allProjects[i];
            if (project.isAccessible()) {
                try {
                    this.setDynamicProjectReferences(project);
                }
                catch (Exception exception) {}
            }
            ++i;
        }
    }

    private boolean isEGLProject(IProject project) {
        return IDECommandRequestor.isEGLProject(project);
    }

    private boolean isPluginProject(IProject project) {
        return IDECommandRequestor.isPluginProject(project);
    }

    private void setDynamicProjectReferences(IProject project) {
        if (this.getModels() == null || this.getModels().length == 0) {
            return;
        }
        if (!this.isEGLProject(project)) {
            return;
        }
        ArrayList<IProject> dynList = new ArrayList<IProject>();
        dynList.addAll(this.getCurrentDynamicProjectReferences(project));
        ProjectBuildPath projBP = ProjectBuildPathManager.getInstance().getProjectBuildPath(project);
        IProject[] reqProjects = projBP.getRequiredProjects(true);
        List curList = this.getCurrentProjectReferences(project);
        int i = 0;
        while (i < reqProjects.length) {
            if (!curList.contains(reqProjects[i]) && !dynList.contains(reqProjects[i]) && reqProjects[i] != project) {
                dynList.add(reqProjects[i]);
            }
            ++i;
        }
        try {
            IProjectDescription desc = project.getDescription();
            if (desc != null) {
                desc.setDynamicReferences(dynList.toArray(new IProject[dynList.size()]));
                this.setProjectDescription(project, desc);
            }
        }
        catch (CoreException e) {
            Logger.log("ExternalProjectManager.setDynamicProjectReferences", "Error when updating the dynamic project references.", e);
        }
    }

    private void setProjectDescription(final IProject project, final IProjectDescription description) {
        IWorkspace workspace = project.getWorkspace();
        ISchedulingRule rule = workspace.getRuleFactory().modifyRule((IResource)project);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.setDescription(description, 64, null);
            }
        };
        try {
            workspace.run(runnable, rule, 1, null);
        }
        catch (CoreException e) {
            Logger.log("ExternalProjectManager.setProjectDescription", "Error when updating the dynamic project references.", e);
        }
    }

    private List getCurrentDynamicProjectReferences(IProject project) {
        ArrayList<IProject> list = new ArrayList<IProject>();
        if (!this.isPluginProject(project)) {
            return list;
        }
        try {
            IProjectDescription desc;
            IJavaProject ijp = JavaCore.create((IProject)project);
            if (ijp != null && ijp.exists() && ijp instanceof JavaProject) {
                JavaProject javaProject = (JavaProject)ijp;
                IClasspathEntry[] newResolvedClasspath = javaProject.getResolvedClasspath();
                javaProject.projectPrerequisites(newResolvedClasspath);
            }
            if ((desc = project.getDescription()) == null) {
                return list;
            }
            IProject[] projects = desc.getDynamicReferences();
            int i = 0;
            while (i < projects.length) {
                list.add(projects[i]);
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return list;
    }

    private List getCurrentProjectReferences(IProject project) {
        ArrayList<IProject> list = new ArrayList<IProject>();
        try {
            IProjectDescription desc = project.getDescription();
            if (desc == null) {
                return list;
            }
            IProject[] projects = desc.getReferencedProjects();
            int i = 0;
            while (i < projects.length) {
                list.add(projects[i]);
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return list;
    }

    @Override
    public void modelsChanged(PluginModelDelta delta) {
        this.setDynamicProjectReferences();
    }

    @Override
    public void projectsChanged(IProject[] projects) {
        this.setDynamicProjectReferences();
    }

    public void clearAll() {
        this.projects.clear();
    }

    public void clearEverything() {
        this.clearAll();
        ExternalProjectBuildPathManager.clear();
        ExternalProjectBuildPathEntryManager.clear();
        ExternalProjectEnvironmentManager.getInstance().clearAll();
    }
}

