/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.SystemEnvironment;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.EGLAliasJsfNamesSetting;
import org.eclipse.edt.compiler.internal.EGLVAGCompatibilitySetting;
import org.eclipse.edt.compiler.internal.core.builder.AbstractProcessingQueue;
import org.eclipse.edt.compiler.internal.core.compiler.BindingCompletor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.NullDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.BindingCreator;
import org.eclipse.edt.compiler.internal.core.lookup.EnvironmentScope;
import org.eclipse.edt.compiler.internal.core.lookup.FileASTScope;
import org.eclipse.edt.compiler.internal.core.lookup.FileScope;
import org.eclipse.edt.compiler.internal.core.lookup.IBuildPathEntry;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.lookup.SystemScope;
import org.eclipse.edt.compiler.internal.core.utils.InternUtil;
import org.eclipse.edt.compiler.internal.core.utils.PartBindingCache;
import org.eclipse.edt.ide.core.internal.binding.BinaryFileManager;
import org.eclipse.edt.ide.core.internal.builder.ASTManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfo;
import org.eclipse.edt.ide.core.internal.utils.Util;

public class ProjectBuildPathEntry
implements IBuildPathEntry {
    private ProjectInfo projectInfo;
    private PartBindingCache bindingCache = new PartBindingCache();
    private AbstractProcessingQueue processingQueue;
    private ProjectEnvironment declaringEnvironment;
    private IEnvironment realizingEnvironment;

    protected ProjectBuildPathEntry(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
        this.realizingEnvironment = new RealizingEnvironment();
    }

    protected void setDeclaringEnvironment(ProjectEnvironment projectEnvironment) {
        this.declaringEnvironment = projectEnvironment;
    }

    public void setProcessingQueue(AbstractProcessingQueue processingQueue) {
        this.processingQueue = processingQueue;
    }

    public int hasPart(String[] packageName, String partName) {
        return this.projectInfo.hasPart(packageName, partName);
    }

    public boolean hasPackage(String[] packageName) {
        return this.projectInfo.hasPackage(packageName);
    }

    public IPartBinding getPartBindingFromCache(String[] packageName, String partName) {
        return this.bindingCache.get(packageName, partName);
    }

    public IPartBinding getPartBinding(String[] packageName, String partName) {
        return this.getPartBinding(packageName, partName, false);
    }

    public IPartBinding getPartBinding(String[] packageName, String partName, boolean force) {
        if (ProjectBuildPathManager.getInstance().getProjectBuildPath(this.projectInfo.getProject()).isBinary()) {
            return null;
        }
        IPartBinding result = null;
        if (this.processingQueue != null) {
            result = this.processingQueue.requestCompilationFor(packageName, partName, force);
        }
        if (result == null) {
            result = this.bindingCache.get(packageName, partName);
            if (result != null) {
                return result;
            }
            if (ProjectBuildPathManager.getInstance().getProjectBuildPath(this.projectInfo.getProject()).isReadOnly()) {
                return this.readPartBinding(packageName, partName);
            }
            if (this.projectInfo.hasPart(packageName, partName) != 1) {
                IFile declaringFile = this.projectInfo.getPartOrigin(packageName, partName).getEGLFile();
                if (Util.getFilePartName(declaringFile) == partName || this.projectInfo.hasPart(packageName, partName) == 20) {
                    return this.compileLevel2Binding(packageName, this.projectInfo.getCaseSensitivePartName(packageName, partName));
                }
                return this.readPartBinding(packageName, partName);
            }
            return null;
        }
        return result;
    }

    public IPartBinding getNewPartBinding(String[] packageName, String caseSensitiveInternedPartName, int kind) {
        String caseInsensitiveInternedPartName = InternUtil.intern((String)caseSensitiveInternedPartName);
        IPartBinding partBinding = this.bindingCache.get(packageName, caseInsensitiveInternedPartName);
        if (partBinding == null || partBinding.getKind() != kind) {
            partBinding = PartBinding.newPartBinding((int)kind, (String[])packageName, (String)caseSensitiveInternedPartName);
            this.bindingCache.put(packageName, caseInsensitiveInternedPartName, partBinding);
        } else {
            partBinding.clear();
        }
        return partBinding;
    }

    private IPartBinding readPartBinding(String[] packageName, String partName) {
        IPartBinding partBinding = BinaryFileManager.getInstance().readPartBinding(packageName, partName, this.projectInfo.getProject());
        if (partBinding != null) {
            partBinding.setValid(true);
            partBinding.setEnvironment((IEnvironment)this.declaringEnvironment);
            this.bindingCache.put(packageName, partName, partBinding);
        }
        return partBinding;
    }

    public IPartBinding compileLevel2Binding(String[] packageName, String caseSensitiveInternedPartName) {
        String fileName;
        IPartBinding fileBinding;
        String caseInsensitiveInternedPartName = InternUtil.intern((String)caseSensitiveInternedPartName);
        IFile declaringFile = this.projectInfo.getPartOrigin(packageName, caseInsensitiveInternedPartName).getEGLFile();
        Node partAST = ASTManager.getInstance().getAST(declaringFile, caseInsensitiveInternedPartName);
        IPartBinding partBinding = new BindingCreator((IEnvironment)this.declaringEnvironment, packageName, caseSensitiveInternedPartName, partAST).getPartBinding();
        partBinding.setEnvironment((IEnvironment)this.declaringEnvironment);
        Object scope = partBinding.getKind() == 16 ? new EnvironmentScope((IEnvironment)this.declaringEnvironment, (IDependencyRequestor)NullDependencyRequestor.getInstance()) : (!(fileBinding = this.getPartBinding(packageName, fileName = Util.getFilePartName(declaringFile), true)).isValid() ? new SystemScope((Scope)new FileASTScope((Scope)new EnvironmentScope((IEnvironment)this.declaringEnvironment, (IDependencyRequestor)NullDependencyRequestor.getInstance()), (FileBinding)fileBinding, ASTManager.getInstance().getFileAST(declaringFile)), (IEnvironment)SystemEnvironment.getInstance()) : new SystemScope((Scope)new FileScope((Scope)new EnvironmentScope((IEnvironment)this.declaringEnvironment, (IDependencyRequestor)NullDependencyRequestor.getInstance()), (FileBinding)fileBinding, (IDependencyRequestor)NullDependencyRequestor.getInstance()), (IEnvironment)SystemEnvironment.getInstance()));
        BindingCompletor.getInstance().completeBinding(partAST, partBinding, (Scope)scope, new ICompilerOptions(){

            public boolean isVAGCompatible() {
                return EGLVAGCompatibilitySetting.isVAGCompatibility();
            }

            public boolean isAliasJSFNames() {
                return EGLAliasJsfNamesSetting.isAliasJsfNames();
            }
        });
        this.bindingCache.put(packageName, caseInsensitiveInternedPartName, partBinding);
        return partBinding;
    }

    protected void markPartBindingInvalid(String[] packageName, String partName) {
        IPartBinding result = this.bindingCache.get(packageName, partName);
        if (result != null) {
            result.setValid(false);
        }
    }

    public void removePartBindingInvalid(String[] packageName, String partName) {
        this.bindingCache.remove(packageName, partName);
    }

    public IProject getProject() {
        return this.projectInfo.getProject();
    }

    public IEnvironment getRealizingEnvironment() {
        return this.realizingEnvironment;
    }

    public void clear() {
        this.bindingCache = new PartBindingCache();
    }

    public boolean isZipFile() {
        return false;
    }

    public boolean isProject() {
        return true;
    }

    public String getID() {
        return this.getProject().getName();
    }

    public FileBinding getFileBinding(String[] packageName, String fileName, File fileAST) {
        String caseInsensitiveInternedFileName = InternUtil.intern((String)fileName);
        FileBinding fileBinding = this.getFileBindingFromCache(packageName, caseInsensitiveInternedFileName);
        if (fileBinding != null) {
            return fileBinding;
        }
        fileBinding = (FileBinding)new BindingCreator((IEnvironment)this.declaringEnvironment, packageName, caseInsensitiveInternedFileName, (Node)fileAST).getPartBinding();
        fileBinding.setEnvironment((IEnvironment)this.declaringEnvironment);
        EnvironmentScope scope = new EnvironmentScope((IEnvironment)this.declaringEnvironment, (IDependencyRequestor)NullDependencyRequestor.getInstance());
        BindingCompletor.getInstance().completeBinding((Node)fileAST, (IPartBinding)fileBinding, (Scope)scope, new ICompilerOptions(){

            public boolean isVAGCompatible() {
                return EGLVAGCompatibilitySetting.isVAGCompatibility();
            }

            public boolean isAliasJSFNames() {
                return EGLAliasJsfNamesSetting.isAliasJsfNames();
            }
        });
        this.bindingCache.put(packageName, caseInsensitiveInternedFileName, (IPartBinding)fileBinding);
        return fileBinding;
    }

    public FileBinding getFileBindingFromCache(String[] packageName, String partName) {
        return (FileBinding)this.bindingCache.get(packageName, partName);
    }

    public IPartBinding getCachedPartBinding(String[] packageName, String partName) {
        return this.getPartBindingFromCache(packageName, partName);
    }

    private class RealizingEnvironment
    implements IEnvironment {
        private RealizingEnvironment() {
        }

        public IPartBinding getPartBinding(String[] packageName, String partName) {
            return ProjectBuildPathEntry.this.getPartBinding(packageName, partName, true);
        }

        public IPartBinding getNewPartBinding(String[] packageName, String caseSensitiveInternedPartName, int kind) {
            return ProjectBuildPathEntry.this.getNewPartBinding(packageName, caseSensitiveInternedPartName, kind);
        }

        public boolean hasPackage(String[] packageName) {
            return ProjectBuildPathEntry.this.hasPackage(packageName);
        }

        public IPackageBinding getRootPackage() {
            return ProjectBuildPathEntry.this.declaringEnvironment.getRootPackage();
        }
    }
}

